/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query;

import java.util.Iterator;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Sequences;
import org.apache.druid.java.util.common.guava.Yielder;
import org.apache.druid.java.util.common.guava.Yielders;
import org.apache.druid.segment.RowAdapter;
import org.apache.druid.segment.RowBasedCursor;
import org.apache.druid.segment.RowWalker;
import org.apache.druid.segment.VirtualColumns;
import org.apache.druid.segment.column.RowSignature;

public class IterableRowsCursorHelper {
    public static RowBasedCursor<Object[]> getCursorFromIterable(Iterable<Object[]> rows, RowSignature rowSignature) {
        RowAdapter rowAdapter = columnName -> {
            if (rowSignature == null) {
                return row -> null;
            }
            int columnIndex = rowSignature.indexOf(columnName);
            if (columnIndex < 0) {
                return row -> null;
            }
            return row -> row[columnIndex];
        };
        RowWalker<Object[]> rowWalker = new RowWalker<Object[]>(Sequences.simple(rows), rowAdapter);
        return new RowBasedCursor<Object[]>(rowWalker, rowAdapter, null, Intervals.ETERNITY, VirtualColumns.EMPTY, Granularities.ALL, false, rowSignature != null ? rowSignature : RowSignature.empty());
    }

    public static RowBasedCursor<Object[]> getCursorFromSequence(final Sequence<Object[]> rows, RowSignature rowSignature) {
        return IterableRowsCursorHelper.getCursorFromIterable(new Iterable<Object[]>(){
            Yielder<Object[]> yielder;
            {
                this.yielder = Yielders.each(rows);
            }

            @Override
            public Iterator<Object[]> iterator() {
                return new Iterator<Object[]>(){

                    @Override
                    public boolean hasNext() {
                        return !yielder.isDone();
                    }

                    @Override
                    public Object[] next() {
                        Object[] retVal = yielder.get();
                        yielder = yielder.next(null);
                        return retVal;
                    }
                };
            }
        }, rowSignature);
    }
}

