/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Supplier;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.query.aggregation.AggregateCombiner;
import org.apache.druid.query.aggregation.Aggregator;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.AggregatorUtil;
import org.apache.druid.query.aggregation.BufferAggregator;
import org.apache.druid.query.aggregation.DoubleSumAggregateCombiner;
import org.apache.druid.query.aggregation.FloatSumAggregator;
import org.apache.druid.query.aggregation.FloatSumBufferAggregator;
import org.apache.druid.query.aggregation.FloatSumVectorAggregator;
import org.apache.druid.query.aggregation.SimpleFloatAggregatorFactory;
import org.apache.druid.query.aggregation.VectorAggregator;
import org.apache.druid.segment.BaseFloatColumnValueSelector;
import org.apache.druid.segment.vector.VectorColumnSelectorFactory;
import org.apache.druid.segment.vector.VectorValueSelector;

public class FloatSumAggregatorFactory
extends SimpleFloatAggregatorFactory {
    private final Supplier<byte[]> cacheKey;

    @JsonCreator
    public FloatSumAggregatorFactory(@JsonProperty(value="name") String name, @JsonProperty(value="fieldName") String fieldName, @JsonProperty(value="expression") @Nullable String expression, @JacksonInject ExprMacroTable macroTable) {
        super(macroTable, name, fieldName, expression);
        this.cacheKey = AggregatorUtil.getSimpleAggregatorCacheKeySupplier((byte)12, fieldName, (Supplier<Expr>)this.fieldExpression);
    }

    public FloatSumAggregatorFactory(String name, String fieldName) {
        this(name, fieldName, null, ExprMacroTable.nil());
    }

    @Override
    protected float nullValue() {
        return 0.0f;
    }

    @Override
    protected Aggregator buildAggregator(BaseFloatColumnValueSelector selector) {
        return new FloatSumAggregator(selector);
    }

    @Override
    protected BufferAggregator buildBufferAggregator(BaseFloatColumnValueSelector selector) {
        return new FloatSumBufferAggregator(selector);
    }

    @Override
    protected VectorAggregator factorizeVector(VectorColumnSelectorFactory columnSelectorFactory, VectorValueSelector selector) {
        return new FloatSumVectorAggregator(selector);
    }

    @Override
    @Nullable
    public Object combine(@Nullable Object lhs, @Nullable Object rhs) {
        if (rhs == null) {
            return lhs;
        }
        if (lhs == null) {
            return rhs;
        }
        return FloatSumAggregator.combineValues(lhs, rhs);
    }

    @Override
    public AggregateCombiner makeAggregateCombiner() {
        return new DoubleSumAggregateCombiner();
    }

    @Override
    public AggregatorFactory getCombiningFactory() {
        return new FloatSumAggregatorFactory(this.name, this.name, null, this.macroTable);
    }

    @Override
    public List<AggregatorFactory> getRequiredColumns() {
        return Collections.singletonList(new FloatSumAggregatorFactory(this.fieldName, this.fieldName, this.expression, this.macroTable));
    }

    @Override
    public AggregatorFactory withName(String newName) {
        return new FloatSumAggregatorFactory(newName, this.getFieldName(), this.getExpression(), this.macroTable);
    }

    @Override
    public byte[] getCacheKey() {
        return (byte[])this.cacheKey.get();
    }

    public String toString() {
        return "FloatSumAggregatorFactory{fieldName='" + this.fieldName + '\'' + ", expression='" + this.expression + '\'' + ", name='" + this.name + '\'' + '}';
    }
}

