/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.first;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.druid.collections.SerializablePair;
import org.apache.druid.java.util.common.UOE;
import org.apache.druid.query.aggregation.AggregateCombiner;
import org.apache.druid.query.aggregation.Aggregator;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.BufferAggregator;
import org.apache.druid.query.aggregation.first.LongFirstAggregator;
import org.apache.druid.query.aggregation.first.LongFirstBufferAggregator;
import org.apache.druid.query.cache.CacheKeyBuilder;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.BaseLongColumnValueSelector;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.NilColumnValueSelector;
import org.apache.druid.segment.column.ColumnType;

public class LongFirstAggregatorFactory
extends AggregatorFactory {
    private static final Aggregator NIL_AGGREGATOR = new LongFirstAggregator((BaseLongColumnValueSelector)NilColumnValueSelector.instance(), NilColumnValueSelector.instance()){

        @Override
        public void aggregate() {
        }
    };
    private static final BufferAggregator NIL_BUFFER_AGGREGATOR = new LongFirstBufferAggregator((BaseLongColumnValueSelector)NilColumnValueSelector.instance(), NilColumnValueSelector.instance()){

        @Override
        public void aggregate(ByteBuffer buf, int position) {
        }
    };
    public static final Comparator<SerializablePair<Long, Long>> VALUE_COMPARATOR = SerializablePair.createNullHandlingComparator(Long::compare, true);
    private final String fieldName;
    private final String timeColumn;
    private final String name;

    @JsonCreator
    public LongFirstAggregatorFactory(@JsonProperty(value="name") String name, @JsonProperty(value="fieldName") String fieldName, @JsonProperty(value="timeColumn") @Nullable String timeColumn) {
        Preconditions.checkNotNull((Object)name, (Object)"Must have a valid, non-null aggregator name");
        Preconditions.checkNotNull((Object)fieldName, (Object)"Must have a valid, non-null fieldName");
        this.name = name;
        this.fieldName = fieldName;
        this.timeColumn = timeColumn == null ? "__time" : timeColumn;
    }

    @Override
    public Aggregator factorize(ColumnSelectorFactory metricFactory) {
        ColumnValueSelector valueSelector = metricFactory.makeColumnValueSelector(this.fieldName);
        if (valueSelector instanceof NilColumnValueSelector) {
            return NIL_AGGREGATOR;
        }
        return new LongFirstAggregator((BaseLongColumnValueSelector)metricFactory.makeColumnValueSelector(this.timeColumn), valueSelector);
    }

    @Override
    public BufferAggregator factorizeBuffered(ColumnSelectorFactory metricFactory) {
        ColumnValueSelector valueSelector = metricFactory.makeColumnValueSelector(this.fieldName);
        if (valueSelector instanceof NilColumnValueSelector) {
            return NIL_BUFFER_AGGREGATOR;
        }
        return new LongFirstBufferAggregator((BaseLongColumnValueSelector)metricFactory.makeColumnValueSelector(this.timeColumn), valueSelector);
    }

    @Override
    public Comparator getComparator() {
        return VALUE_COMPARATOR;
    }

    @Override
    @Nullable
    public Object combine(@Nullable Object lhs, @Nullable Object rhs) {
        if (lhs == null) {
            return rhs;
        }
        if (rhs == null) {
            return lhs;
        }
        Long leftTime = (Long)((SerializablePair)lhs).lhs;
        Long rightTime = (Long)((SerializablePair)rhs).lhs;
        if (leftTime <= rightTime) {
            return lhs;
        }
        return rhs;
    }

    @Override
    public AggregateCombiner makeAggregateCombiner() {
        throw new UOE("LongFirstAggregatorFactory is not supported during ingestion for rollup", new Object[0]);
    }

    @Override
    public AggregatorFactory getCombiningFactory() {
        return new LongFirstAggregatorFactory(this.name, this.name, this.timeColumn){

            @Override
            public Aggregator factorize(ColumnSelectorFactory metricFactory) {
                final ColumnValueSelector selector = metricFactory.makeColumnValueSelector(LongFirstAggregatorFactory.this.name);
                return new LongFirstAggregator(null, null){

                    @Override
                    public void aggregate() {
                        SerializablePair pair = (SerializablePair)selector.getObject();
                        if ((Long)pair.lhs < this.firstTime) {
                            this.firstTime = (Long)pair.lhs;
                            if (pair.rhs != null) {
                                this.firstValue = (Long)pair.rhs;
                                this.rhsNull = false;
                            } else {
                                this.rhsNull = true;
                            }
                        }
                    }
                };
            }

            @Override
            public BufferAggregator factorizeBuffered(ColumnSelectorFactory metricFactory) {
                final ColumnValueSelector selector = metricFactory.makeColumnValueSelector(LongFirstAggregatorFactory.this.name);
                return new LongFirstBufferAggregator(null, null){

                    @Override
                    public void putValue(ByteBuffer buf, int position) {
                        SerializablePair pair = (SerializablePair)selector.getObject();
                        buf.putLong(position, (Long)pair.rhs);
                    }

                    @Override
                    public void aggregate(ByteBuffer buf, int position) {
                        SerializablePair pair = (SerializablePair)selector.getObject();
                        long firstTime = buf.getLong(position);
                        if ((Long)pair.lhs < firstTime) {
                            if (pair.rhs != null) {
                                this.updateTimeWithValue(buf, position, (Long)pair.lhs);
                            } else {
                                this.updateTimeWithNull(buf, position, (Long)pair.lhs);
                            }
                        }
                    }

                    @Override
                    public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                        inspector.visit("selector", selector);
                    }
                };
            }
        };
    }

    @Override
    public List<AggregatorFactory> getRequiredColumns() {
        return Collections.singletonList(new LongFirstAggregatorFactory(this.fieldName, this.fieldName, this.timeColumn));
    }

    @Override
    public Object deserialize(Object object) {
        Map map = (Map)object;
        if (map.get("rhs") == null) {
            return new SerializablePair<Long, Object>(((Number)map.get("lhs")).longValue(), null);
        }
        return new SerializablePair<Long, Long>(((Number)map.get("lhs")).longValue(), ((Number)map.get("rhs")).longValue());
    }

    @Override
    @Nullable
    public Object finalizeComputation(@Nullable Object object) {
        return object == null ? null : (Long)((SerializablePair)object).rhs;
    }

    @Override
    @JsonProperty
    public String getName() {
        return this.name;
    }

    @JsonProperty
    public String getFieldName() {
        return this.fieldName;
    }

    @JsonProperty
    public String getTimeColumn() {
        return this.timeColumn;
    }

    @Override
    public List<String> requiredFields() {
        return Arrays.asList(this.timeColumn, this.fieldName);
    }

    @Override
    public byte[] getCacheKey() {
        return new CacheKeyBuilder(23).appendString(this.fieldName).appendString(this.timeColumn).build();
    }

    @Override
    public ColumnType getIntermediateType() {
        return ColumnType.LONG;
    }

    @Override
    public ColumnType getResultType() {
        return ColumnType.LONG;
    }

    @Override
    public int getMaxIntermediateSize() {
        return 17;
    }

    @Override
    public AggregatorFactory withName(String newName) {
        return new LongFirstAggregatorFactory(newName, this.getFieldName(), this.getTimeColumn());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LongFirstAggregatorFactory that = (LongFirstAggregatorFactory)o;
        return this.fieldName.equals(that.fieldName) && this.timeColumn.equals(that.timeColumn) && this.name.equals(that.name);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.fieldName.hashCode();
        return result;
    }

    public String toString() {
        return "LongFirstAggregatorFactory{name='" + this.name + '\'' + ", fieldName='" + this.fieldName + '\'' + ", timeColumn='" + this.timeColumn + '\'' + '}';
    }
}

