/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.first;

import java.nio.ByteBuffer;
import org.apache.druid.collections.SerializablePair;
import org.apache.druid.query.aggregation.first.NumericFirstBufferAggregator;
import org.apache.druid.segment.BaseLongColumnValueSelector;

public class LongFirstBufferAggregator
extends NumericFirstBufferAggregator<BaseLongColumnValueSelector> {
    public LongFirstBufferAggregator(BaseLongColumnValueSelector timeSelector, BaseLongColumnValueSelector valueSelector) {
        super(timeSelector, valueSelector);
    }

    @Override
    void initValue(ByteBuffer buf, int position) {
        buf.putLong(position, 0L);
    }

    @Override
    void putValue(ByteBuffer buf, int position) {
        buf.putLong(position, ((BaseLongColumnValueSelector)this.valueSelector).getLong());
    }

    @Override
    public Object get(ByteBuffer buf, int position) {
        boolean rhsNull = this.isValueNull(buf, position);
        return new SerializablePair<Long, Object>(buf.getLong(position), (rhsNull ? null : Long.valueOf(buf.getLong(position + 9))));
    }

    @Override
    public float getFloat(ByteBuffer buf, int position) {
        return buf.getLong(position + 9);
    }

    @Override
    public long getLong(ByteBuffer buf, int position) {
        return buf.getLong(position + 9);
    }

    @Override
    public double getDouble(ByteBuffer buf, int position) {
        return buf.getLong(position + 9);
    }
}

