/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.last;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.collections.SerializablePair;
import org.apache.druid.java.util.common.UOE;
import org.apache.druid.query.aggregation.AggregateCombiner;
import org.apache.druid.query.aggregation.Aggregator;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.BufferAggregator;
import org.apache.druid.query.aggregation.VectorAggregator;
import org.apache.druid.query.aggregation.any.NumericNilVectorAggregator;
import org.apache.druid.query.aggregation.first.DoubleFirstAggregatorFactory;
import org.apache.druid.query.aggregation.first.LongFirstAggregatorFactory;
import org.apache.druid.query.aggregation.last.DoubleLastAggregator;
import org.apache.druid.query.aggregation.last.DoubleLastBufferAggregator;
import org.apache.druid.query.aggregation.last.DoubleLastVectorAggregator;
import org.apache.druid.query.cache.CacheKeyBuilder;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.BaseLongColumnValueSelector;
import org.apache.druid.segment.ColumnInspector;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.NilColumnValueSelector;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnHolder;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.vector.BaseLongVectorValueSelector;
import org.apache.druid.segment.vector.VectorColumnSelectorFactory;
import org.apache.druid.segment.vector.VectorValueSelector;

public class DoubleLastAggregatorFactory
extends AggregatorFactory {
    private static final Aggregator NIL_AGGREGATOR = new DoubleLastAggregator((BaseLongColumnValueSelector)NilColumnValueSelector.instance(), NilColumnValueSelector.instance()){

        @Override
        public void aggregate() {
        }
    };
    private static final BufferAggregator NIL_BUFFER_AGGREGATOR = new DoubleLastBufferAggregator((BaseLongColumnValueSelector)NilColumnValueSelector.instance(), NilColumnValueSelector.instance()){

        @Override
        public void aggregate(ByteBuffer buf, int position) {
        }
    };
    private final String fieldName;
    private final String timeColumn;
    private final String name;
    private final boolean storeDoubleAsFloat;

    @JsonCreator
    public DoubleLastAggregatorFactory(@JsonProperty(value="name") String name, @JsonProperty(value="fieldName") String fieldName, @JsonProperty(value="timeColumn") @Nullable String timeColumn) {
        Preconditions.checkNotNull((Object)name, (Object)"Must have a valid, non-null aggregator name");
        Preconditions.checkNotNull((Object)fieldName, (Object)"Must have a valid, non-null fieldName");
        this.name = name;
        this.fieldName = fieldName;
        this.timeColumn = timeColumn == null ? "__time" : timeColumn;
        this.storeDoubleAsFloat = ColumnHolder.storeDoubleAsFloat();
    }

    @Override
    public Aggregator factorize(ColumnSelectorFactory metricFactory) {
        ColumnValueSelector valueSelector = metricFactory.makeColumnValueSelector(this.fieldName);
        if (valueSelector instanceof NilColumnValueSelector) {
            return NIL_AGGREGATOR;
        }
        return new DoubleLastAggregator((BaseLongColumnValueSelector)metricFactory.makeColumnValueSelector(this.timeColumn), valueSelector);
    }

    @Override
    public boolean canVectorize(ColumnInspector columnInspector) {
        return true;
    }

    @Override
    public VectorAggregator factorizeVector(VectorColumnSelectorFactory columnSelectorFactory) {
        ColumnCapabilities capabilities = columnSelectorFactory.getColumnCapabilities(this.fieldName);
        VectorValueSelector valueSelector = columnSelectorFactory.makeValueSelector(this.fieldName);
        BaseLongVectorValueSelector timeSelector = (BaseLongVectorValueSelector)columnSelectorFactory.makeValueSelector(this.timeColumn);
        if (capabilities == null || capabilities.isNumeric()) {
            return new DoubleLastVectorAggregator(timeSelector, valueSelector);
        }
        return NumericNilVectorAggregator.doubleNilVectorAggregator();
    }

    @Override
    public BufferAggregator factorizeBuffered(ColumnSelectorFactory metricFactory) {
        ColumnValueSelector valueSelector = metricFactory.makeColumnValueSelector(this.fieldName);
        if (valueSelector instanceof NilColumnValueSelector) {
            return NIL_BUFFER_AGGREGATOR;
        }
        return new DoubleLastBufferAggregator((BaseLongColumnValueSelector)metricFactory.makeColumnValueSelector(this.timeColumn), valueSelector);
    }

    @Override
    public Comparator getComparator() {
        return DoubleFirstAggregatorFactory.VALUE_COMPARATOR;
    }

    @Override
    @Nullable
    public Object combine(@Nullable Object lhs, @Nullable Object rhs) {
        if (rhs == null) {
            return lhs;
        }
        if (lhs == null) {
            return rhs;
        }
        Long leftTime = (Long)((SerializablePair)lhs).lhs;
        Long rightTime = (Long)((SerializablePair)rhs).lhs;
        if (leftTime >= rightTime) {
            return lhs;
        }
        return rhs;
    }

    @Override
    public AggregateCombiner makeAggregateCombiner() {
        throw new UOE("DoubleLastAggregatorFactory is not supported during ingestion for rollup", new Object[0]);
    }

    @Override
    public AggregatorFactory getCombiningFactory() {
        return new DoubleLastAggregatorFactory(this.name, this.name, this.timeColumn){

            @Override
            public Aggregator factorize(ColumnSelectorFactory metricFactory) {
                final ColumnValueSelector selector = metricFactory.makeColumnValueSelector(DoubleLastAggregatorFactory.this.name);
                return new DoubleLastAggregator(null, null){

                    @Override
                    public void aggregate() {
                        SerializablePair pair = (SerializablePair)selector.getObject();
                        if ((Long)pair.lhs >= this.lastTime) {
                            this.lastTime = (Long)pair.lhs;
                            if (pair.rhs != null) {
                                this.lastValue = (Double)pair.rhs;
                                this.rhsNull = false;
                            } else {
                                this.rhsNull = true;
                            }
                        }
                    }
                };
            }

            @Override
            public BufferAggregator factorizeBuffered(ColumnSelectorFactory metricFactory) {
                final ColumnValueSelector selector = metricFactory.makeColumnValueSelector(DoubleLastAggregatorFactory.this.name);
                return new DoubleLastBufferAggregator(null, null){

                    @Override
                    public void putValue(ByteBuffer buf, int position) {
                        SerializablePair pair = (SerializablePair)selector.getObject();
                        buf.putDouble(position, (Double)pair.rhs);
                    }

                    @Override
                    public void aggregate(ByteBuffer buf, int position) {
                        SerializablePair pair = (SerializablePair)selector.getObject();
                        long lastTime = buf.getLong(position);
                        if ((Long)pair.lhs >= lastTime) {
                            if (pair.rhs != null) {
                                this.updateTimeWithValue(buf, position, (Long)pair.lhs);
                            } else {
                                this.updateTimeWithNull(buf, position, (Long)pair.lhs);
                            }
                        }
                    }

                    @Override
                    public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                        inspector.visit("selector", selector);
                    }
                };
            }
        };
    }

    @Override
    public List<AggregatorFactory> getRequiredColumns() {
        return Collections.singletonList(new LongFirstAggregatorFactory(this.fieldName, this.fieldName, this.timeColumn));
    }

    @Override
    public Object deserialize(Object object) {
        Map map = (Map)object;
        if (map.get("rhs") == null) {
            return new SerializablePair<Long, Object>(((Number)map.get("lhs")).longValue(), null);
        }
        return new SerializablePair<Long, Double>(((Number)map.get("lhs")).longValue(), ((Number)map.get("rhs")).doubleValue());
    }

    @Override
    @Nullable
    public Object finalizeComputation(@Nullable Object object) {
        return object == null ? null : (Double)((SerializablePair)object).rhs;
    }

    @Override
    @JsonProperty
    public String getName() {
        return this.name;
    }

    @JsonProperty
    public String getFieldName() {
        return this.fieldName;
    }

    @JsonProperty
    public String getTimeColumn() {
        return this.timeColumn;
    }

    @Override
    public List<String> requiredFields() {
        return Arrays.asList(this.timeColumn, this.fieldName);
    }

    @Override
    public byte[] getCacheKey() {
        return new CacheKeyBuilder(21).appendString(this.fieldName).appendString(this.timeColumn).build();
    }

    @Override
    public ColumnType getIntermediateType() {
        return this.storeDoubleAsFloat ? ColumnType.FLOAT : ColumnType.DOUBLE;
    }

    @Override
    public ColumnType getResultType() {
        return this.storeDoubleAsFloat ? ColumnType.FLOAT : ColumnType.DOUBLE;
    }

    @Override
    public int getMaxIntermediateSize() {
        return 17;
    }

    @Override
    public AggregatorFactory withName(String newName) {
        return new DoubleLastAggregatorFactory(newName, this.getFieldName(), this.getTimeColumn());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DoubleLastAggregatorFactory that = (DoubleLastAggregatorFactory)o;
        return this.fieldName.equals(that.fieldName) && this.timeColumn.equals(that.timeColumn) && this.name.equals(that.name);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.fieldName, this.timeColumn);
    }

    public String toString() {
        return "DoubleLastAggregatorFactory{name='" + this.name + '\'' + ", fieldName='" + this.fieldName + '\'' + ", timeColumn='" + this.timeColumn + '\'' + '}';
    }
}

