/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.last;

import java.nio.ByteBuffer;
import org.apache.druid.collections.SerializablePair;
import org.apache.druid.query.aggregation.last.NumericLastBufferAggregator;
import org.apache.druid.segment.BaseFloatColumnValueSelector;
import org.apache.druid.segment.BaseLongColumnValueSelector;

public class FloatLastBufferAggregator
extends NumericLastBufferAggregator<BaseFloatColumnValueSelector> {
    public FloatLastBufferAggregator(BaseLongColumnValueSelector timeSelector, BaseFloatColumnValueSelector valueSelector) {
        super(timeSelector, valueSelector);
    }

    @Override
    void initValue(ByteBuffer buf, int position) {
        buf.putFloat(position, 0.0f);
    }

    @Override
    void putValue(ByteBuffer buf, int position) {
        buf.putFloat(position, ((BaseFloatColumnValueSelector)this.valueSelector).getFloat());
    }

    @Override
    public Object get(ByteBuffer buf, int position) {
        boolean rhsNull = this.isValueNull(buf, position);
        return new SerializablePair<Long, Object>(buf.getLong(position), (rhsNull ? null : Float.valueOf(buf.getFloat(position + 9))));
    }

    @Override
    public float getFloat(ByteBuffer buf, int position) {
        return buf.getFloat(position + 9);
    }

    @Override
    public long getLong(ByteBuffer buf, int position) {
        return (long)buf.getFloat(position + 9);
    }

    @Override
    public double getDouble(ByteBuffer buf, int position) {
        return buf.getFloat(position + 9);
    }
}

