/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.post;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.query.Queries;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.DoubleSumAggregator;
import org.apache.druid.query.aggregation.PostAggregator;
import org.apache.druid.query.cache.CacheKeyBuilder;
import org.apache.druid.segment.ColumnInspector;
import org.apache.druid.segment.column.ColumnType;

public class ArithmeticPostAggregator
implements PostAggregator {
    public static final Comparator DEFAULT_COMPARATOR = DoubleSumAggregator.COMPARATOR;
    private final String name;
    private final String fnName;
    private final List<PostAggregator> fields;
    private final Ops op;
    private final Comparator comparator;
    private final String ordering;

    public ArithmeticPostAggregator(String name, String fnName, List<PostAggregator> fields) {
        this(name, fnName, fields, null);
    }

    @JsonCreator
    public ArithmeticPostAggregator(@JsonProperty(value="name") String name, @JsonProperty(value="fn") String fnName, @JsonProperty(value="fields") List<PostAggregator> fields, @JsonProperty(value="ordering") @Nullable String ordering) {
        Preconditions.checkArgument((fnName != null ? 1 : 0) != 0, (Object)"fn cannot not be null");
        Preconditions.checkArgument((fields != null && fields.size() > 1 ? 1 : 0) != 0, (String)"Illegal number of fields[%s], must be > 1", (Object[])new Object[]{fields.size()});
        this.name = name;
        this.fnName = fnName;
        this.fields = fields;
        this.op = Ops.lookup(fnName);
        if (this.op == null) {
            throw new IAE("Unknown operation[%s], known operations[%s]", fnName, Ops.getFns());
        }
        this.ordering = ordering;
        this.comparator = ordering == null ? DEFAULT_COMPARATOR : Ordering.valueOf(ordering);
    }

    @Override
    public Set<String> getDependentFields() {
        HashSet<String> dependentFields = new HashSet<String>();
        for (PostAggregator field : this.fields) {
            dependentFields.addAll(field.getDependentFields());
        }
        return dependentFields;
    }

    @Override
    public Comparator getComparator() {
        return this.comparator;
    }

    @Override
    public Object compute(Map<String, Object> values) {
        Iterator<PostAggregator> fieldsIter = this.fields.iterator();
        Double retVal = NullHandling.defaultDoubleValue();
        if (fieldsIter.hasNext()) {
            Number nextVal = (Number)fieldsIter.next().compute(values);
            if (nextVal == null) {
                return null;
            }
            retVal = nextVal.doubleValue();
            while (fieldsIter.hasNext()) {
                nextVal = (Number)fieldsIter.next().compute(values);
                if (nextVal == null) {
                    return null;
                }
                retVal = this.op.compute(retVal, nextVal.doubleValue());
            }
        }
        return retVal;
    }

    @Override
    @JsonProperty
    public String getName() {
        return this.name;
    }

    @Override
    public ColumnType getType(ColumnInspector signature) {
        return ColumnType.DOUBLE;
    }

    @Override
    public ArithmeticPostAggregator decorate(Map<String, AggregatorFactory> aggregators) {
        return new ArithmeticPostAggregator(this.name, this.fnName, Queries.decoratePostAggregators(this.fields, aggregators), this.ordering);
    }

    @Override
    public byte[] getCacheKey() {
        CacheKeyBuilder builder = new CacheKeyBuilder(0).appendString(this.fnName).appendString(this.ordering);
        if (ArithmeticPostAggregator.preserveFieldOrderInCacheKey(this.op)) {
            builder.appendCacheables(this.fields);
        } else {
            builder.appendCacheablesIgnoringOrder(this.fields);
        }
        return builder.build();
    }

    @JsonProperty(value="fn")
    public String getFnName() {
        return this.fnName;
    }

    @JsonProperty(value="ordering")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getOrdering() {
        return this.ordering;
    }

    @JsonProperty
    public List<PostAggregator> getFields() {
        return this.fields;
    }

    public String toString() {
        return "ArithmeticPostAggregator{name='" + this.name + '\'' + ", fnName='" + this.fnName + '\'' + ", fields=" + this.fields + ", op=" + (Object)((Object)this.op) + '}';
    }

    private static boolean preserveFieldOrderInCacheKey(Ops op) {
        switch (op) {
            case PLUS: 
            case MULT: {
                return false;
            }
            case MINUS: 
            case DIV: 
            case QUOTIENT: 
            case POW: {
                return true;
            }
        }
        throw new IAE(op.fn, new Object[0]);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ArithmeticPostAggregator that = (ArithmeticPostAggregator)o;
        if (!this.comparator.equals(that.comparator)) {
            return false;
        }
        if (!this.fields.equals(that.fields)) {
            return false;
        }
        if (!this.fnName.equals(that.fnName)) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.op != that.op) {
            return false;
        }
        return !(this.ordering != null ? !this.ordering.equals(that.ordering) : that.ordering != null);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + this.fnName.hashCode();
        result = 31 * result + this.fields.hashCode();
        result = 31 * result + this.op.hashCode();
        result = 31 * result + this.comparator.hashCode();
        result = 31 * result + (this.ordering != null ? this.ordering.hashCode() : 0);
        return result;
    }

    public static enum Ordering implements Comparator<Double>
    {
        numericFirst{

            @Override
            public int compare(Double lhs, Double rhs) {
                if (Double.isFinite(lhs) && !Double.isFinite(rhs)) {
                    return 1;
                }
                if (!Double.isFinite(lhs) && Double.isFinite(rhs)) {
                    return -1;
                }
                return Double.compare(lhs, rhs);
            }
        };

    }

    private static enum Ops {
        PLUS("+"){

            @Override
            public double compute(double lhs, double rhs) {
                return lhs + rhs;
            }
        }
        ,
        MINUS("-"){

            @Override
            public double compute(double lhs, double rhs) {
                return lhs - rhs;
            }
        }
        ,
        MULT("*"){

            @Override
            public double compute(double lhs, double rhs) {
                return lhs * rhs;
            }
        }
        ,
        DIV("/"){

            @Override
            public double compute(double lhs, double rhs) {
                return rhs == 0.0 ? 0.0 : lhs / rhs;
            }
        }
        ,
        QUOTIENT("quotient"){

            @Override
            public double compute(double lhs, double rhs) {
                return lhs / rhs;
            }
        }
        ,
        POW("pow"){

            @Override
            public double compute(double lhs, double rhs) {
                return Math.pow(lhs, rhs);
            }
        };

        private static final Map<String, Ops> LOOKUP_MAP;
        private final String fn;

        private Ops(String fn) {
            this.fn = fn;
        }

        public String getFn() {
            return this.fn;
        }

        public abstract double compute(double var1, double var3);

        static Ops lookup(String fn) {
            return LOOKUP_MAP.get(fn);
        }

        static Set<String> getFns() {
            return LOOKUP_MAP.keySet();
        }

        static {
            LOOKUP_MAP = new HashMap<String, Ops>();
            for (Ops op : Ops.values()) {
                LOOKUP_MAP.put(op.getFn(), op);
            }
        }
    }
}

