/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.post;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.query.Queries;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.PostAggregator;
import org.apache.druid.query.cache.CacheKeyBuilder;
import org.apache.druid.segment.ColumnInspector;
import org.apache.druid.segment.column.ColumnType;

public class LongLeastPostAggregator
implements PostAggregator {
    private static final Comparator<Number> COMPARATOR = Comparator.nullsLast(Comparator.comparingLong(Number::longValue));
    private final String name;
    private final List<PostAggregator> fields;

    @JsonCreator
    public LongLeastPostAggregator(@JsonProperty(value="name") String name, @JsonProperty(value="fields") List<PostAggregator> fields) {
        Preconditions.checkArgument((fields != null && fields.size() > 0 ? 1 : 0) != 0, (String)"Illegal number of fields[%s], must be > 0", (Object[])new Object[]{fields.size()});
        this.name = name;
        this.fields = fields;
    }

    @Override
    public Set<String> getDependentFields() {
        HashSet<String> dependentFields = new HashSet<String>();
        for (PostAggregator field : this.fields) {
            dependentFields.addAll(field.getDependentFields());
        }
        return dependentFields;
    }

    @Override
    public Comparator getComparator() {
        return COMPARATOR;
    }

    @Override
    public Object compute(Map<String, Object> values) {
        Long retVal;
        Iterator<PostAggregator> fieldsIter = this.fields.iterator();
        Long l = retVal = NullHandling.replaceWithDefault() ? Long.valueOf(Long.MAX_VALUE) : null;
        while (fieldsIter.hasNext()) {
            Number nextVal = (Number)fieldsIter.next().compute(values);
            if (nextVal == null || retVal != null && COMPARATOR.compare(nextVal, retVal) >= 0) continue;
            if (nextVal instanceof Long) {
                retVal = (Long)nextVal;
                continue;
            }
            retVal = nextVal.longValue();
        }
        return retVal;
    }

    @Override
    @JsonProperty
    public String getName() {
        return this.name;
    }

    @Override
    public ColumnType getType(ColumnInspector signature) {
        return ColumnType.LONG;
    }

    @Override
    public LongLeastPostAggregator decorate(Map<String, AggregatorFactory> aggregators) {
        return new LongLeastPostAggregator(this.name, Queries.decoratePostAggregators(this.fields, aggregators));
    }

    @JsonProperty
    public List<PostAggregator> getFields() {
        return this.fields;
    }

    public String toString() {
        return "LongLeastPostAggregator{name='" + this.name + '\'' + ", fields=" + this.fields + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LongLeastPostAggregator that = (LongLeastPostAggregator)o;
        if (!this.fields.equals(that.fields)) {
            return false;
        }
        return !(this.name != null ? !this.name.equals(that.name) : that.name != null);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + this.fields.hashCode();
        return result;
    }

    @Override
    public byte[] getCacheKey() {
        return new CacheKeyBuilder(8).appendCacheablesIgnoringOrder(this.fields).build();
    }
}

