/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.expression;

import com.google.inject.Inject;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.query.cache.CacheKeyBuilder;
import org.apache.druid.query.lookup.LookupExtractorFactoryContainerProvider;
import org.apache.druid.query.lookup.RegisteredLookupExtractionFn;

public class LookupExprMacro
implements ExprMacroTable.ExprMacro {
    private static final String FN_NAME = "lookup";
    private final LookupExtractorFactoryContainerProvider lookupExtractorFactoryContainerProvider;

    @Inject
    public LookupExprMacro(LookupExtractorFactoryContainerProvider lookupExtractorFactoryContainerProvider) {
        this.lookupExtractorFactoryContainerProvider = lookupExtractorFactoryContainerProvider;
    }

    @Override
    public String name() {
        return FN_NAME;
    }

    @Override
    public Expr apply(final List<Expr> args) {
        this.validationHelperCheckArgumentCount(args, 2);
        Expr arg = args.get(0);
        final Expr lookupExpr = args.get(1);
        this.validationHelperCheckArgIsLiteral(lookupExpr, "second argument");
        if (lookupExpr.getLiteralValue() == null) {
            throw this.validationFailed("second argument must be a registered lookup name", new Object[0]);
        }
        String lookupName = lookupExpr.getLiteralValue().toString();
        final RegisteredLookupExtractionFn extractionFn = new RegisteredLookupExtractionFn(this.lookupExtractorFactoryContainerProvider, lookupName, false, null, false, null);
        class LookupExpr
        extends ExprMacroTable.BaseScalarUnivariateMacroFunctionExpr {
            LookupExpr(Expr arg) {
                super(LookupExprMacro.FN_NAME, arg);
            }

            @Override
            @Nonnull
            public ExprEval eval(Expr.ObjectBinding bindings) {
                return ExprEval.of(extractionFn.apply(NullHandling.emptyToNullIfNeeded(this.arg.eval(bindings).asString())));
            }

            @Override
            public Expr visit(Expr.Shuttle shuttle) {
                return shuttle.visit(LookupExprMacro.this.apply(shuttle.visitAll(args)));
            }

            @Override
            @Nullable
            public ExpressionType getOutputType(Expr.InputBindingInspector inspector) {
                return ExpressionType.STRING;
            }

            @Override
            public String stringify() {
                return StringUtils.format("%s(%s, %s)", LookupExprMacro.FN_NAME, this.arg.stringify(), lookupExpr.stringify());
            }

            @Override
            public void decorateCacheKeyBuilder(CacheKeyBuilder builder) {
                builder.appendCacheable(extractionFn);
            }
        }
        return new LookupExpr(arg);
    }
}

