/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.filter;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.google.common.collect.RangeSet;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.Cacheable;
import org.apache.druid.query.extraction.ExtractionFn;
import org.apache.druid.query.filter.AndDimFilter;
import org.apache.druid.query.filter.BoundDimFilter;
import org.apache.druid.query.filter.ColumnComparisonDimFilter;
import org.apache.druid.query.filter.EqualityFilter;
import org.apache.druid.query.filter.ExpressionDimFilter;
import org.apache.druid.query.filter.ExtractionDimFilter;
import org.apache.druid.query.filter.FalseDimFilter;
import org.apache.druid.query.filter.Filter;
import org.apache.druid.query.filter.FilterTuning;
import org.apache.druid.query.filter.InDimFilter;
import org.apache.druid.query.filter.IntervalDimFilter;
import org.apache.druid.query.filter.JavaScriptDimFilter;
import org.apache.druid.query.filter.LikeDimFilter;
import org.apache.druid.query.filter.NotDimFilter;
import org.apache.druid.query.filter.NullFilter;
import org.apache.druid.query.filter.OrDimFilter;
import org.apache.druid.query.filter.RangeFilter;
import org.apache.druid.query.filter.RegexDimFilter;
import org.apache.druid.query.filter.SearchQueryDimFilter;
import org.apache.druid.query.filter.SelectorDimFilter;
import org.apache.druid.query.filter.SpatialDimFilter;
import org.apache.druid.query.filter.TrueDimFilter;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type")
@JsonSubTypes(value={@JsonSubTypes.Type(name="and", value=AndDimFilter.class), @JsonSubTypes.Type(name="or", value=OrDimFilter.class), @JsonSubTypes.Type(name="not", value=NotDimFilter.class), @JsonSubTypes.Type(name="selector", value=SelectorDimFilter.class), @JsonSubTypes.Type(name="columnComparison", value=ColumnComparisonDimFilter.class), @JsonSubTypes.Type(name="extraction", value=ExtractionDimFilter.class), @JsonSubTypes.Type(name="regex", value=RegexDimFilter.class), @JsonSubTypes.Type(name="search", value=SearchQueryDimFilter.class), @JsonSubTypes.Type(name="javascript", value=JavaScriptDimFilter.class), @JsonSubTypes.Type(name="spatial", value=SpatialDimFilter.class), @JsonSubTypes.Type(name="in", value=InDimFilter.class), @JsonSubTypes.Type(name="bound", value=BoundDimFilter.class), @JsonSubTypes.Type(name="interval", value=IntervalDimFilter.class), @JsonSubTypes.Type(name="like", value=LikeDimFilter.class), @JsonSubTypes.Type(name="expression", value=ExpressionDimFilter.class), @JsonSubTypes.Type(name="true", value=TrueDimFilter.class), @JsonSubTypes.Type(name="false", value=FalseDimFilter.class), @JsonSubTypes.Type(name="null", value=NullFilter.class), @JsonSubTypes.Type(name="equals", value=EqualityFilter.class), @JsonSubTypes.Type(name="range", value=RangeFilter.class)})
public interface DimFilter
extends Cacheable {
    public DimFilter optimize();

    public Filter toOptimizedFilter();

    public Filter toFilter();

    @Nullable
    public RangeSet<String> getDimensionRangeSet(String var1);

    public Set<String> getRequiredColumns();

    public static class DimFilterToStringBuilder {
        private final StringBuilder builder = new StringBuilder();

        DimFilterToStringBuilder appendDimension(String dimension, @Nullable ExtractionFn extractionFn) {
            if (extractionFn != null) {
                this.builder.append(extractionFn).append("(");
            }
            this.builder.append(dimension);
            if (extractionFn != null) {
                this.builder.append(")");
            }
            return this;
        }

        DimFilterToStringBuilder appendEquals(String value) {
            this.builder.append(" = ").append(value);
            return this;
        }

        DimFilterToStringBuilder appendFilterTuning(@Nullable FilterTuning tuning) {
            if (tuning != null) {
                this.builder.append(" (filterTuning=").append(tuning).append(")");
            }
            return this;
        }

        <T> DimFilterToStringBuilder append(T s) {
            this.builder.append(s);
            return this;
        }

        public String build() {
            return this.builder.toString();
        }
    }
}

