/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.filter;

import com.google.common.base.Predicate;
import javax.annotation.Nullable;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.ExpressionType;

public class FallbackPredicate<T>
implements Predicate<T> {
    private final Predicate<T> delegate;
    private final ExpressionType expectedType;
    private boolean needsCast = false;

    public FallbackPredicate(Predicate<T> delegate, ExpressionType expectedType) {
        this.delegate = delegate;
        this.expectedType = expectedType;
    }

    public boolean apply(@Nullable T input) {
        if (this.needsCast) {
            return this.castApply(input);
        }
        try {
            return this.delegate.apply(input);
        }
        catch (ClassCastException caster) {
            this.needsCast = true;
            return this.castApply(input);
        }
    }

    private boolean castApply(@Nullable T input) {
        ExprEval castEval = ExprEval.bestEffortOf(input).castTo(this.expectedType);
        return this.delegate.apply(castEval.value());
    }
}

