/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.filter;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.RangeSet;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Set;
import org.apache.druid.query.filter.AbstractOptimizableDimFilter;
import org.apache.druid.query.filter.AndDimFilter;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.FalseDimFilter;
import org.apache.druid.query.filter.Filter;
import org.apache.druid.query.filter.OrDimFilter;
import org.apache.druid.query.filter.TrueDimFilter;
import org.apache.druid.segment.filter.NotFilter;

public class NotDimFilter
extends AbstractOptimizableDimFilter
implements DimFilter {
    private final DimFilter field;

    @JsonCreator
    public NotDimFilter(@JsonProperty(value="field") DimFilter field) {
        Preconditions.checkArgument((field != null ? 1 : 0) != 0, (Object)"NOT operator requires at least one field");
        this.field = field;
    }

    @JsonProperty(value="field")
    public DimFilter getField() {
        return this.field;
    }

    @Override
    public byte[] getCacheKey() {
        byte[] subKey = this.field.getCacheKey();
        return ByteBuffer.allocate(1 + subKey.length).put((byte)3).put(subKey).array();
    }

    @Override
    public DimFilter optimize() {
        DimFilter optimized = this.getField().optimize();
        if (optimized == FalseDimFilter.instance()) {
            return TrueDimFilter.instance();
        }
        if (optimized == TrueDimFilter.instance()) {
            return FalseDimFilter.instance();
        }
        return new NotDimFilter(optimized);
    }

    @Override
    public Filter toFilter() {
        return new NotFilter(this.field.toFilter());
    }

    @Override
    public RangeSet<String> getDimensionRangeSet(String dimension) {
        if (this.field instanceof AndDimFilter) {
            List<DimFilter> fields = ((AndDimFilter)this.field).getFields();
            return new OrDimFilter(Lists.transform(fields, NotDimFilter::new)).getDimensionRangeSet(dimension);
        }
        if (this.field instanceof OrDimFilter) {
            List<DimFilter> fields = ((OrDimFilter)this.field).getFields();
            return new AndDimFilter(Lists.transform(fields, NotDimFilter::new)).getDimensionRangeSet(dimension);
        }
        if (this.field instanceof NotDimFilter) {
            return ((NotDimFilter)this.field).getField().getDimensionRangeSet(dimension);
        }
        RangeSet<String> rangeSet = this.field.getDimensionRangeSet(dimension);
        return rangeSet == null ? null : rangeSet.complement();
    }

    @Override
    public Set<String> getRequiredColumns() {
        return this.field.getRequiredColumns();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NotDimFilter that = (NotDimFilter)o;
        return !(this.field != null ? !this.field.equals(that.field) : that.field != null);
    }

    public int hashCode() {
        return this.field != null ? this.field.hashCode() : 0;
    }

    public String toString() {
        return "!" + this.field;
    }
}

