/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.filter.vector;

import com.google.common.base.Predicate;
import javax.annotation.Nullable;
import org.apache.druid.query.filter.DruidPredicateFactory;
import org.apache.druid.query.filter.vector.BaseVectorValueMatcher;
import org.apache.druid.query.filter.vector.ReadableVectorMatch;
import org.apache.druid.query.filter.vector.VectorMatch;
import org.apache.druid.query.filter.vector.VectorValueMatcher;
import org.apache.druid.query.filter.vector.VectorValueMatcherFactory;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.TypeSignature;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.vector.VectorObjectSelector;

public class ArrayVectorValueMatcher
implements VectorValueMatcherFactory {
    protected final TypeSignature<ValueType> columnType;
    protected final VectorObjectSelector selector;

    public ArrayVectorValueMatcher(TypeSignature<ValueType> columnType, VectorObjectSelector selector) {
        this.columnType = columnType;
        this.selector = selector;
    }

    @Override
    public VectorValueMatcher makeMatcher(@Nullable String value) {
        throw new UnsupportedOperationException("Vectorized matcher cannot make string matcher for ARRAY types");
    }

    @Override
    public VectorValueMatcher makeMatcher(Object matchValue, ColumnType matchValueType) {
        throw new UnsupportedOperationException("Vectorized matcher cannot make object matcher for ARRAY types");
    }

    @Override
    public VectorValueMatcher makeMatcher(DruidPredicateFactory predicateFactory) {
        final Predicate<Object[]> predicate = predicateFactory.makeArrayPredicate(this.columnType);
        return new BaseVectorValueMatcher(this.selector){
            final VectorMatch match;
            {
                super(selector);
                this.match = VectorMatch.wrap(new int[ArrayVectorValueMatcher.this.selector.getMaxVectorSize()]);
            }

            @Override
            public ReadableVectorMatch match(ReadableVectorMatch mask) {
                Object[] vector = ArrayVectorValueMatcher.this.selector.getObjectVector();
                int[] selection = this.match.getSelection();
                int numRows = 0;
                for (int i = 0; i < mask.getSelectionSize(); ++i) {
                    int rowNum = mask.getSelection()[i];
                    Object o = vector[rowNum];
                    if (o == null || o instanceof Object[]) {
                        if (!predicate.apply((Object)((Object[])o))) continue;
                        selection[numRows++] = rowNum;
                        continue;
                    }
                    if (!predicate.apply((Object)new Object[]{o})) continue;
                    selection[numRows++] = rowNum;
                }
                this.match.setSelectionSize(numRows);
                return this.match;
            }
        };
    }
}

