/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.filter.vector;

import javax.annotation.Nullable;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.query.filter.DruidFloatPredicate;
import org.apache.druid.query.filter.DruidPredicateFactory;
import org.apache.druid.query.filter.vector.BaseVectorValueMatcher;
import org.apache.druid.query.filter.vector.BooleanVectorValueMatcher;
import org.apache.druid.query.filter.vector.ReadableVectorMatch;
import org.apache.druid.query.filter.vector.VectorMatch;
import org.apache.druid.query.filter.vector.VectorValueMatcher;
import org.apache.druid.query.filter.vector.VectorValueMatcherFactory;
import org.apache.druid.segment.DimensionHandlerUtils;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.vector.VectorValueSelector;

public class FloatVectorValueMatcher
implements VectorValueMatcherFactory {
    private final VectorValueSelector selector;

    public FloatVectorValueMatcher(VectorValueSelector selector) {
        this.selector = selector;
    }

    @Override
    public VectorValueMatcher makeMatcher(@Nullable String value) {
        if (value == null) {
            return this.makeNullValueMatcher(this.selector);
        }
        Float matchVal = DimensionHandlerUtils.convertObjectToFloat(value);
        if (matchVal == null) {
            return BooleanVectorValueMatcher.of(this.selector, false);
        }
        float matchValFloat = matchVal.floatValue();
        return this.makeFloatMatcher(matchValFloat);
    }

    @Override
    public VectorValueMatcher makeMatcher(Object matchValue, ColumnType matchValueType) {
        ExprEval eval = ExprEval.ofType(ExpressionType.fromColumnType(matchValueType), matchValue);
        ExprEval<?> castForComparison = ExprEval.castForEqualityComparison(eval, ExpressionType.DOUBLE);
        if (castForComparison == null) {
            return BooleanVectorValueMatcher.of(this.selector, false);
        }
        if (castForComparison.isNumericNull()) {
            return this.makeNullValueMatcher(this.selector);
        }
        return this.makeFloatMatcher((float)castForComparison.asDouble());
    }

    private BaseVectorValueMatcher makeFloatMatcher(final float matchValFloat) {
        return new BaseVectorValueMatcher(this.selector){
            final VectorMatch match;
            {
                super(selector);
                this.match = VectorMatch.wrap(new int[FloatVectorValueMatcher.this.selector.getMaxVectorSize()]);
            }

            @Override
            public ReadableVectorMatch match(ReadableVectorMatch mask) {
                float[] vector = FloatVectorValueMatcher.this.selector.getFloatVector();
                int[] selection = this.match.getSelection();
                boolean[] nulls = FloatVectorValueMatcher.this.selector.getNullVector();
                boolean hasNulls = nulls != null;
                int numRows = 0;
                for (int i = 0; i < mask.getSelectionSize(); ++i) {
                    int rowNum = mask.getSelection()[i];
                    if (hasNulls && nulls[rowNum] || vector[rowNum] != matchValFloat) continue;
                    selection[numRows++] = rowNum;
                }
                this.match.setSelectionSize(numRows);
                return this.match;
            }
        };
    }

    @Override
    public VectorValueMatcher makeMatcher(DruidPredicateFactory predicateFactory) {
        final DruidFloatPredicate predicate = predicateFactory.makeFloatPredicate();
        return new BaseVectorValueMatcher(this.selector){
            final VectorMatch match;
            {
                super(selector);
                this.match = VectorMatch.wrap(new int[FloatVectorValueMatcher.this.selector.getMaxVectorSize()]);
            }

            @Override
            public ReadableVectorMatch match(ReadableVectorMatch mask) {
                float[] vector = FloatVectorValueMatcher.this.selector.getFloatVector();
                int[] selection = this.match.getSelection();
                boolean[] nulls = FloatVectorValueMatcher.this.selector.getNullVector();
                boolean hasNulls = nulls != null;
                int numRows = 0;
                for (int i = 0; i < mask.getSelectionSize(); ++i) {
                    int rowNum = mask.getSelection()[i];
                    if (hasNulls && nulls[rowNum]) {
                        if (!predicate.applyNull()) continue;
                        selection[numRows++] = rowNum;
                        continue;
                    }
                    if (!predicate.applyFloat(vector[rowNum])) continue;
                    selection[numRows++] = rowNum;
                }
                this.match.setSelectionSize(numRows);
                return this.match;
            }
        };
    }
}

