/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.groupby.epinephelinae;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import com.google.common.util.concurrent.ListeningExecutorService;
import it.unimi.dsi.fastutil.ints.IntArrays;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.io.Closeable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.ToLongFunction;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import org.apache.druid.collections.ReferenceCountingResourceHolder;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.common.guava.SettableSupplier;
import org.apache.druid.common.utils.IntArrayUtils;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.java.util.common.granularity.AllGranularity;
import org.apache.druid.java.util.common.guava.Accumulator;
import org.apache.druid.java.util.common.guava.Comparators;
import org.apache.druid.query.BaseQuery;
import org.apache.druid.query.ColumnSelectorPlus;
import org.apache.druid.query.DruidProcessingConfig;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.GroupingAggregatorFactory;
import org.apache.druid.query.dimension.ColumnSelectorStrategy;
import org.apache.druid.query.dimension.ColumnSelectorStrategyFactory;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.filter.Filter;
import org.apache.druid.query.filter.ValueMatcher;
import org.apache.druid.query.groupby.GroupByQuery;
import org.apache.druid.query.groupby.GroupByQueryConfig;
import org.apache.druid.query.groupby.ResultRow;
import org.apache.druid.query.groupby.epinephelinae.AggregateResult;
import org.apache.druid.query.groupby.epinephelinae.CloseableGrouperIterator;
import org.apache.druid.query.groupby.epinephelinae.ConcurrentGrouper;
import org.apache.druid.query.groupby.epinephelinae.DictionaryBuilding;
import org.apache.druid.query.groupby.epinephelinae.Grouper;
import org.apache.druid.query.groupby.epinephelinae.GrouperBufferComparatorUtils;
import org.apache.druid.query.groupby.epinephelinae.LimitedTemporaryStorage;
import org.apache.druid.query.groupby.epinephelinae.RowBasedKeySerdeHelper;
import org.apache.druid.query.groupby.epinephelinae.SpillingGrouper;
import org.apache.druid.query.groupby.orderby.DefaultLimitSpec;
import org.apache.druid.query.groupby.orderby.OrderByColumnSpec;
import org.apache.druid.query.ordering.StringComparator;
import org.apache.druid.query.ordering.StringComparators;
import org.apache.druid.segment.ColumnInspector;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.DimensionHandlerUtils;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.RowAdapter;
import org.apache.druid.segment.RowBasedColumnSelectorFactory;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnCapabilitiesImpl;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.data.ComparableList;
import org.apache.druid.segment.data.ComparableStringArray;
import org.apache.druid.segment.data.IndexedInts;
import org.apache.druid.segment.filter.BooleanValueMatcher;
import org.apache.druid.segment.filter.Filters;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;

public class RowBasedGrouperHelper {
    private static final int SINGLE_THREAD_CONCURRENCY_HINT = -1;
    private static final int UNKNOWN_THREAD_PRIORITY = -1;
    private static final long UNKNOWN_TIMEOUT = -1L;
    private static final InputRawSupplierColumnSelectorStrategyFactory STRATEGY_FACTORY = new InputRawSupplierColumnSelectorStrategyFactory();

    private RowBasedGrouperHelper() {
    }

    public static Pair<Grouper<RowBasedKey>, Accumulator<AggregateResult, ResultRow>> createGrouperAccumulatorPair(GroupByQuery query, @Nullable GroupByQuery subquery, GroupByQueryConfig config, DruidProcessingConfig processingConfig, Supplier<ByteBuffer> bufferSupplier, LimitedTemporaryStorage temporaryStorage, ObjectMapper spillMapper, int mergeBufferSize) {
        return RowBasedGrouperHelper.createGrouperAccumulatorPair(query, subquery, config, processingConfig, bufferSupplier, null, -1, temporaryStorage, spillMapper, null, -1, false, -1L, mergeBufferSize);
    }

    public static Pair<Grouper<RowBasedKey>, Accumulator<AggregateResult, ResultRow>> createGrouperAccumulatorPair(GroupByQuery query, @Nullable GroupByQuery subquery, GroupByQueryConfig config, DruidProcessingConfig processingConfig, Supplier<ByteBuffer> bufferSupplier, @Nullable ReferenceCountingResourceHolder<ByteBuffer> combineBufferHolder, int concurrencyHint, LimitedTemporaryStorage temporaryStorage, ObjectMapper spillMapper, @Nullable ListeningExecutorService grouperSorter, int priority, boolean hasQueryTimeout, long queryTimeoutAt, int mergeBufferSize) {
        Grouper<RowBasedKey> grouper;
        boolean willApplyLimitPushDown;
        Preconditions.checkArgument((concurrencyHint >= 1 || concurrencyHint == -1 ? 1 : 0) != 0, (Object)"invalid concurrencyHint");
        if (concurrencyHint >= 1) {
            Preconditions.checkNotNull((Object)grouperSorter, (Object)"grouperSorter executor must be provided");
        }
        boolean combining = subquery == null;
        List<ColumnType> valueTypes = DimensionHandlerUtils.getValueTypesFromDimensionSpecs(query.getDimensions());
        GroupByQueryConfig querySpecificConfig = config.withOverrides(query);
        boolean includeTimestamp = query.getResultRowHasTimestamp();
        ThreadLocal columnSelectorRow = new ThreadLocal();
        ColumnSelectorFactory columnSelectorFactory = RowBasedGrouperHelper.createResultRowBasedColumnSelectorFactory(combining ? query : subquery, (Supplier<ResultRow>)((Supplier)columnSelectorRow::get), RowSignature.Finalization.UNKNOWN);
        if (!combining) {
            columnSelectorFactory = query.getVirtualColumns().wrap(columnSelectorFactory);
        }
        DefaultLimitSpec limitSpec = (willApplyLimitPushDown = query.isApplyLimitPushDown()) ? (DefaultLimitSpec)query.getLimitSpec() : null;
        boolean sortHasNonGroupingFields = false;
        if (willApplyLimitPushDown) {
            sortHasNonGroupingFields = DefaultLimitSpec.sortingOrderHasNonGroupingFields(limitSpec, query.getDimensions());
        }
        AggregatorFactory[] aggregatorFactories = combining ? (AggregatorFactory[])query.getAggregatorSpecs().stream().map(AggregatorFactory::getCombiningFactory).toArray(AggregatorFactory[]::new) : query.getAggregatorSpecs().toArray(new AggregatorFactory[0]);
        long maxMergingDictionarySize = querySpecificConfig.getActualMaxMergingDictionarySize(processingConfig);
        RowBasedKeySerdeFactory keySerdeFactory = new RowBasedKeySerdeFactory(includeTimestamp, query.getContextSortByDimsFirst(), query.getDimensions(), maxMergingDictionarySize / (long)(concurrencyHint == -1 ? 1 : concurrencyHint), valueTypes, aggregatorFactories, limitSpec);
        if (concurrencyHint == -1) {
            grouper = new SpillingGrouper<RowBasedKey>(bufferSupplier, keySerdeFactory, columnSelectorFactory, aggregatorFactories, querySpecificConfig.getBufferGrouperMaxSize(), querySpecificConfig.getBufferGrouperMaxLoadFactor(), querySpecificConfig.getBufferGrouperInitialBuckets(), temporaryStorage, spillMapper, true, limitSpec, sortHasNonGroupingFields, mergeBufferSize);
        } else {
            RowBasedKeySerdeFactory combineKeySerdeFactory = new RowBasedKeySerdeFactory(includeTimestamp, query.getContextSortByDimsFirst(), query.getDimensions(), maxMergingDictionarySize, valueTypes, aggregatorFactories, limitSpec);
            grouper = new ConcurrentGrouper<RowBasedKey>(querySpecificConfig, bufferSupplier, combineBufferHolder, keySerdeFactory, combineKeySerdeFactory, columnSelectorFactory, aggregatorFactories, temporaryStorage, spillMapper, concurrencyHint, limitSpec, sortHasNonGroupingFields, grouperSorter, priority, hasQueryTimeout, queryTimeoutAt);
        }
        int keySize = includeTimestamp ? query.getDimensions().size() + 1 : query.getDimensions().size();
        ValueExtractFunction valueExtractFn = RowBasedGrouperHelper.makeValueExtractFunction(query, combining, includeTimestamp, columnSelectorFactory, valueTypes);
        Predicate<ResultRow> rowPredicate = combining ? row -> true : RowBasedGrouperHelper.getResultRowPredicate(query, subquery);
        Accumulator<AggregateResult, ResultRow> accumulator = (priorResult, row) -> {
            BaseQuery.checkInterrupted();
            if (priorResult != null && !priorResult.isOk()) {
                return priorResult;
            }
            if (!grouper.isInitialized()) {
                grouper.init();
            }
            if (!rowPredicate.test((ResultRow)row)) {
                return AggregateResult.ok();
            }
            columnSelectorRow.set(row);
            Object[] key = new Comparable[keySize];
            valueExtractFn.apply((ResultRow)row, (Comparable[])key);
            AggregateResult aggregateResult = grouper.aggregate(new RowBasedKey(key));
            columnSelectorRow.set(null);
            return aggregateResult;
        };
        return new Pair<Grouper<RowBasedKey>, Accumulator<AggregateResult, ResultRow>>(grouper, accumulator);
    }

    public static ColumnSelectorFactory createResultRowBasedColumnSelectorFactory(final GroupByQuery query, Supplier<ResultRow> supplier, RowSignature.Finalization finalization) {
        final RowSignature signature = query.getResultRowSignature(finalization);
        RowAdapter<ResultRow> adapter = new RowAdapter<ResultRow>(){

            @Override
            public ToLongFunction<ResultRow> timestampFunction() {
                if (query.getResultRowHasTimestamp()) {
                    return row -> row.getLong(0);
                }
                long timestamp = query.getUniversalTimestamp().getMillis();
                return row -> timestamp;
            }

            @Override
            public Function<ResultRow, Object> columnFunction(String columnName) {
                int columnIndex = signature.indexOf(columnName);
                if (columnIndex < 0) {
                    return row -> null;
                }
                return row -> row.get(columnIndex);
            }
        };
        ColumnInspector decoratedSignature = new ColumnInspector(){

            @Override
            @Nullable
            public ColumnCapabilities getColumnCapabilities(String column) {
                ColumnCapabilities baseCapabilities = signature.getColumnCapabilities(column);
                if (baseCapabilities == null || baseCapabilities.hasMultipleValues().isFalse()) {
                    return baseCapabilities;
                }
                return ColumnCapabilitiesImpl.copyOf(baseCapabilities).setHasMultipleValues(false);
            }
        };
        return RowBasedColumnSelectorFactory.create(adapter, () -> supplier.get(), decoratedSignature, false, false);
    }

    private static Predicate<ResultRow> getResultRowPredicate(GroupByQuery query, GroupByQuery subquery) {
        ValueMatcher filterMatcher;
        List<Interval> queryIntervals = query.getIntervals();
        Filter filter = Filters.convertToCNFFromQueryContext(query, Filters.toFilter(query.getDimFilter()));
        SettableSupplier<ResultRow> rowSupplier = new SettableSupplier<ResultRow>();
        ColumnSelectorFactory columnSelectorFactory = query.getVirtualColumns().wrap(RowBasedGrouperHelper.createResultRowBasedColumnSelectorFactory(subquery, rowSupplier, RowSignature.Finalization.UNKNOWN));
        ValueMatcher valueMatcher = filterMatcher = filter == null ? BooleanValueMatcher.of(true) : filter.makeMatcher(columnSelectorFactory);
        if (subquery.getUniversalTimestamp() != null && queryIntervals.stream().noneMatch(itvl -> itvl.contains((ReadableInstant)subquery.getUniversalTimestamp()))) {
            return row -> false;
        }
        return row -> {
            if (subquery.getResultRowHasTimestamp()) {
                boolean inInterval = false;
                for (Interval queryInterval : queryIntervals) {
                    if (!queryInterval.contains(row.getLong(0))) continue;
                    inInterval = true;
                    break;
                }
                if (!inInterval) {
                    return false;
                }
            }
            rowSupplier.set((ResultRow)row);
            return filterMatcher.matches();
        };
    }

    private static TimestampExtractFunction makeTimestampExtractFunction(GroupByQuery query, boolean combining) {
        if (query.getResultRowHasTimestamp()) {
            if (combining) {
                return row -> row.getLong(0);
            }
            if (query.getGranularity() instanceof AllGranularity) {
                return row -> query.getIntervals().get(0).getStartMillis();
            }
            return row -> query.getGranularity().bucketStart(row.getLong(0));
        }
        long timestamp = query.getUniversalTimestamp().getMillis();
        return row -> timestamp;
    }

    private static ValueExtractFunction makeValueExtractFunction(GroupByQuery query, boolean combining, boolean includeTimestamp, ColumnSelectorFactory columnSelectorFactory, List<ColumnType> valueTypes) {
        TimestampExtractFunction timestampExtractFn = includeTimestamp ? RowBasedGrouperHelper.makeTimestampExtractFunction(query, combining) : null;
        Function[] valueConvertFns = RowBasedGrouperHelper.makeValueConvertFunctions(valueTypes);
        if (!combining) {
            Supplier<Comparable>[] inputRawSuppliers = RowBasedGrouperHelper.getValueSuppliersForDimensions(columnSelectorFactory, query.getDimensions());
            if (includeTimestamp) {
                return (row, key) -> {
                    key[0] = Long.valueOf(timestampExtractFn.apply(row));
                    for (int i = 1; i < key.length; ++i) {
                        Comparable val = (Comparable)inputRawSuppliers[i - 1].get();
                        key[i] = (Comparable)valueConvertFns[i - 1].apply(val);
                    }
                    return key;
                };
            }
            return (row, key) -> {
                for (int i = 0; i < key.length; ++i) {
                    Comparable val = (Comparable)inputRawSuppliers[i].get();
                    key[i] = (Comparable)valueConvertFns[i].apply(val);
                }
                return key;
            };
        }
        int dimensionStartPosition = query.getResultRowDimensionStart();
        if (includeTimestamp) {
            return (row, key) -> {
                key[0] = Long.valueOf(timestampExtractFn.apply(row));
                for (int i = 1; i < key.length; ++i) {
                    Comparable val = (Comparable)row.get(dimensionStartPosition + i - 1);
                    key[i] = (Comparable)valueConvertFns[i - 1].apply(val);
                }
                return key;
            };
        }
        return (row, key) -> {
            for (int i = 0; i < key.length; ++i) {
                Comparable val = (Comparable)row.get(dimensionStartPosition + i);
                key[i] = (Comparable)valueConvertFns[i].apply(val);
            }
            return key;
        };
    }

    public static CloseableGrouperIterator<RowBasedKey, ResultRow> makeGrouperIterator(Grouper<RowBasedKey> grouper, GroupByQuery query, Closeable closeable) {
        return RowBasedGrouperHelper.makeGrouperIterator(grouper, query, null, closeable);
    }

    public static CloseableGrouperIterator<RowBasedKey, ResultRow> makeGrouperIterator(Grouper<RowBasedKey> grouper, GroupByQuery query, @Nullable List<DimensionSpec> dimsToInclude, Closeable closeable) {
        boolean includeTimestamp = query.getResultRowHasTimestamp();
        BitSet dimsToIncludeBitSet = new BitSet(query.getDimensions().size());
        int resultRowDimensionStart = query.getResultRowDimensionStart();
        BitSet groupingAggregatorsBitSet = new BitSet(query.getAggregatorSpecs().size());
        Object[] groupingAggregatorValues = new Long[query.getAggregatorSpecs().size()];
        if (dimsToInclude != null) {
            for (DimensionSpec dimensionSpec : dimsToInclude) {
                String outputName = dimensionSpec.getOutputName();
                int dimIndex = query.getResultRowSignature().indexOf(outputName);
                if (dimIndex < 0) continue;
                dimsToIncludeBitSet.set(dimIndex - resultRowDimensionStart);
            }
            Set<String> keyDimensionNames = dimsToInclude.stream().map(DimensionSpec::getDimension).collect(Collectors.toSet());
            for (int i = 0; i < query.getAggregatorSpecs().size(); ++i) {
                AggregatorFactory aggregatorFactory = query.getAggregatorSpecs().get(i);
                if (!(aggregatorFactory instanceof GroupingAggregatorFactory)) continue;
                groupingAggregatorsBitSet.set(i);
                groupingAggregatorValues[i] = ((GroupingAggregatorFactory)aggregatorFactory).withKeyDimensions(keyDimensionNames).getValue();
            }
        }
        return new CloseableGrouperIterator<RowBasedKey, ResultRow>(grouper.iterator(true), entry -> {
            ResultRow resultRow = ResultRow.create(query.getResultRowSizeWithoutPostAggregators());
            if (includeTimestamp) {
                DateTime timestamp = query.getGranularity().toDateTime((Long)((RowBasedKey)entry.getKey()).getKey()[0]);
                resultRow.set(0, timestamp.getMillis());
            }
            for (int i = resultRowDimensionStart; i < ((RowBasedKey)entry.getKey()).getKey().length; ++i) {
                if (dimsToInclude != null && !dimsToIncludeBitSet.get(i - resultRowDimensionStart)) continue;
                Object dimVal = ((RowBasedKey)entry.getKey()).getKey()[i];
                resultRow.set(i, dimVal instanceof String ? NullHandling.emptyToNullIfNeeded((String)dimVal) : dimVal);
            }
            int resultRowAggregatorStart = query.getResultRowAggregatorStart();
            for (int i = 0; i < entry.getValues().length; ++i) {
                if (dimsToInclude != null && groupingAggregatorsBitSet.get(i)) {
                    resultRow.set(resultRowAggregatorStart + i, groupingAggregatorValues[i]);
                    continue;
                }
                resultRow.set(resultRowAggregatorStart + i, entry.getValues()[i]);
            }
            return resultRow;
        }, closeable);
    }

    private static Supplier<Comparable>[] getValueSuppliersForDimensions(ColumnSelectorFactory columnSelectorFactory, List<DimensionSpec> dimensions) {
        Supplier[] inputRawSuppliers = new Supplier[dimensions.size()];
        ColumnSelectorPlus<InputRawSupplierColumnSelectorStrategy>[] selectorPluses = DimensionHandlerUtils.createColumnSelectorPluses(STRATEGY_FACTORY, dimensions, columnSelectorFactory);
        for (int i = 0; i < selectorPluses.length; ++i) {
            ColumnSelectorPlus<InputRawSupplierColumnSelectorStrategy> selectorPlus = selectorPluses[i];
            InputRawSupplierColumnSelectorStrategy strategy = selectorPlus.getColumnSelectorStrategy();
            inputRawSuppliers[i] = strategy.makeInputRawSupplier(selectorPlus.getSelector());
        }
        return inputRawSuppliers;
    }

    private static Function<Comparable, Comparable>[] makeValueConvertFunctions(List<ColumnType> valueTypes) {
        Function[] functions = new Function[valueTypes.size()];
        for (int i = 0; i < functions.length; ++i) {
            ColumnType type = valueTypes.get(i) == null ? ColumnType.STRING : valueTypes.get(i);
            functions[i] = input -> DimensionHandlerUtils.convertObjectToType(input, type);
        }
        return functions;
    }

    static long estimateStringKeySize(@Nullable String key) {
        return DictionaryBuilding.estimateEntryFootprint((key == null ? 0 : key.length()) * 2);
    }

    private static class RowBasedKeySerde
    implements Grouper.KeySerde<RowBasedKey> {
        private final boolean includeTimestamp;
        private final boolean sortByDimsFirst;
        private final List<DimensionSpec> dimensions;
        private final int dimCount;
        private final int keySize;
        private final ByteBuffer keyBuffer;
        private final RowBasedKeySerdeHelper[] serdeHelpers;
        private final Grouper.BufferComparator[] serdeHelperComparators;
        private final DefaultLimitSpec limitSpec;
        private final List<ColumnType> valueTypes;
        private final boolean enableRuntimeDictionaryGeneration;
        private final List<String> dictionary;
        private final Object2IntMap<String> reverseDictionary;
        private final List<ComparableStringArray> arrayDictionary;
        private final Object2IntMap<ComparableStringArray> reverseArrayDictionary;
        private final List<ComparableList> listDictionary;
        private final Object2IntMap<ComparableList> reverseListDictionary;
        private final long maxDictionarySize;
        private long currentEstimatedSize = 0L;
        @Nullable
        private int[] rankOfDictionaryIds = null;

        RowBasedKeySerde(boolean includeTimestamp, boolean sortByDimsFirst, List<DimensionSpec> dimensions, long maxDictionarySize, DefaultLimitSpec limitSpec, List<ColumnType> valueTypes, @Nullable List<String> dictionary) {
            this.includeTimestamp = includeTimestamp;
            this.sortByDimsFirst = sortByDimsFirst;
            this.dimensions = dimensions;
            this.dimCount = dimensions.size();
            this.valueTypes = valueTypes;
            this.limitSpec = limitSpec;
            this.enableRuntimeDictionaryGeneration = dictionary == null;
            this.dictionary = this.enableRuntimeDictionaryGeneration ? DictionaryBuilding.createDictionary() : dictionary;
            this.reverseDictionary = DictionaryBuilding.createReverseDictionary();
            this.arrayDictionary = DictionaryBuilding.createDictionary();
            this.reverseArrayDictionary = DictionaryBuilding.createReverseDictionary();
            this.listDictionary = DictionaryBuilding.createDictionary();
            this.reverseListDictionary = DictionaryBuilding.createReverseDictionary();
            this.maxDictionarySize = maxDictionarySize;
            this.serdeHelpers = this.makeSerdeHelpers(limitSpec != null, this.enableRuntimeDictionaryGeneration);
            this.serdeHelperComparators = new Grouper.BufferComparator[this.serdeHelpers.length];
            Arrays.setAll(this.serdeHelperComparators, i -> this.serdeHelpers[i].getBufferComparator());
            this.keySize = (includeTimestamp ? 8 : 0) + this.getTotalKeySize();
            this.keyBuffer = ByteBuffer.allocate(this.keySize);
            if (!this.enableRuntimeDictionaryGeneration) {
                long initialDictionarySize = dictionary.stream().mapToLong(RowBasedGrouperHelper::estimateStringKeySize).sum();
                Preconditions.checkState((maxDictionarySize >= initialDictionarySize ? 1 : 0) != 0, (String)"Dictionary size[%s] exceeds threshold[%s]", (Object[])new Object[]{initialDictionarySize, maxDictionarySize});
                for (int i2 = 0; i2 < dictionary.size(); ++i2) {
                    this.reverseDictionary.put((Object)dictionary.get(i2), i2);
                }
                this.initializeRankOfDictionaryIds();
            }
        }

        private void initializeRankOfDictionaryIds() {
            int dictionarySize = this.dictionary.size();
            this.rankOfDictionaryIds = IntStream.range(0, dictionarySize).toArray();
            IntArrays.quickSort((int[])this.rankOfDictionaryIds, (i1, i2) -> Comparators.naturalNullsFirst().compare((Object)this.dictionary.get(i1), (Object)this.dictionary.get(i2)));
            IntArrayUtils.inverse(this.rankOfDictionaryIds);
        }

        @Override
        public int keySize() {
            return this.keySize;
        }

        @Override
        public Class<RowBasedKey> keyClazz() {
            return RowBasedKey.class;
        }

        @Override
        public List<String> getDictionary() {
            return this.dictionary;
        }

        @Override
        public ByteBuffer toByteBuffer(RowBasedKey key) {
            int dimStart;
            this.keyBuffer.rewind();
            if (this.includeTimestamp) {
                this.keyBuffer.putLong((Long)key.getKey()[0]);
                dimStart = 1;
            } else {
                dimStart = 0;
            }
            for (int i = dimStart; i < key.getKey().length; ++i) {
                if (this.serdeHelpers[i - dimStart].putToKeyBuffer(key, i)) continue;
                return null;
            }
            this.keyBuffer.flip();
            return this.keyBuffer;
        }

        @Override
        public RowBasedKey createKey() {
            return new RowBasedKey(new Object[this.includeTimestamp ? this.dimCount + 1 : this.dimCount]);
        }

        @Override
        public void readFromByteBuffer(RowBasedKey key, ByteBuffer buffer, int position) {
            int dimStart;
            int dimsPosition;
            if (this.includeTimestamp) {
                key.getKey()[0] = buffer.getLong(position);
                dimsPosition = position + 8;
                dimStart = 1;
            } else {
                dimsPosition = position;
                dimStart = 0;
            }
            for (int i = dimStart; i < key.getKey().length; ++i) {
                this.serdeHelpers[i - dimStart].getFromByteBuffer(buffer, dimsPosition, i, key.getKey());
            }
        }

        @Override
        public Grouper.BufferComparator bufferComparator() {
            if (this.rankOfDictionaryIds == null) {
                this.initializeRankOfDictionaryIds();
            }
            return GrouperBufferComparatorUtils.bufferComparator(this.includeTimestamp, this.sortByDimsFirst, this.dimCount, this.serdeHelperComparators);
        }

        @Override
        public Grouper.BufferComparator bufferComparatorWithAggregators(AggregatorFactory[] aggregatorFactories, int[] aggregatorOffsets) {
            return GrouperBufferComparatorUtils.bufferComparatorWithAggregators(aggregatorFactories, aggregatorOffsets, this.limitSpec, this.dimensions, this.serdeHelperComparators, this.includeTimestamp, this.sortByDimsFirst, Arrays.stream(this.serdeHelpers).mapToInt(RowBasedKeySerdeHelper::getKeyBufferValueSize).sum());
        }

        @Override
        public void reset() {
            if (this.enableRuntimeDictionaryGeneration) {
                this.dictionary.clear();
                this.reverseDictionary.clear();
                this.rankOfDictionaryIds = null;
                this.currentEstimatedSize = 0L;
            }
        }

        private int getTotalKeySize() {
            int size = 0;
            for (RowBasedKeySerdeHelper helper : this.serdeHelpers) {
                size += helper.getKeyBufferValueSize();
            }
            return size;
        }

        private RowBasedKeySerdeHelper[] makeSerdeHelpers(boolean pushLimitDown, boolean enableRuntimeDictionaryGeneration) {
            ArrayList<RowBasedKeySerdeHelper> helpers = new ArrayList<RowBasedKeySerdeHelper>();
            int keyBufferPosition = 0;
            for (int i = 0; i < this.dimCount; ++i) {
                StringComparator stringComparator;
                if (this.limitSpec != null) {
                    String dimName = this.dimensions.get(i).getOutputName();
                    stringComparator = DefaultLimitSpec.getComparatorForDimName(this.limitSpec, dimName);
                } else {
                    stringComparator = null;
                }
                RowBasedKeySerdeHelper helper = this.makeSerdeHelper(this.valueTypes.get(i), keyBufferPosition, pushLimitDown, stringComparator, enableRuntimeDictionaryGeneration);
                keyBufferPosition += helper.getKeyBufferValueSize();
                helpers.add(helper);
            }
            return helpers.toArray(new RowBasedKeySerdeHelper[0]);
        }

        private RowBasedKeySerdeHelper makeSerdeHelper(ColumnType valueType, int keyBufferPosition, boolean pushLimitDown, @Nullable StringComparator stringComparator, boolean enableRuntimeDictionaryGeneration) {
            switch ((ValueType)valueType.getType()) {
                case ARRAY: {
                    switch ((ValueType)valueType.getElementType().getType()) {
                        case STRING: {
                            return new ArrayStringRowBasedKeySerdeHelper(keyBufferPosition, stringComparator);
                        }
                        case FLOAT: 
                        case LONG: 
                        case DOUBLE: {
                            return new ArrayNumericRowBasedKeySerdeHelper(keyBufferPosition, stringComparator);
                        }
                    }
                    throw new IAE("invalid type: %s", valueType);
                }
                case STRING: {
                    if (enableRuntimeDictionaryGeneration) {
                        return new DynamicDictionaryStringRowBasedKeySerdeHelper(keyBufferPosition, pushLimitDown, stringComparator);
                    }
                    return new StaticDictionaryStringRowBasedKeySerdeHelper(keyBufferPosition, pushLimitDown, stringComparator);
                }
                case FLOAT: 
                case LONG: 
                case DOUBLE: {
                    return this.makeNullHandlingNumericserdeHelper((ValueType)valueType.getType(), keyBufferPosition, pushLimitDown, stringComparator);
                }
            }
            throw new IAE("invalid type: %s", valueType);
        }

        private RowBasedKeySerdeHelper makeNullHandlingNumericserdeHelper(ValueType valueType, int keyBufferPosition, boolean pushLimitDown, @Nullable StringComparator stringComparator) {
            if (NullHandling.sqlCompatible()) {
                return new NullableRowBasedKeySerdeHelper(this.makeNumericSerdeHelper(valueType, keyBufferPosition + 1, pushLimitDown, stringComparator), keyBufferPosition);
            }
            return this.makeNumericSerdeHelper(valueType, keyBufferPosition, pushLimitDown, stringComparator);
        }

        private RowBasedKeySerdeHelper makeNumericSerdeHelper(ValueType valueType, int keyBufferPosition, boolean pushLimitDown, @Nullable StringComparator stringComparator) {
            switch (valueType) {
                case LONG: {
                    return new LongRowBasedKeySerdeHelper(keyBufferPosition, pushLimitDown, stringComparator);
                }
                case FLOAT: {
                    return new FloatRowBasedKeySerdeHelper(keyBufferPosition, pushLimitDown, stringComparator);
                }
                case DOUBLE: {
                    return new DoubleRowBasedKeySerdeHelper(keyBufferPosition, pushLimitDown, stringComparator);
                }
            }
            throw new IAE("invalid type: %s", valueType);
        }

        private class NullableRowBasedKeySerdeHelper
        implements RowBasedKeySerdeHelper {
            private final RowBasedKeySerdeHelper delegate;
            private final int keyBufferPosition;
            private final Grouper.BufferComparator comparator;

            NullableRowBasedKeySerdeHelper(RowBasedKeySerdeHelper delegate, int keyBufferPosition) {
                this.delegate = delegate;
                this.keyBufferPosition = keyBufferPosition;
                this.comparator = GrouperBufferComparatorUtils.makeNullHandlingBufferComparatorForNumericData(keyBufferPosition, this.delegate.getBufferComparator());
            }

            @Override
            public int getKeyBufferValueSize() {
                return this.delegate.getKeyBufferValueSize() + 1;
            }

            @Override
            public boolean putToKeyBuffer(RowBasedKey key, int idx) {
                Object val = key.getKey()[idx];
                if (val == null) {
                    RowBasedKeySerde.this.keyBuffer.put((byte)1);
                } else {
                    RowBasedKeySerde.this.keyBuffer.put((byte)0);
                }
                this.delegate.putToKeyBuffer(key, idx);
                return true;
            }

            @Override
            public void getFromByteBuffer(ByteBuffer buffer, int initialOffset, int dimValIdx, Object[] dimValues) {
                if (buffer.get(initialOffset + this.keyBufferPosition) == 1) {
                    dimValues[dimValIdx] = null;
                } else {
                    this.delegate.getFromByteBuffer(buffer, initialOffset, dimValIdx, dimValues);
                }
            }

            @Override
            public Grouper.BufferComparator getBufferComparator() {
                return this.comparator;
            }
        }

        private class DoubleRowBasedKeySerdeHelper
        implements RowBasedKeySerdeHelper {
            final int keyBufferPosition;
            final Grouper.BufferComparator bufferComparator;

            DoubleRowBasedKeySerdeHelper(int keyBufferPosition, @Nullable boolean pushLimitDown, StringComparator stringComparator) {
                this.keyBufferPosition = keyBufferPosition;
                this.bufferComparator = GrouperBufferComparatorUtils.makeBufferComparatorForDouble(keyBufferPosition, pushLimitDown, stringComparator);
            }

            @Override
            public int getKeyBufferValueSize() {
                return 8;
            }

            @Override
            public boolean putToKeyBuffer(RowBasedKey key, int idx) {
                RowBasedKeySerde.this.keyBuffer.putDouble(DimensionHandlerUtils.nullToZero((Double)key.getKey()[idx]));
                return true;
            }

            @Override
            public void getFromByteBuffer(ByteBuffer buffer, int initialOffset, int dimValIdx, Object[] dimValues) {
                dimValues[dimValIdx] = buffer.getDouble(initialOffset + this.keyBufferPosition);
            }

            @Override
            public Grouper.BufferComparator getBufferComparator() {
                return this.bufferComparator;
            }
        }

        private class FloatRowBasedKeySerdeHelper
        implements RowBasedKeySerdeHelper {
            final int keyBufferPosition;
            final Grouper.BufferComparator bufferComparator;

            FloatRowBasedKeySerdeHelper(int keyBufferPosition, @Nullable boolean pushLimitDown, StringComparator stringComparator) {
                this.keyBufferPosition = keyBufferPosition;
                this.bufferComparator = GrouperBufferComparatorUtils.makeBufferComparatorForFloat(keyBufferPosition, pushLimitDown, stringComparator);
            }

            @Override
            public int getKeyBufferValueSize() {
                return 4;
            }

            @Override
            public boolean putToKeyBuffer(RowBasedKey key, int idx) {
                RowBasedKeySerde.this.keyBuffer.putFloat(DimensionHandlerUtils.nullToZero((Float)key.getKey()[idx]).floatValue());
                return true;
            }

            @Override
            public void getFromByteBuffer(ByteBuffer buffer, int initialOffset, int dimValIdx, Object[] dimValues) {
                dimValues[dimValIdx] = Float.valueOf(buffer.getFloat(initialOffset + this.keyBufferPosition));
            }

            @Override
            public Grouper.BufferComparator getBufferComparator() {
                return this.bufferComparator;
            }
        }

        private class LongRowBasedKeySerdeHelper
        implements RowBasedKeySerdeHelper {
            final int keyBufferPosition;
            final Grouper.BufferComparator bufferComparator;

            LongRowBasedKeySerdeHelper(int keyBufferPosition, @Nullable boolean pushLimitDown, StringComparator stringComparator) {
                this.keyBufferPosition = keyBufferPosition;
                this.bufferComparator = GrouperBufferComparatorUtils.makeBufferComparatorForLong(keyBufferPosition, pushLimitDown, stringComparator);
            }

            @Override
            public int getKeyBufferValueSize() {
                return 8;
            }

            @Override
            public boolean putToKeyBuffer(RowBasedKey key, int idx) {
                RowBasedKeySerde.this.keyBuffer.putLong(DimensionHandlerUtils.nullToZero((Long)key.getKey()[idx]));
                return true;
            }

            @Override
            public void getFromByteBuffer(ByteBuffer buffer, int initialOffset, int dimValIdx, Object[] dimValues) {
                dimValues[dimValIdx] = buffer.getLong(initialOffset + this.keyBufferPosition);
            }

            @Override
            public Grouper.BufferComparator getBufferComparator() {
                return this.bufferComparator;
            }
        }

        private class StaticDictionaryStringRowBasedKeySerdeHelper
        extends AbstractStringRowBasedKeySerdeHelper {
            StaticDictionaryStringRowBasedKeySerdeHelper(int keyBufferPosition, @Nullable boolean pushLimitDown, StringComparator stringComparator) {
                super(keyBufferPosition, pushLimitDown, stringComparator);
            }

            @Override
            public boolean putToKeyBuffer(RowBasedKey key, int idx) {
                String stringKey = (String)key.getKey()[idx];
                int dictIndex = RowBasedKeySerde.this.reverseDictionary.getInt((Object)stringKey);
                if (dictIndex == -1) {
                    throw new ISE("Cannot find key[%s] from dictionary", stringKey);
                }
                RowBasedKeySerde.this.keyBuffer.putInt(dictIndex);
                return true;
            }
        }

        private class DynamicDictionaryStringRowBasedKeySerdeHelper
        extends AbstractStringRowBasedKeySerdeHelper {
            DynamicDictionaryStringRowBasedKeySerdeHelper(int keyBufferPosition, @Nullable boolean pushLimitDown, StringComparator stringComparator) {
                super(keyBufferPosition, pushLimitDown, stringComparator);
            }

            @Override
            public boolean putToKeyBuffer(RowBasedKey key, int idx) {
                int id = this.addToDictionary((String)key.getKey()[idx]);
                if (id < 0) {
                    return false;
                }
                RowBasedKeySerde.this.keyBuffer.putInt(id);
                return true;
            }

            private int addToDictionary(String s) {
                int idx = RowBasedKeySerde.this.reverseDictionary.getInt((Object)s);
                if (idx == -1) {
                    long additionalEstimatedSize = RowBasedGrouperHelper.estimateStringKeySize(s);
                    if (RowBasedKeySerde.this.currentEstimatedSize + additionalEstimatedSize > RowBasedKeySerde.this.maxDictionarySize) {
                        return -1;
                    }
                    idx = RowBasedKeySerde.this.dictionary.size();
                    RowBasedKeySerde.this.reverseDictionary.put((Object)s, idx);
                    RowBasedKeySerde.this.dictionary.add(s);
                    RowBasedKeySerde.this.currentEstimatedSize = RowBasedKeySerde.this.currentEstimatedSize + additionalEstimatedSize;
                }
                return idx;
            }
        }

        private abstract class AbstractStringRowBasedKeySerdeHelper
        implements RowBasedKeySerdeHelper {
            final int keyBufferPosition;
            final Grouper.BufferComparator bufferComparator;

            AbstractStringRowBasedKeySerdeHelper(int keyBufferPosition, @Nullable boolean pushLimitDown, StringComparator stringComparator) {
                this.keyBufferPosition = keyBufferPosition;
                if (!pushLimitDown) {
                    this.bufferComparator = (lhsBuffer, rhsBuffer, lhsPosition, rhsPosition) -> Ints.compare((int)RowBasedKeySerde.this.rankOfDictionaryIds[lhsBuffer.getInt(lhsPosition + keyBufferPosition)], (int)RowBasedKeySerde.this.rankOfDictionaryIds[rhsBuffer.getInt(rhsPosition + keyBufferPosition)]);
                } else {
                    StringComparator realComparator = stringComparator == null ? StringComparators.LEXICOGRAPHIC : stringComparator;
                    this.bufferComparator = (lhsBuffer, rhsBuffer, lhsPosition, rhsPosition) -> {
                        String lhsStr = (String)RowBasedKeySerde.this.dictionary.get(lhsBuffer.getInt(lhsPosition + keyBufferPosition));
                        String rhsStr = (String)RowBasedKeySerde.this.dictionary.get(rhsBuffer.getInt(rhsPosition + keyBufferPosition));
                        return realComparator.compare(lhsStr, rhsStr);
                    };
                }
            }

            @Override
            public int getKeyBufferValueSize() {
                return 4;
            }

            @Override
            public void getFromByteBuffer(ByteBuffer buffer, int initialOffset, int dimValIdx, Object[] dimValues) {
                dimValues[dimValIdx] = RowBasedKeySerde.this.dictionary.get(buffer.getInt(initialOffset + this.keyBufferPosition));
            }

            @Override
            public Grouper.BufferComparator getBufferComparator() {
                return this.bufferComparator;
            }
        }

        private class ArrayStringRowBasedKeySerdeHelper
        implements RowBasedKeySerdeHelper {
            final int keyBufferPosition;
            final Grouper.BufferComparator bufferComparator;

            ArrayStringRowBasedKeySerdeHelper(@Nullable int keyBufferPosition, StringComparator stringComparator) {
                this.keyBufferPosition = keyBufferPosition;
                this.bufferComparator = (lhsBuffer, rhsBuffer, lhsPosition, rhsPosition) -> ComparableStringArray.compareWithComparator(stringComparator, (ComparableStringArray)RowBasedKeySerde.this.arrayDictionary.get(lhsBuffer.getInt(lhsPosition + keyBufferPosition)), (ComparableStringArray)RowBasedKeySerde.this.arrayDictionary.get(rhsBuffer.getInt(rhsPosition + keyBufferPosition)));
            }

            @Override
            public int getKeyBufferValueSize() {
                return 4;
            }

            @Override
            public boolean putToKeyBuffer(RowBasedKey key, int idx) {
                ComparableStringArray comparableStringArray = (ComparableStringArray)key.getKey()[idx];
                int id = this.addToArrayDictionary(comparableStringArray);
                if (id < 0) {
                    return false;
                }
                RowBasedKeySerde.this.keyBuffer.putInt(id);
                return true;
            }

            @Override
            public void getFromByteBuffer(ByteBuffer buffer, int initialOffset, int dimValIdx, Object[] dimValues) {
                dimValues[dimValIdx] = RowBasedKeySerde.this.arrayDictionary.get(buffer.getInt(initialOffset + this.keyBufferPosition));
            }

            @Override
            public Grouper.BufferComparator getBufferComparator() {
                return this.bufferComparator;
            }

            private int addToArrayDictionary(ComparableStringArray s) {
                int idx = RowBasedKeySerde.this.reverseArrayDictionary.getInt((Object)s);
                if (idx == -1) {
                    idx = RowBasedKeySerde.this.arrayDictionary.size();
                    RowBasedKeySerde.this.reverseArrayDictionary.put((Object)s, idx);
                    RowBasedKeySerde.this.arrayDictionary.add(s);
                }
                return idx;
            }
        }

        private class ArrayNumericRowBasedKeySerdeHelper
        implements RowBasedKeySerdeHelper {
            final int keyBufferPosition;
            final Grouper.BufferComparator bufferComparator;

            public ArrayNumericRowBasedKeySerdeHelper(@Nullable int keyBufferPosition, StringComparator stringComparator) {
                this.keyBufferPosition = keyBufferPosition;
                this.bufferComparator = (lhsBuffer, rhsBuffer, lhsPosition, rhsPosition) -> ComparableList.compareWithComparator(stringComparator, (ComparableList)RowBasedKeySerde.this.listDictionary.get(lhsBuffer.getInt(lhsPosition + keyBufferPosition)), (ComparableList)RowBasedKeySerde.this.listDictionary.get(rhsBuffer.getInt(rhsPosition + keyBufferPosition)));
            }

            @Override
            public int getKeyBufferValueSize() {
                return 4;
            }

            @Override
            public boolean putToKeyBuffer(RowBasedKey key, int idx) {
                ComparableList comparableList = (ComparableList)key.getKey()[idx];
                int id = RowBasedKeySerde.this.reverseDictionary.getInt((Object)comparableList);
                if (id == -1) {
                    id = RowBasedKeySerde.this.listDictionary.size();
                    RowBasedKeySerde.this.reverseListDictionary.put((Object)comparableList, id);
                    RowBasedKeySerde.this.listDictionary.add(comparableList);
                }
                RowBasedKeySerde.this.keyBuffer.putInt(id);
                return true;
            }

            @Override
            public void getFromByteBuffer(ByteBuffer buffer, int initialOffset, int dimValIdx, Object[] dimValues) {
                dimValues[dimValIdx] = RowBasedKeySerde.this.listDictionary.get(buffer.getInt(initialOffset + this.keyBufferPosition));
            }

            @Override
            public Grouper.BufferComparator getBufferComparator() {
                return this.bufferComparator;
            }
        }
    }

    private static class RowBasedKeySerdeFactory
    implements Grouper.KeySerdeFactory<RowBasedKey> {
        private final boolean includeTimestamp;
        private final boolean sortByDimsFirst;
        private final long maxDictionarySize;
        private final DefaultLimitSpec limitSpec;
        private final List<DimensionSpec> dimensions;
        final AggregatorFactory[] aggregatorFactories;
        private final List<ColumnType> valueTypes;

        RowBasedKeySerdeFactory(boolean includeTimestamp, boolean sortByDimsFirst, List<DimensionSpec> dimensions, long maxDictionarySize, List<ColumnType> valueTypes, AggregatorFactory[] aggregatorFactories, DefaultLimitSpec limitSpec) {
            this.includeTimestamp = includeTimestamp;
            this.sortByDimsFirst = sortByDimsFirst;
            this.dimensions = dimensions;
            this.maxDictionarySize = maxDictionarySize;
            this.limitSpec = limitSpec;
            this.aggregatorFactories = aggregatorFactories;
            this.valueTypes = valueTypes;
        }

        @Override
        public long getMaxDictionarySize() {
            return this.maxDictionarySize;
        }

        @Override
        public Grouper.KeySerde<RowBasedKey> factorize() {
            return new RowBasedKeySerde(this.includeTimestamp, this.sortByDimsFirst, this.dimensions, this.maxDictionarySize, this.limitSpec, this.valueTypes, null);
        }

        @Override
        public Grouper.KeySerde<RowBasedKey> factorizeWithDictionary(List<String> dictionary) {
            return new RowBasedKeySerde(this.includeTimestamp, this.sortByDimsFirst, this.dimensions, this.maxDictionarySize, this.limitSpec, this.valueTypes, dictionary);
        }

        @Override
        public RowBasedKey copyKey(RowBasedKey key) {
            int keyLength = key.getKey().length;
            Object[] keyCopy = new Object[keyLength];
            System.arraycopy(key.getKey(), 0, keyCopy, 0, keyLength);
            return new RowBasedKey(keyCopy);
        }

        @Override
        public Comparator<Grouper.Entry<RowBasedKey>> objectComparator(boolean forceDefaultOrder) {
            if (this.limitSpec != null && !forceDefaultOrder) {
                return this.objectComparatorWithAggs();
            }
            if (this.includeTimestamp) {
                if (this.sortByDimsFirst) {
                    return (entry1, entry2) -> {
                        int cmp = RowBasedKeySerdeFactory.compareDimsInRows((RowBasedKey)entry1.getKey(), (RowBasedKey)entry2.getKey(), this.valueTypes, 1);
                        if (cmp != 0) {
                            return cmp;
                        }
                        return Longs.compare((long)((Long)((RowBasedKey)entry1.getKey()).getKey()[0]), (long)((Long)((RowBasedKey)entry2.getKey()).getKey()[0]));
                    };
                }
                return (entry1, entry2) -> {
                    int timeCompare = Longs.compare((long)((Long)((RowBasedKey)entry1.getKey()).getKey()[0]), (long)((Long)((RowBasedKey)entry2.getKey()).getKey()[0]));
                    if (timeCompare != 0) {
                        return timeCompare;
                    }
                    return RowBasedKeySerdeFactory.compareDimsInRows((RowBasedKey)entry1.getKey(), (RowBasedKey)entry2.getKey(), this.valueTypes, 1);
                };
            }
            return (entry1, entry2) -> RowBasedKeySerdeFactory.compareDimsInRows((RowBasedKey)entry1.getKey(), (RowBasedKey)entry2.getKey(), this.valueTypes, 0);
        }

        private Comparator<Grouper.Entry<RowBasedKey>> objectComparatorWithAggs() {
            int dimCount = this.dimensions.size();
            ArrayList<Boolean> needsReverses = new ArrayList<Boolean>();
            ArrayList<Boolean> aggFlags = new ArrayList<Boolean>();
            ArrayList<StringComparator> comparators = new ArrayList<StringComparator>();
            ArrayList<Integer> fieldIndices = new ArrayList<Integer>();
            ArrayList<ColumnType> fieldValueTypes = new ArrayList<ColumnType>();
            HashSet<Integer> orderByIndices = new HashSet<Integer>();
            for (OrderByColumnSpec orderSpec : this.limitSpec.getColumns()) {
                boolean needsReverse = orderSpec.getDirection() != OrderByColumnSpec.Direction.ASCENDING;
                int dimIndex = OrderByColumnSpec.getDimIndexForOrderBy(orderSpec, this.dimensions);
                if (dimIndex >= 0) {
                    fieldIndices.add(dimIndex);
                    orderByIndices.add(dimIndex);
                    needsReverses.add(needsReverse);
                    aggFlags.add(false);
                    ColumnType type = this.dimensions.get(dimIndex).getOutputType();
                    fieldValueTypes.add(type);
                    comparators.add(orderSpec.getDimensionComparator());
                    continue;
                }
                int aggIndex = OrderByColumnSpec.getAggIndexForOrderBy(orderSpec, Arrays.asList(this.aggregatorFactories));
                if (aggIndex < 0) continue;
                fieldIndices.add(aggIndex);
                needsReverses.add(needsReverse);
                aggFlags.add(true);
                fieldValueTypes.add(this.aggregatorFactories[aggIndex].getIntermediateType());
                comparators.add(orderSpec.getDimensionComparator());
            }
            for (int i = 0; i < dimCount; ++i) {
                if (orderByIndices.contains(i)) continue;
                fieldIndices.add(i);
                aggFlags.add(false);
                needsReverses.add(false);
                ColumnType type = this.dimensions.get(i).getOutputType();
                fieldValueTypes.add(type);
                if (type.isNumeric()) {
                    comparators.add(StringComparators.NUMERIC);
                    continue;
                }
                comparators.add(StringComparators.LEXICOGRAPHIC);
            }
            if (this.includeTimestamp) {
                if (this.sortByDimsFirst) {
                    return (entry1, entry2) -> {
                        int cmp = RowBasedKeySerdeFactory.compareDimsInRowsWithAggs(entry1, entry2, 1, needsReverses, aggFlags, fieldIndices, fieldValueTypes, comparators);
                        if (cmp != 0) {
                            return cmp;
                        }
                        return Longs.compare((long)((Long)((RowBasedKey)entry1.getKey()).getKey()[0]), (long)((Long)((RowBasedKey)entry2.getKey()).getKey()[0]));
                    };
                }
                return (entry1, entry2) -> {
                    int timeCompare = Longs.compare((long)((Long)((RowBasedKey)entry1.getKey()).getKey()[0]), (long)((Long)((RowBasedKey)entry2.getKey()).getKey()[0]));
                    if (timeCompare != 0) {
                        return timeCompare;
                    }
                    return RowBasedKeySerdeFactory.compareDimsInRowsWithAggs(entry1, entry2, 1, needsReverses, aggFlags, fieldIndices, fieldValueTypes, comparators);
                };
            }
            return (entry1, entry2) -> RowBasedKeySerdeFactory.compareDimsInRowsWithAggs(entry1, entry2, 0, needsReverses, aggFlags, fieldIndices, fieldValueTypes, comparators);
        }

        private static int compareDimsInRows(RowBasedKey key1, RowBasedKey key2, List<ColumnType> fieldTypes, int dimStart) {
            for (int i = dimStart; i < key1.getKey().length; ++i) {
                int cmp;
                Object rhs;
                Object lhs;
                if (fieldTypes.get(i - dimStart).is(ValueType.DOUBLE)) {
                    lhs = key1.getKey()[i];
                    rhs = key2.getKey()[i];
                    cmp = Comparators.naturalNullsFirst().compare((Object)(lhs != null ? Double.valueOf(((Number)lhs).doubleValue()) : null), rhs != null ? Double.valueOf(((Number)rhs).doubleValue()) : null);
                } else if (fieldTypes.get(i - dimStart).equals(ColumnType.STRING_ARRAY)) {
                    lhs = DimensionHandlerUtils.convertToComparableStringArray(key1.getKey()[i]);
                    rhs = DimensionHandlerUtils.convertToComparableStringArray(key2.getKey()[i]);
                    cmp = Comparators.naturalNullsFirst().compare(lhs, rhs);
                } else if (fieldTypes.get(i - dimStart).equals(ColumnType.LONG_ARRAY) || fieldTypes.get(i - dimStart).equals(ColumnType.DOUBLE_ARRAY)) {
                    lhs = DimensionHandlerUtils.convertToList(key1.getKey()[i], (ValueType)fieldTypes.get(i - dimStart).getElementType().getType());
                    rhs = DimensionHandlerUtils.convertToList(key2.getKey()[i], (ValueType)fieldTypes.get(i - dimStart).getElementType().getType());
                    cmp = Comparators.naturalNullsFirst().compare(lhs, rhs);
                } else {
                    cmp = Comparators.naturalNullsFirst().compare((Object)((Comparable)key1.getKey()[i]), (Object)((Comparable)key2.getKey()[i]));
                }
                if (cmp == 0) continue;
                return cmp;
            }
            return 0;
        }

        private static int compareDimsInRowsWithAggs(Grouper.Entry<RowBasedKey> entry1, Grouper.Entry<RowBasedKey> entry2, int dimStart, List<Boolean> needsReverses, List<Boolean> aggFlags, List<Integer> fieldIndices, List<ColumnType> fieldTypes, List<StringComparator> comparators) {
            for (int i = 0; i < fieldIndices.size(); ++i) {
                Object rhs;
                Object lhs;
                int fieldIndex = fieldIndices.get(i);
                boolean needsReverse = needsReverses.get(i);
                if (aggFlags.get(i).booleanValue()) {
                    if (needsReverse) {
                        lhs = entry2.getValues()[fieldIndex];
                        rhs = entry1.getValues()[fieldIndex];
                    } else {
                        lhs = entry1.getValues()[fieldIndex];
                        rhs = entry2.getValues()[fieldIndex];
                    }
                } else if (needsReverse) {
                    lhs = entry2.getKey().getKey()[fieldIndex + dimStart];
                    rhs = entry1.getKey().getKey()[fieldIndex + dimStart];
                } else {
                    lhs = entry1.getKey().getKey()[fieldIndex + dimStart];
                    rhs = entry2.getKey().getKey()[fieldIndex + dimStart];
                }
                StringComparator comparator = comparators.get(i);
                ColumnType fieldType = fieldTypes.get(i);
                int cmp = fieldType.isNumeric() && comparator.equals(StringComparators.NUMERIC) ? (fieldType.is(ValueType.DOUBLE) ? Comparators.naturalNullsFirst().compare((Object)(lhs != null ? Double.valueOf(((Number)lhs).doubleValue()) : null), rhs != null ? Double.valueOf(((Number)rhs).doubleValue()) : null) : Comparators.naturalNullsFirst().compare((Object)((Comparable)lhs), (Object)((Comparable)rhs))) : (fieldType.equals(ColumnType.STRING_ARRAY) ? ComparableStringArray.compareWithComparator(comparator, DimensionHandlerUtils.convertToComparableStringArray(lhs), DimensionHandlerUtils.convertToComparableStringArray(rhs)) : (fieldType.equals(ColumnType.LONG_ARRAY) || fieldType.equals(ColumnType.DOUBLE_ARRAY) ? ComparableList.compareWithComparator(comparator, DimensionHandlerUtils.convertToList(lhs, (ValueType)fieldType.getElementType().getType()), DimensionHandlerUtils.convertToList(rhs, (ValueType)fieldType.getElementType().getType())) : comparator.compare(DimensionHandlerUtils.convertObjectToString(lhs), DimensionHandlerUtils.convertObjectToString(rhs))));
                if (cmp == 0) continue;
                return cmp;
            }
            return 0;
        }
    }

    private static class InputRawSupplierColumnSelectorStrategyFactory
    implements ColumnSelectorStrategyFactory<InputRawSupplierColumnSelectorStrategy> {
        private InputRawSupplierColumnSelectorStrategyFactory() {
        }

        @Override
        public InputRawSupplierColumnSelectorStrategy makeColumnSelectorStrategy(ColumnCapabilities capabilities, ColumnValueSelector selector) {
            switch ((ValueType)capabilities.getType()) {
                case STRING: {
                    return new StringInputRawSupplierColumnSelectorStrategy();
                }
                case LONG: {
                    return columnSelector -> () -> columnSelector.isNull() ? null : Long.valueOf(columnSelector.getLong());
                }
                case FLOAT: {
                    return columnSelector -> () -> columnSelector.isNull() ? null : Float.valueOf(columnSelector.getFloat());
                }
                case DOUBLE: {
                    return columnSelector -> () -> columnSelector.isNull() ? null : Double.valueOf(columnSelector.getDouble());
                }
                case ARRAY: {
                    switch ((ValueType)capabilities.getElementType().getType()) {
                        case STRING: {
                            return columnSelector -> () -> DimensionHandlerUtils.convertToComparableStringArray(columnSelector.getObject());
                        }
                        case FLOAT: 
                        case LONG: 
                        case DOUBLE: {
                            return columnSelector -> () -> DimensionHandlerUtils.convertToList(columnSelector.getObject(), (ValueType)capabilities.getElementType().getType());
                        }
                    }
                    throw new IAE("Cannot create query type helper from invalid type [%s]", capabilities.asTypeString());
                }
            }
            throw new IAE("Cannot create query type helper from invalid type [%s]", capabilities.asTypeString());
        }
    }

    private static class StringInputRawSupplierColumnSelectorStrategy
    implements InputRawSupplierColumnSelectorStrategy<DimensionSelector> {
        private StringInputRawSupplierColumnSelectorStrategy() {
        }

        @Override
        public Supplier<Comparable> makeInputRawSupplier(DimensionSelector selector) {
            return () -> {
                IndexedInts index = selector.getRow();
                return index.size() == 0 ? null : selector.lookupName(index.get(0));
            };
        }
    }

    private static interface InputRawSupplierColumnSelectorStrategy<ValueSelectorType>
    extends ColumnSelectorStrategy {
        public Supplier<Comparable> makeInputRawSupplier(ValueSelectorType var1);
    }

    public static class RowBasedKey {
        private final Object[] key;

        RowBasedKey(Object[] key) {
            this.key = key;
        }

        @JsonCreator
        public static RowBasedKey fromJsonArray(Object[] key) {
            for (int i = 0; i < key.length; ++i) {
                if (key[i] instanceof Integer) {
                    key[i] = ((Integer)key[i]).longValue();
                    continue;
                }
                if (!(key[i] instanceof Double)) continue;
                key[i] = Float.valueOf(((Double)key[i]).floatValue());
            }
            return new RowBasedKey(key);
        }

        @JsonValue
        public Object[] getKey() {
            return this.key;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RowBasedKey that = (RowBasedKey)o;
            return Arrays.equals(this.key, that.key);
        }

        public int hashCode() {
            return Arrays.hashCode(this.key);
        }

        public String toString() {
            return Arrays.toString(this.key);
        }
    }

    private static interface ValueExtractFunction {
        public Comparable[] apply(ResultRow var1, Comparable[] var2);
    }

    private static interface TimestampExtractFunction {
        public long apply(ResultRow var1);
    }
}

