/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.groupby.epinephelinae.column;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.nio.ByteBuffer;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.query.groupby.ResultRow;
import org.apache.druid.query.groupby.epinephelinae.DictionaryBuilding;
import org.apache.druid.query.groupby.epinephelinae.Grouper;
import org.apache.druid.query.groupby.epinephelinae.column.GroupByColumnSelectorPlus;
import org.apache.druid.query.groupby.epinephelinae.column.GroupByColumnSelectorStrategy;
import org.apache.druid.query.ordering.StringComparator;
import org.apache.druid.query.ordering.StringComparators;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.data.ComparableIntArray;
import org.apache.druid.segment.data.ComparableStringArray;

public class ArrayStringGroupByColumnSelectorStrategy
implements GroupByColumnSelectorStrategy {
    private static final int GROUP_BY_MISSING_VALUE = -1;
    private final BiMap<String, Integer> dictionaryToInt;
    private final BiMap<ComparableIntArray, Integer> intListToInt;
    private long estimatedFootprint = 0L;

    @Override
    public int getGroupingKeySize() {
        return 4;
    }

    public ArrayStringGroupByColumnSelectorStrategy() {
        this.dictionaryToInt = HashBiMap.create();
        this.intListToInt = HashBiMap.create();
    }

    @VisibleForTesting
    ArrayStringGroupByColumnSelectorStrategy(BiMap<String, Integer> dictionaryToInt, BiMap<ComparableIntArray, Integer> intArrayToInt) {
        this.dictionaryToInt = dictionaryToInt;
        this.intListToInt = intArrayToInt;
    }

    @Override
    public void processValueFromGroupingKey(GroupByColumnSelectorPlus selectorPlus, ByteBuffer key, ResultRow resultRow, int keyBufferPosition) {
        int id = key.getInt(keyBufferPosition);
        if (id != -1) {
            int[] intRepresentation = ((ComparableIntArray)this.intListToInt.inverse().get((Object)id)).getDelegate();
            String[] stringRepresentaion = new String[intRepresentation.length];
            for (int i = 0; i < intRepresentation.length; ++i) {
                stringRepresentaion[i] = (String)this.dictionaryToInt.inverse().get((Object)intRepresentation[i]);
            }
            resultRow.set(selectorPlus.getResultRowPosition(), ComparableStringArray.of(stringRepresentaion));
        } else {
            resultRow.set(selectorPlus.getResultRowPosition(), null);
        }
    }

    @Override
    public int initColumnValues(ColumnValueSelector selector, int columnIndex, Object[] valuess) {
        long priorFootprint = this.estimatedFootprint;
        int groupingKey = this.computeDictionaryId(selector);
        valuess[columnIndex] = groupingKey;
        return (int)(this.estimatedFootprint - priorFootprint);
    }

    @Override
    public void initGroupingKeyColumnValue(int keyBufferPosition, int dimensionIndex, Object rowObj, ByteBuffer keyBuffer, int[] stack) {
        int groupingKey = (Integer)rowObj;
        this.writeToKeyBuffer(keyBufferPosition, groupingKey, keyBuffer);
        stack[dimensionIndex] = groupingKey == -1 ? 0 : 1;
    }

    @Override
    public boolean checkRowIndexAndAddValueToGroupingKey(int keyBufferPosition, Object rowObj, int rowValIdx, ByteBuffer keyBuffer) {
        return false;
    }

    @VisibleForTesting
    int computeDictionaryId(ColumnValueSelector selector) {
        int i;
        int size;
        int[] intRepresentation;
        Object object = selector.getObject();
        if (object == null) {
            return -1;
        }
        if (object instanceof String) {
            intRepresentation = new int[]{this.addToIndexedDictionary((String)object)};
        } else if (object instanceof List) {
            size = ((List)object).size();
            intRepresentation = new int[size];
            for (i = 0; i < size; ++i) {
                intRepresentation[i] = this.addToIndexedDictionary((String)((List)object).get(i));
            }
        } else if (object instanceof String[]) {
            size = ((String[])object).length;
            intRepresentation = new int[size];
            for (i = 0; i < size; ++i) {
                intRepresentation[i] = this.addToIndexedDictionary(((String[])object)[i]);
            }
        } else if (object instanceof Object[]) {
            size = ((Object[])object).length;
            intRepresentation = new int[size];
            for (i = 0; i < size; ++i) {
                intRepresentation[i] = this.addToIndexedDictionary((String)((Object[])object)[i]);
            }
        } else {
            throw new ISE("Found unexpected object type [%s] in %s array.", object.getClass().getName(), ValueType.STRING);
        }
        ComparableIntArray comparableIntArray = ComparableIntArray.of(intRepresentation);
        int dictId = (Integer)this.intListToInt.getOrDefault((Object)comparableIntArray, (Object)-1);
        if (dictId == -1) {
            int nextId = this.intListToInt.keySet().size();
            this.intListToInt.put((Object)comparableIntArray, (Object)nextId);
            this.estimatedFootprint += (long)DictionaryBuilding.estimateEntryFootprint(comparableIntArray.getDelegate().length * 4);
            return nextId;
        }
        return dictId;
    }

    private int addToIndexedDictionary(String value) {
        Integer dictId = (Integer)this.dictionaryToInt.get((Object)value);
        if (dictId == null) {
            int nextId = this.dictionaryToInt.size();
            this.dictionaryToInt.put((Object)value, (Object)nextId);
            this.estimatedFootprint += (long)DictionaryBuilding.estimateEntryFootprint((value == null ? 0 : value.length()) * 2);
            return nextId;
        }
        return dictId;
    }

    @Override
    public int writeToKeyBuffer(int keyBufferPosition, ColumnValueSelector selector, ByteBuffer keyBuffer) {
        long priorFootprint = this.estimatedFootprint;
        keyBuffer.putInt(keyBufferPosition, this.computeDictionaryId(selector));
        return (int)(this.estimatedFootprint - priorFootprint);
    }

    @Override
    public Grouper.BufferComparator bufferComparator(int keyBufferPosition, @Nullable StringComparator stringComparator) {
        StringComparator comparator = stringComparator == null ? StringComparators.LEXICOGRAPHIC : stringComparator;
        return (lhsBuffer, rhsBuffer, lhsPosition, rhsPosition) -> {
            int[] lhs = ((ComparableIntArray)this.intListToInt.inverse().get((Object)lhsBuffer.getInt(lhsPosition + keyBufferPosition))).getDelegate();
            int[] rhs = ((ComparableIntArray)this.intListToInt.inverse().get((Object)rhsBuffer.getInt(rhsPosition + keyBufferPosition))).getDelegate();
            int minLength = Math.min(lhs.length, rhs.length);
            if (lhs == rhs) {
                return 0;
            }
            for (int i = 0; i < minLength; ++i) {
                int cmp = comparator.compare(this.dictionaryToInt.inverse().get((Object)lhs[i]), this.dictionaryToInt.inverse().get((Object)rhs[i]));
                if (cmp == 0) continue;
                return cmp;
            }
            if (lhs.length == rhs.length) {
                return 0;
            }
            if (lhs.length < rhs.length) {
                return -1;
            }
            return 1;
        };
    }

    @Override
    public void reset() {
        this.dictionaryToInt.clear();
        this.intListToInt.clear();
        this.estimatedFootprint = 0L;
    }

    @VisibleForTesting
    void writeToKeyBuffer(int keyBufferPosition, int groupingKey, ByteBuffer keyBuffer) {
        keyBuffer.putInt(keyBufferPosition, groupingKey);
    }
}

