/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.groupby.strategy;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Sequences;
import org.apache.druid.query.GroupByMergedQueryRunner;
import org.apache.druid.query.QueryPlus;
import org.apache.druid.query.QueryProcessingPool;
import org.apache.druid.query.QueryRunner;
import org.apache.druid.query.QueryWatcher;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.PostAggregator;
import org.apache.druid.query.context.ResponseContext;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.groupby.GroupByQuery;
import org.apache.druid.query.groupby.GroupByQueryConfig;
import org.apache.druid.query.groupby.GroupByQueryEngine;
import org.apache.druid.query.groupby.GroupByQueryHelper;
import org.apache.druid.query.groupby.GroupByQueryMetrics;
import org.apache.druid.query.groupby.ResultRow;
import org.apache.druid.query.groupby.orderby.NoopLimitSpec;
import org.apache.druid.query.groupby.resource.GroupByQueryResource;
import org.apache.druid.query.groupby.strategy.GroupByStrategy;
import org.apache.druid.query.spec.MultipleIntervalSegmentSpec;
import org.apache.druid.segment.StorageAdapter;
import org.apache.druid.segment.incremental.IncrementalIndex;
import org.apache.druid.segment.incremental.IncrementalIndexStorageAdapter;
import org.joda.time.Interval;

public class GroupByStrategyV1
implements GroupByStrategy {
    private final Supplier<GroupByQueryConfig> configSupplier;
    private final GroupByQueryEngine engine;
    private final QueryWatcher queryWatcher;

    @Inject
    public GroupByStrategyV1(Supplier<GroupByQueryConfig> configSupplier, GroupByQueryEngine engine, QueryWatcher queryWatcher) {
        this.configSupplier = configSupplier;
        this.engine = engine;
        this.queryWatcher = queryWatcher;
    }

    @Override
    public GroupByQueryResource prepareResource(GroupByQuery query) {
        return new GroupByQueryResource();
    }

    @Override
    public boolean isCacheable(boolean willMergeRunners) {
        return true;
    }

    @Override
    public boolean doMergeResults(GroupByQuery query) {
        return query.context().getBoolean("groupByMerge", true);
    }

    @Override
    public Sequence<ResultRow> mergeResults(QueryRunner<ResultRow> baseRunner, GroupByQuery query, ResponseContext responseContext) {
        IncrementalIndex index = GroupByQueryHelper.makeIncrementalIndex(query, null, (GroupByQueryConfig)this.configSupplier.get(), baseRunner.run(QueryPlus.wrap(new GroupByQuery.Builder(query).setPostAggregatorSpecs((List<PostAggregator>)ImmutableList.of()).setHavingSpec(null).setLimitSpec(NoopLimitSpec.instance()).overrideContext((Map<String, Object>)ImmutableMap.builder().put((Object)"groupByStrategy", (Object)"v1").put((Object)"finalize", (Object)false).put((Object)"resultAsArray", (Object)true).put((Object)"sortResults", (Object)false).put((Object)"groupByMerge", (Object)false).build()).build()), responseContext));
        return Sequences.withBaggage(GroupByQueryHelper.postAggregate(query, index), index);
    }

    @Override
    public Sequence<ResultRow> applyPostProcessing(Sequence<ResultRow> results, GroupByQuery query) {
        return query.postProcess(results);
    }

    @Override
    public Sequence<ResultRow> processSubqueryResult(GroupByQuery subquery, GroupByQuery query, GroupByQueryResource resource, Sequence<ResultRow> subqueryResult, boolean wasQueryPushedDown) {
        HashSet<AggregatorFactory> aggs = new HashSet<AggregatorFactory>();
        HashSet<String> dimensionNames = new HashSet<String>();
        for (DimensionSpec dimension : subquery.getDimensions()) {
            dimensionNames.add(dimension.getOutputName());
        }
        for (AggregatorFactory aggregatorFactory : query.getAggregatorSpecs()) {
            for (final AggregatorFactory transferAgg : aggregatorFactory.getRequiredColumns()) {
                if (dimensionNames.contains(transferAgg.getName())) continue;
                if (Iterables.any(aggs, (Predicate)new Predicate<AggregatorFactory>(){

                    public boolean apply(AggregatorFactory agg) {
                        return agg.getName().equals(transferAgg.getName()) && !agg.equals(transferAgg);
                    }
                })) {
                    throw new IAE("Inner aggregator can currently only be referenced by a single type of outer aggregator for '%s'", transferAgg.getName());
                }
                aggs.add(transferAgg);
            }
        }
        GroupByQuery innerQuery = new GroupByQuery.Builder(subquery).setAggregatorSpecs((List<AggregatorFactory>)ImmutableList.copyOf(aggs)).setInterval(subquery.getIntervals()).setPostAggregatorSpecs(new ArrayList<PostAggregator>()).build();
        final GroupByQuery outerQuery = new GroupByQuery.Builder(query).setLimitSpec(query.getLimitSpec().merge(subquery.getLimitSpec())).build();
        final IncrementalIndex innerQueryResultIndex = GroupByQueryHelper.makeIncrementalIndex((GroupByQuery)innerQuery.withOverriddenContext((Map)ImmutableMap.of((Object)"sortResults", (Object)true)), subquery, (GroupByQueryConfig)this.configSupplier.get(), subqueryResult);
        IncrementalIndex outerQueryResultIndex = GroupByQueryHelper.makeIncrementalIndex(outerQuery, null, (GroupByQueryConfig)this.configSupplier.get(), Sequences.concat(Sequences.map(Sequences.simple(outerQuery.getIntervals()), new Function<Interval, Sequence<ResultRow>>(){

            public Sequence<ResultRow> apply(Interval interval) {
                return GroupByStrategyV1.this.process(outerQuery.withQuerySegmentSpec(new MultipleIntervalSegmentSpec((List<Interval>)ImmutableList.of((Object)interval))), new IncrementalIndexStorageAdapter(innerQueryResultIndex), null);
            }
        })));
        innerQueryResultIndex.close();
        return Sequences.withBaggage(outerQuery.postProcess(GroupByQueryHelper.postAggregate(query, outerQueryResultIndex)), outerQueryResultIndex);
    }

    @Override
    public Sequence<ResultRow> processSubtotalsSpec(GroupByQuery query, GroupByQueryResource resource, Sequence<ResultRow> queryResult) {
        throw new UnsupportedOperationException("subtotalsSpec is not supported for v1 groupBy strategy.");
    }

    @Override
    public QueryRunner<ResultRow> mergeRunners(QueryProcessingPool queryProcessingPool, Iterable<QueryRunner<ResultRow>> queryRunners) {
        return new GroupByMergedQueryRunner<ResultRow>(queryProcessingPool, this.configSupplier, this.queryWatcher, queryRunners);
    }

    @Override
    public Sequence<ResultRow> process(GroupByQuery query, StorageAdapter storageAdapter, @Nullable GroupByQueryMetrics groupByQueryMetrics) {
        return Sequences.map(this.engine.process(query, storageAdapter, groupByQueryMetrics), row -> GroupByQueryHelper.toResultRow(query, row));
    }

    @Override
    public boolean supportsNestedQueryPushDown() {
        return false;
    }
}

