/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.operator;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import org.apache.druid.query.operator.ColumnWithDirection;
import org.apache.druid.query.operator.NaiveSortOperator;
import org.apache.druid.query.operator.Operator;
import org.apache.druid.query.operator.OperatorFactory;

public class NaiveSortOperatorFactory
implements OperatorFactory {
    private final ArrayList<ColumnWithDirection> sortColumns;

    @JsonCreator
    public NaiveSortOperatorFactory(@JsonProperty(value="columns") ArrayList<ColumnWithDirection> sortColumns) {
        this.sortColumns = sortColumns;
    }

    @JsonProperty(value="columns")
    public ArrayList<ColumnWithDirection> getSortColumns() {
        return this.sortColumns;
    }

    @Override
    public Operator wrap(Operator op) {
        return new NaiveSortOperator(op, this.sortColumns);
    }

    @Override
    public boolean validateEquivalent(OperatorFactory other) {
        if (other instanceof NaiveSortOperatorFactory) {
            return this.sortColumns.equals(((NaiveSortOperatorFactory)other).getSortColumns());
        }
        return false;
    }
}

