/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.operator;

import java.io.Closeable;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.druid.query.filter.Filter;
import org.apache.druid.query.operator.ColumnWithDirection;
import org.apache.druid.query.operator.Operator;
import org.apache.druid.query.rowsandcols.RowsAndColumns;
import org.apache.druid.query.rowsandcols.semantic.RowsAndColumnsDecorator;
import org.apache.druid.segment.VirtualColumns;
import org.joda.time.Interval;

public class ScanOperator
implements Operator {
    private final Operator subOperator;
    private final Interval timeRange;
    private final Filter filter;
    private final int limit;
    private final List<String> projectedColumns;
    private final VirtualColumns virtualColumns;
    private final List<ColumnWithDirection> ordering;

    public ScanOperator(Operator subOperator, List<String> projectedColumns, VirtualColumns virtualColumns, Interval timeRange, Filter filter, List<ColumnWithDirection> ordering, int limit) {
        this.subOperator = subOperator;
        this.projectedColumns = projectedColumns;
        this.virtualColumns = virtualColumns;
        this.timeRange = timeRange;
        this.filter = filter;
        this.ordering = ordering;
        this.limit = limit;
    }

    @Override
    @Nullable
    public Closeable goOrContinue(Closeable continuationObject, final Operator.Receiver receiver) {
        return this.subOperator.goOrContinue(continuationObject, new Operator.Receiver(){

            @Override
            public Operator.Signal push(RowsAndColumns rac) {
                RowsAndColumnsDecorator decor = RowsAndColumnsDecorator.fromRAC(rac);
                if (ScanOperator.this.filter != null) {
                    decor.addFilter(ScanOperator.this.filter);
                }
                if (ScanOperator.this.virtualColumns != null) {
                    decor.addVirtualColumns(ScanOperator.this.virtualColumns);
                }
                if (ScanOperator.this.timeRange != null) {
                    decor.limitTimeRange(ScanOperator.this.timeRange);
                }
                if (ScanOperator.this.limit > 0) {
                    decor.setLimit(ScanOperator.this.limit);
                }
                if (ScanOperator.this.ordering != null && !ScanOperator.this.ordering.isEmpty()) {
                    decor.setOrdering(ScanOperator.this.ordering);
                }
                if (ScanOperator.this.projectedColumns != null && !ScanOperator.this.projectedColumns.isEmpty()) {
                    return receiver.push(decor.restrictColumns(ScanOperator.this.projectedColumns));
                }
                return receiver.push(decor.toRowsAndColumns());
            }

            @Override
            public void completed() {
                receiver.completed();
            }
        });
    }
}

