/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.operator.window.ranking;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.Arrays;
import org.apache.druid.query.operator.window.Processor;
import org.apache.druid.query.rowsandcols.RowsAndColumns;
import org.apache.druid.query.rowsandcols.column.IntArrayColumn;
import org.apache.druid.query.rowsandcols.semantic.AppendableRowsAndColumns;

public class WindowPercentileProcessor
implements Processor {
    private final int numBuckets;
    private final String outputColumn;

    @JsonCreator
    public WindowPercentileProcessor(@JsonProperty(value="outputColumn") String outputColumn, @JsonProperty(value="numBuckets") int numBuckets) {
        Preconditions.checkArgument((numBuckets > 0 ? 1 : 0) != 0, (String)"numBuckets[%s] must be greater than zero", (Object[])new Object[]{numBuckets});
        this.outputColumn = outputColumn;
        this.numBuckets = numBuckets;
    }

    @JsonProperty(value="numBuckets")
    public int getNumBuckets() {
        return this.numBuckets;
    }

    @JsonProperty(value="outputColumn")
    public String getOutputColumn() {
        return this.outputColumn;
    }

    @Override
    public RowsAndColumns process(RowsAndColumns incomingPartition) {
        AppendableRowsAndColumns retVal = RowsAndColumns.expectAppendable(incomingPartition);
        int numRows = incomingPartition.numRows();
        int countPerBucket = numRows / this.numBuckets;
        int extraRows = numRows % this.numBuckets;
        int index = 0;
        int[] bucketVals = new int[numRows];
        for (int i = 0; i < this.numBuckets; ++i) {
            int nextIndex = index + countPerBucket;
            if (extraRows > 0) {
                ++nextIndex;
                --extraRows;
            }
            Arrays.fill(bucketVals, index, nextIndex, i + 1);
            index = nextIndex;
        }
        retVal.addColumn(this.outputColumn, new IntArrayColumn(bucketVals));
        return retVal;
    }

    @Override
    public boolean validateEquivalent(Processor otherProcessor) {
        if (otherProcessor instanceof WindowPercentileProcessor) {
            return this.numBuckets == ((WindowPercentileProcessor)otherProcessor).numBuckets;
        }
        return false;
    }

    public String toString() {
        return "WindowPercentileProcessor{numBuckets=" + this.numBuckets + ", outputColumn='" + this.outputColumn + '\'' + '}';
    }
}

