/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.operator.window.ranking;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.function.Function;
import org.apache.druid.query.operator.window.Processor;
import org.apache.druid.query.rowsandcols.RowsAndColumns;
import org.apache.druid.query.rowsandcols.column.Column;
import org.apache.druid.query.rowsandcols.semantic.AppendableRowsAndColumns;
import org.apache.druid.query.rowsandcols.semantic.ClusteredGroupPartitioner;
import org.apache.druid.query.rowsandcols.semantic.DefaultClusteredGroupPartitioner;

public abstract class WindowRankingProcessorBase
implements Processor {
    private final List<String> groupingCols;
    private final String outputColumn;

    public WindowRankingProcessorBase(List<String> groupingCols, String outputColumn) {
        this.groupingCols = groupingCols;
        this.outputColumn = outputColumn;
    }

    @JsonProperty(value="group")
    public List<String> getGroupingCols() {
        return this.groupingCols;
    }

    @JsonProperty(value="outputColumn")
    public String getOutputColumn() {
        return this.outputColumn;
    }

    public RowsAndColumns processInternal(RowsAndColumns incomingPartition, Function<int[], Column> fn) {
        AppendableRowsAndColumns retVal = RowsAndColumns.expectAppendable(incomingPartition);
        ClusteredGroupPartitioner groupPartitioner = incomingPartition.as(ClusteredGroupPartitioner.class);
        if (groupPartitioner == null) {
            groupPartitioner = new DefaultClusteredGroupPartitioner(incomingPartition);
        }
        retVal.addColumn(this.outputColumn, fn.apply(groupPartitioner.computeBoundaries(this.groupingCols)));
        return retVal;
    }

    @Override
    public boolean validateEquivalent(Processor otherProcessor) {
        return this.getClass() == otherProcessor.getClass() && this.intervalValidation((WindowRankingProcessorBase)otherProcessor);
    }

    protected boolean intervalValidation(WindowRankingProcessorBase other) {
        return this.groupingCols.equals(other.groupingCols);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{" + this.internalToString() + '}';
    }

    protected String internalToString() {
        return "groupingCols=" + this.groupingCols + ", outputColumn='" + this.outputColumn + '\'';
    }
}

