/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.rowsandcols;

import it.unimi.dsi.fastutil.Arrays;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntComparator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.query.operator.ColumnWithDirection;
import org.apache.druid.query.rowsandcols.RowsAndColumns;
import org.apache.druid.query.rowsandcols.column.Column;
import org.apache.druid.query.rowsandcols.column.ColumnAccessor;
import org.apache.druid.query.rowsandcols.column.ColumnValueSwapper;
import org.apache.druid.query.rowsandcols.column.DefaultVectorCopier;
import org.apache.druid.query.rowsandcols.column.LimitedColumn;
import org.apache.druid.query.rowsandcols.column.ObjectArrayColumn;
import org.apache.druid.query.rowsandcols.column.VectorCopier;
import org.apache.druid.query.rowsandcols.column.accessor.ObjectColumnAccessorBase;
import org.apache.druid.query.rowsandcols.semantic.AppendableRowsAndColumns;
import org.apache.druid.query.rowsandcols.semantic.ClusteredGroupPartitioner;
import org.apache.druid.query.rowsandcols.semantic.DefaultClusteredGroupPartitioner;
import org.apache.druid.query.rowsandcols.semantic.NaiveSortMaker;
import org.apache.druid.segment.RowAdapter;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;

public class ArrayListRowsAndColumns<RowType>
implements AppendableRowsAndColumns {
    private static final HashMap<Class<?>, Function<ArrayListRowsAndColumns, ?>> AS_MAP = ArrayListRowsAndColumns.makeAsMap();
    private final ArrayList<RowType> rows;
    private final RowAdapter<RowType> rowAdapter;
    private final RowSignature rowSignature;
    private final Map<String, Column> extraColumns;
    private final Set<String> columnNames;
    private final int startOffset;
    private final int endOffset;

    public ArrayListRowsAndColumns(ArrayList<RowType> rows, RowAdapter<RowType> rowAdapter, RowSignature rowSignature) {
        this(rows, rowAdapter, rowSignature, new LinkedHashMap<String, Column>(), new LinkedHashSet<String>(rowSignature.getColumnNames()), 0, rows.size());
    }

    private ArrayListRowsAndColumns(ArrayList<RowType> rows, RowAdapter<RowType> rowAdapter, RowSignature rowSignature, Map<String, Column> extraColumns, Set<String> columnNames, int startOffset, int endOffset) {
        if (endOffset - startOffset < 0) {
            throw new ISE("endOffset[%,d] - startOffset[%,d] was somehow negative!?", endOffset, startOffset);
        }
        this.rows = rows;
        this.rowAdapter = rowAdapter;
        this.rowSignature = rowSignature;
        this.extraColumns = extraColumns;
        this.columnNames = columnNames;
        this.startOffset = startOffset;
        this.endOffset = endOffset;
    }

    @Override
    public Collection<String> getColumnNames() {
        return this.columnNames;
    }

    @Override
    public int numRows() {
        return this.endOffset - this.startOffset;
    }

    @Override
    @Nullable
    public Column findColumn(String name) {
        if (!this.rowSignature.contains(name)) {
            Column retVal = this.extraColumns.get(name);
            if (this.numRows() == this.rows.size()) {
                return retVal;
            }
            return new LimitedColumn(retVal, this.startOffset, this.endOffset);
        }
        final Function<RowType, Object> adapterForValue = this.rowAdapter.columnFunction(name);
        Optional<ColumnType> maybeColumnType = this.rowSignature.getColumnType(name);
        final ColumnType columnType = maybeColumnType.orElse(ColumnType.UNKNOWN_COMPLEX);
        final Comparator<Object> comparator = Comparator.nullsFirst(columnType.getStrategy());
        return new Column(){

            @Override
            @Nonnull
            public ColumnAccessor toAccessor() {
                return new ObjectColumnAccessorBase(){

                    @Override
                    protected Object getVal(int rowNum) {
                        return adapterForValue.apply(ArrayListRowsAndColumns.this.rows.get(ArrayListRowsAndColumns.this.startOffset + rowNum));
                    }

                    @Override
                    protected Comparator<Object> getComparator() {
                        return comparator;
                    }

                    @Override
                    public ColumnType getType() {
                        return columnType;
                    }

                    @Override
                    public int numRows() {
                        return ArrayListRowsAndColumns.this.endOffset - ArrayListRowsAndColumns.this.startOffset;
                    }
                };
            }

            @Override
            @Nullable
            public <T> T as(Class<? extends T> clazz) {
                return null;
            }
        };
    }

    @Override
    @Nullable
    public <T> T as(Class<T> clazz) {
        Function<ArrayListRowsAndColumns, ?> fn = AS_MAP.get(clazz);
        if (fn == null) {
            return null;
        }
        return (T)fn.apply(this);
    }

    @Override
    public void addColumn(String name, Column column) {
        ObjectArrayColumn existingColumn;
        if (this.rows.size() == this.numRows()) {
            this.extraColumns.put(name, column);
            this.columnNames.add(name);
            return;
        }
        ColumnAccessor columnAccessor = column.toAccessor();
        if (columnAccessor.numRows() != this.numRows()) {
            throw new ISE("More rows[%,d] than expected[%,d]", columnAccessor.numRows(), this.numRows());
        }
        Column extraColumn = this.extraColumns.get(name);
        if (extraColumn == null) {
            existingColumn = new ObjectArrayColumn(new Object[this.rows.size()], columnAccessor.getType());
            this.extraColumns.put(name, existingColumn);
            this.columnNames.add(name);
        } else if (extraColumn instanceof ObjectArrayColumn) {
            existingColumn = (ObjectArrayColumn)extraColumn;
        } else {
            throw new ISE("Partial column[%s] was added, but already have full column[%s]", column.getClass(), extraColumn.getClass());
        }
        VectorCopier copier = column.as(VectorCopier.class);
        if (copier == null) {
            copier = new DefaultVectorCopier(columnAccessor);
        }
        copier.copyInto(existingColumn.getObjects(), this.startOffset);
    }

    private ArrayListRowsAndColumns<RowType> limited(int startOffset, int endOffset) {
        return new ArrayListRowsAndColumns<RowType>(this.rows, this.rowAdapter, this.rowSignature, this.extraColumns, this.columnNames, startOffset, endOffset);
    }

    public void sort(ArrayList<ColumnWithDirection> ordering) {
        ArrayList<2> comparators = new ArrayList<2>(ordering.size());
        for (final ColumnWithDirection columnWithDirection : ordering) {
            final Column column = this.findColumn(columnWithDirection.getColumn());
            if (column == null) continue;
            comparators.add(new IntComparator(){
                final ColumnAccessor accessor;
                private final int directionInt;
                {
                    this.accessor = column.toAccessor();
                    this.directionInt = columnWithDirection.getDirection().getDirectionInt();
                }

                public int compare(int lhs, int rhs) {
                    return this.accessor.compareRows(lhs, rhs) * this.directionInt;
                }
            });
        }
        ArrayList<ColumnValueSwapper> swappers = new ArrayList<ColumnValueSwapper>(this.extraColumns.size());
        for (Map.Entry<String, Column> entry : this.extraColumns.entrySet()) {
            Column column = entry.getValue();
            ColumnValueSwapper swapper = column.as(ColumnValueSwapper.class);
            if (swapper == null) {
                throw new ISE("Column[%s] of type[%s] cannot be sorted.", entry.getKey(), column.getClass());
            }
            swappers.add(swapper);
        }
        Arrays.mergeSort((int)0, (int)this.rows.size(), (lhs, rhs) -> {
            for (IntComparator comparator : comparators) {
                int retVal = comparator.compare(lhs, rhs);
                if (retVal == 0) continue;
                return retVal;
            }
            return 0;
        }, (lhs, rhs) -> {
            RowType tmp = this.rows.get(lhs);
            this.rows.set(lhs, this.rows.get(rhs));
            this.rows.set(rhs, tmp);
            for (ColumnValueSwapper swapper : swappers) {
                swapper.swapValues(lhs, rhs);
            }
        });
    }

    private static HashMap<Class<?>, Function<ArrayListRowsAndColumns, ?>> makeAsMap() {
        HashMap retVal = new HashMap();
        retVal.put(ClusteredGroupPartitioner.class, rac -> {
            ArrayListRowsAndColumns arrayListRowsAndColumns = rac;
            arrayListRowsAndColumns.getClass();
            return arrayListRowsAndColumns.new MyClusteredGroupPartitioner();
        });
        retVal.put(NaiveSortMaker.class, rac -> {
            if (rac.startOffset != 0) {
                throw new ISE("The NaiveSortMaker should happen on the first RAC, start was [%,d], end was [%,d]", rac.startOffset, rac.endOffset);
            }
            if (rac.endOffset == rac.rows.size()) {
                return null;
            }
            ArrayListRowsAndColumns arrayListRowsAndColumns = rac;
            arrayListRowsAndColumns.getClass();
            return arrayListRowsAndColumns.new MyNaiveSortMaker();
        });
        return retVal;
    }

    private class MyNaiveSortMaker
    implements NaiveSortMaker {
        private MyNaiveSortMaker() {
        }

        @Override
        public NaiveSortMaker.NaiveSorter make(final ArrayList<ColumnWithDirection> ordering) {
            return new NaiveSortMaker.NaiveSorter(){
                private int currEnd;
                {
                    this.currEnd = ArrayListRowsAndColumns.this.endOffset;
                }

                @Override
                public RowsAndColumns moreData(RowsAndColumns rac) {
                    if (this.currEnd == ArrayListRowsAndColumns.this.rows.size()) {
                        throw new ISE("More data came after completing the ArrayList, not supported yet.", new Object[0]);
                    }
                    if (rac instanceof ArrayListRowsAndColumns) {
                        ArrayListRowsAndColumns arrayRac = (ArrayListRowsAndColumns)rac;
                        if (arrayRac.startOffset != this.currEnd) {
                            throw new ISE("ArrayRAC instances seen out-of-order!? currEnd[%,d], arrayRac[%,d][%,d]", this.currEnd, arrayRac.startOffset, arrayRac.endOffset);
                        }
                        this.currEnd = arrayRac.endOffset;
                        return null;
                    }
                    throw new ISE("Expected an ArrayListRowsAndColumns, got[%s], fall back to default?", rac.getClass());
                }

                @Override
                public RowsAndColumns complete() {
                    if (this.currEnd != ArrayListRowsAndColumns.this.rows.size()) {
                        throw new ISE("Didn't see all of the rows? currEnd[%,d], rows.size()[%,d]", this.currEnd, ArrayListRowsAndColumns.this.rows.size());
                    }
                    ArrayListRowsAndColumns retVal = ArrayListRowsAndColumns.this.limited(0, ArrayListRowsAndColumns.this.rows.size());
                    retVal.sort(ordering);
                    return retVal;
                }
            };
        }
    }

    private class MyClusteredGroupPartitioner
    implements ClusteredGroupPartitioner {
        private MyClusteredGroupPartitioner() {
        }

        @Override
        public int[] computeBoundaries(List<String> columns) {
            if (ArrayListRowsAndColumns.this.numRows() == 0) {
                return new int[0];
            }
            boolean allInSignature = true;
            for (String column : columns) {
                if (ArrayListRowsAndColumns.this.rowSignature.contains(column)) continue;
                allInSignature = false;
            }
            if (allInSignature) {
                return this.computeBoundariesAllInSignature(columns);
            }
            return this.computeBoundariesSomeAppended(columns);
        }

        private int[] computeBoundariesAllInSignature(List<String> columns) {
            int i;
            ArrayList<Comparator<Object>> comparators = new ArrayList<Comparator<Object>>(columns.size());
            ArrayList adapters = new ArrayList(columns.size());
            for (String column : columns) {
                Optional<ColumnType> columnType = ArrayListRowsAndColumns.this.rowSignature.getColumnType(column);
                if (columnType.isPresent()) {
                    comparators.add(Comparator.nullsFirst(columnType.get().getStrategy()));
                    adapters.add(ArrayListRowsAndColumns.this.rowAdapter.columnFunction(column));
                    continue;
                }
                throw new ISE("column didn't exist!?  Other method should've been called...", new Object[0]);
            }
            IntArrayList boundaries = new IntArrayList();
            Object[] prevVal = new Object[comparators.size()];
            Object[] nextVal = new Object[comparators.size()];
            int numRows = ArrayListRowsAndColumns.this.endOffset - ArrayListRowsAndColumns.this.startOffset;
            boundaries.add(0);
            Object currRow = ArrayListRowsAndColumns.this.rows.get(ArrayListRowsAndColumns.this.startOffset);
            for (i = 0; i < adapters.size(); ++i) {
                prevVal[i] = ((Function)adapters.get(i)).apply(currRow);
            }
            block2: for (i = 1; i < numRows; ++i) {
                int j;
                currRow = ArrayListRowsAndColumns.this.rows.get(ArrayListRowsAndColumns.this.startOffset + i);
                for (j = 0; j < adapters.size(); ++j) {
                    nextVal[j] = ((Function)adapters.get(j)).apply(currRow);
                }
                for (j = 0; j < comparators.size(); ++j) {
                    int comparison = ((Comparator)comparators.get(j)).compare(prevVal[j], nextVal[j]);
                    if (comparison == 0) continue;
                    Object[] tmpRef = prevVal;
                    prevVal = nextVal;
                    nextVal = tmpRef;
                    boundaries.add(i);
                    continue block2;
                }
            }
            boundaries.add(numRows);
            return boundaries.toIntArray();
        }

        private int[] computeBoundariesSomeAppended(List<String> columns) {
            return new DefaultClusteredGroupPartitioner(ArrayListRowsAndColumns.this).computeBoundaries(columns);
        }

        @Override
        public ArrayList<RowsAndColumns> partitionOnBoundaries(List<String> partitionColumns) {
            int[] boundaries = this.computeBoundaries(partitionColumns);
            if (boundaries.length < 2) {
                return new ArrayList<RowsAndColumns>();
            }
            ArrayList<RowsAndColumns> retVal = new ArrayList<RowsAndColumns>(boundaries.length - 1);
            for (int i = 1; i < boundaries.length; ++i) {
                int start = boundaries[i - 1];
                int end = boundaries[i];
                retVal.add(ArrayListRowsAndColumns.this.limited(start, end));
            }
            return retVal;
        }
    }
}

