/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.rowsandcols.column.accessor;

import javax.annotation.Nullable;
import org.apache.druid.query.rowsandcols.column.ColumnAccessor;
import org.apache.druid.segment.column.ColumnType;

public abstract class FloatColumnAccessorBase
implements ColumnAccessor {
    @Override
    public ColumnType getType() {
        return ColumnType.FLOAT;
    }

    @Override
    @Nullable
    public Object getObject(int rowNum) {
        return Float.valueOf(this.getFloat(rowNum));
    }

    @Override
    public double getDouble(int rowNum) {
        return this.getFloat(rowNum);
    }

    @Override
    public long getLong(int rowNum) {
        return (long)this.getFloat(rowNum);
    }

    @Override
    public int getInt(int rowNum) {
        return (int)this.getFloat(rowNum);
    }

    @Override
    public int compareRows(int lhsRowNum, int rhsRowNum) {
        if (this.isNull(lhsRowNum)) {
            return this.isNull(rhsRowNum) ? 0 : -1;
        }
        if (this.isNull(rhsRowNum)) {
            return 1;
        }
        return Float.compare(this.getFloat(lhsRowNum), this.getFloat(rhsRowNum));
    }
}

