/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.rowsandcols.concrete;

import java.util.Collection;
import java.util.LinkedHashMap;
import javax.annotation.Nullable;
import org.apache.druid.frame.Frame;
import org.apache.druid.frame.FrameType;
import org.apache.druid.frame.read.columnar.FrameColumnReaders;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.query.rowsandcols.RowsAndColumns;
import org.apache.druid.query.rowsandcols.column.Column;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;

public class FrameRowsAndColumns
implements RowsAndColumns {
    private final Frame frame;
    private final RowSignature signature;
    private final LinkedHashMap<String, Column> colCache = new LinkedHashMap();

    public FrameRowsAndColumns(Frame frame, RowSignature signature) {
        this.frame = FrameType.COLUMNAR.ensureType(frame);
        this.signature = signature;
    }

    @Override
    public Collection<String> getColumnNames() {
        return this.signature.getColumnNames();
    }

    @Override
    public int numRows() {
        return this.frame.numRows();
    }

    @Override
    @Nullable
    public Column findColumn(String name) {
        if (!this.colCache.containsKey(name)) {
            int columnIndex = this.signature.indexOf(name);
            if (columnIndex < 0) {
                this.colCache.put(name, null);
            } else {
                ColumnType columnType = this.signature.getColumnType(columnIndex).orElseThrow(() -> new ISE("just got the id, why is columnType not there?", new Object[0]));
                this.colCache.put(name, FrameColumnReaders.create(columnIndex, columnType).readRACColumn(this.frame));
            }
        }
        return this.colCache.get(name);
    }

    @Override
    @Nullable
    public <T> T as(Class<T> clazz) {
        return null;
    }
}

