/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.scan;

import com.google.common.base.Predicate;
import com.google.common.math.IntMath;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.filter.ValueMatcher;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.Cursor;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.IdLookup;
import org.apache.druid.segment.RowIdSupplier;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.data.IndexedInts;
import org.joda.time.DateTime;

public class ConcatCursor
implements Cursor {
    private final List<Cursor> cursors;
    private int currentCursor;

    public ConcatCursor(List<Cursor> cursors) {
        this.cursors = cursors;
        this.currentCursor = 0;
        this.skipEmptyCursors();
    }

    @Override
    public ColumnSelectorFactory getColumnSelectorFactory() {
        return new ColumnSelectorFactory(){

            @Override
            public DimensionSelector makeDimensionSelector(final DimensionSpec dimensionSpec) {
                return new DimensionSelector(){

                    @Override
                    public IndexedInts getRow() {
                        return ((Cursor)ConcatCursor.this.cursors.get(ConcatCursor.this.currentCursor)).getColumnSelectorFactory().makeDimensionSelector(dimensionSpec).getRow();
                    }

                    @Override
                    public ValueMatcher makeValueMatcher(@Nullable String value) {
                        return ((Cursor)ConcatCursor.this.cursors.get(ConcatCursor.this.currentCursor)).getColumnSelectorFactory().makeDimensionSelector(dimensionSpec).makeValueMatcher(value);
                    }

                    @Override
                    public ValueMatcher makeValueMatcher(Predicate<String> predicate) {
                        return ((Cursor)ConcatCursor.this.cursors.get(ConcatCursor.this.currentCursor)).getColumnSelectorFactory().makeDimensionSelector(dimensionSpec).makeValueMatcher(predicate);
                    }

                    @Override
                    public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                        ((Cursor)ConcatCursor.this.cursors.get(ConcatCursor.this.currentCursor)).getColumnSelectorFactory().makeDimensionSelector(dimensionSpec).inspectRuntimeShape(inspector);
                    }

                    @Override
                    @Nullable
                    public Object getObject() {
                        return ((Cursor)ConcatCursor.this.cursors.get(ConcatCursor.this.currentCursor)).getColumnSelectorFactory().makeDimensionSelector(dimensionSpec).getObject();
                    }

                    @Override
                    public Class<?> classOfObject() {
                        return ((Cursor)ConcatCursor.this.cursors.get(ConcatCursor.this.currentCursor)).getColumnSelectorFactory().makeDimensionSelector(dimensionSpec).classOfObject();
                    }

                    @Override
                    public int getValueCardinality() {
                        return ((Cursor)ConcatCursor.this.cursors.get(ConcatCursor.this.currentCursor)).getColumnSelectorFactory().makeDimensionSelector(dimensionSpec).getValueCardinality();
                    }

                    @Override
                    @Nullable
                    public String lookupName(int id) {
                        return ((Cursor)ConcatCursor.this.cursors.get(ConcatCursor.this.currentCursor)).getColumnSelectorFactory().makeDimensionSelector(dimensionSpec).lookupName(id);
                    }

                    @Override
                    public boolean nameLookupPossibleInAdvance() {
                        return ((Cursor)ConcatCursor.this.cursors.get(ConcatCursor.this.currentCursor)).getColumnSelectorFactory().makeDimensionSelector(dimensionSpec).nameLookupPossibleInAdvance();
                    }

                    @Override
                    @Nullable
                    public IdLookup idLookup() {
                        return ((Cursor)ConcatCursor.this.cursors.get(ConcatCursor.this.currentCursor)).getColumnSelectorFactory().makeDimensionSelector(dimensionSpec).idLookup();
                    }
                };
            }

            @Override
            public ColumnValueSelector makeColumnValueSelector(final String columnName) {
                return new ColumnValueSelector(){

                    @Override
                    public double getDouble() {
                        return ((Cursor)ConcatCursor.this.cursors.get(ConcatCursor.this.currentCursor)).getColumnSelectorFactory().makeColumnValueSelector(columnName).getDouble();
                    }

                    @Override
                    public float getFloat() {
                        return ((Cursor)ConcatCursor.this.cursors.get(ConcatCursor.this.currentCursor)).getColumnSelectorFactory().makeColumnValueSelector(columnName).getFloat();
                    }

                    @Override
                    public long getLong() {
                        return ((Cursor)ConcatCursor.this.cursors.get(ConcatCursor.this.currentCursor)).getColumnSelectorFactory().makeColumnValueSelector(columnName).getLong();
                    }

                    @Override
                    public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                        ((Cursor)ConcatCursor.this.cursors.get(ConcatCursor.this.currentCursor)).getColumnSelectorFactory().makeColumnValueSelector(columnName).inspectRuntimeShape(inspector);
                    }

                    @Override
                    public boolean isNull() {
                        return ((Cursor)ConcatCursor.this.cursors.get(ConcatCursor.this.currentCursor)).getColumnSelectorFactory().makeColumnValueSelector(columnName).isNull();
                    }

                    @Override
                    @Nullable
                    public Object getObject() {
                        return ((Cursor)ConcatCursor.this.cursors.get(ConcatCursor.this.currentCursor)).getColumnSelectorFactory().makeColumnValueSelector(columnName).getObject();
                    }

                    @Override
                    public Class classOfObject() {
                        return ((Cursor)ConcatCursor.this.cursors.get(ConcatCursor.this.currentCursor)).getColumnSelectorFactory().makeColumnValueSelector(columnName).classOfObject();
                    }
                };
            }

            @Override
            public ColumnCapabilities getColumnCapabilitiesWithDefault(String column, ColumnCapabilities defaultCapabilites) {
                return ((Cursor)ConcatCursor.this.cursors.get(ConcatCursor.this.currentCursor)).getColumnSelectorFactory().getColumnCapabilitiesWithDefault(column, defaultCapabilites);
            }

            @Override
            @Nullable
            public ExpressionType getType(String name) {
                return ((Cursor)ConcatCursor.this.cursors.get(ConcatCursor.this.currentCursor)).getColumnSelectorFactory().getType(name);
            }

            @Override
            @Nullable
            public ColumnCapabilities getColumnCapabilities(String column) {
                return ((Cursor)ConcatCursor.this.cursors.get(ConcatCursor.this.currentCursor)).getColumnSelectorFactory().getColumnCapabilities(column);
            }

            @Override
            @Nullable
            public RowIdSupplier getRowIdSupplier() {
                return ((Cursor)ConcatCursor.this.cursors.get(ConcatCursor.this.currentCursor)).getColumnSelectorFactory().getRowIdSupplier();
            }
        };
    }

    @Override
    public DateTime getTime() {
        return this.cursors.get(this.currentCursor).getTime();
    }

    @Override
    public void advance() {
        if (this.currentCursor < this.cursors.size()) {
            this.cursors.get(this.currentCursor).advance();
            this.advanceCursor();
        }
    }

    @Override
    public void advanceUninterruptibly() {
        if (this.currentCursor < this.cursors.size()) {
            this.cursors.get(this.currentCursor).advanceUninterruptibly();
            this.advanceCursor();
        }
    }

    @Override
    public boolean isDone() {
        return this.currentCursor == this.cursors.size();
    }

    @Override
    public boolean isDoneOrInterrupted() {
        return this.isDone() || Thread.currentThread().isInterrupted();
    }

    @Override
    public void reset() {
        while (this.currentCursor >= 0) {
            if (this.currentCursor < this.cursors.size()) {
                this.cursors.get(this.currentCursor).reset();
            }
            this.currentCursor = IntMath.checkedSubtract((int)this.currentCursor, (int)1);
        }
        this.currentCursor = 0;
        this.skipEmptyCursors();
    }

    private void skipEmptyCursors() {
        while (this.currentCursor < this.cursors.size() && this.cursors.get(this.currentCursor).isDone()) {
            this.currentCursor = IntMath.checkedAdd((int)this.currentCursor, (int)1);
        }
    }

    private void advanceCursor() {
        if (this.cursors.get(this.currentCursor).isDone()) {
            this.currentCursor = IntMath.checkedAdd((int)this.currentCursor, (int)1);
            this.skipEmptyCursors();
        }
    }
}

