/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.scan;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.PeekingIterator;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.apache.druid.frame.Frame;
import org.apache.druid.frame.FrameType;
import org.apache.druid.frame.allocation.MemoryAllocatorFactory;
import org.apache.druid.frame.key.KeyColumn;
import org.apache.druid.frame.segment.FrameCursorUtils;
import org.apache.druid.frame.write.FrameWriterFactory;
import org.apache.druid.frame.write.FrameWriterUtils;
import org.apache.druid.frame.write.FrameWriters;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.UOE;
import org.apache.druid.java.util.common.guava.BaseSequence;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Sequences;
import org.apache.druid.java.util.common.guava.Yielder;
import org.apache.druid.java.util.common.guava.Yielders;
import org.apache.druid.query.FrameSignaturePair;
import org.apache.druid.query.GenericQueryMetricsFactory;
import org.apache.druid.query.IterableRowsCursorHelper;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryMetrics;
import org.apache.druid.query.QueryRunner;
import org.apache.druid.query.QueryToolChest;
import org.apache.druid.query.aggregation.MetricManipulationFn;
import org.apache.druid.query.scan.ConcatCursor;
import org.apache.druid.query.scan.ScanQuery;
import org.apache.druid.query.scan.ScanQueryConfig;
import org.apache.druid.query.scan.ScanQueryLimitRowIterator;
import org.apache.druid.query.scan.ScanQueryOffsetSequence;
import org.apache.druid.query.scan.ScanResultValue;
import org.apache.druid.segment.Cursor;
import org.apache.druid.segment.VirtualColumn;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.utils.CloseableUtils;

public class ScanQueryQueryToolChest
extends QueryToolChest<ScanResultValue, ScanQuery> {
    private static final TypeReference<ScanResultValue> TYPE_REFERENCE = new TypeReference<ScanResultValue>(){};
    private final ScanQueryConfig scanQueryConfig;
    private final GenericQueryMetricsFactory queryMetricsFactory;

    @Inject
    public ScanQueryQueryToolChest(ScanQueryConfig scanQueryConfig, GenericQueryMetricsFactory queryMetricsFactory) {
        this.scanQueryConfig = scanQueryConfig;
        this.queryMetricsFactory = queryMetricsFactory;
    }

    @Override
    public QueryRunner<ScanResultValue> mergeResults(final QueryRunner<ScanResultValue> runner) {
        return (queryPlus, responseContext) -> {
            long newLimit;
            ScanQuery originalQuery = (ScanQuery)queryPlus.getQuery();
            ScanQuery.verifyOrderByForNativeExecution(originalQuery);
            if (!originalQuery.isLimited()) {
                newLimit = Long.MAX_VALUE;
            } else {
                if (originalQuery.getScanRowsLimit() > Long.MAX_VALUE - originalQuery.getScanRowsOffset()) {
                    throw new ISE("Cannot apply limit[%d] with offset[%d] due to overflow", originalQuery.getScanRowsLimit(), originalQuery.getScanRowsOffset());
                }
                newLimit = originalQuery.getScanRowsLimit() + originalQuery.getScanRowsOffset();
            }
            final ScanQuery queryToRun = originalQuery.withNonNullLegacy(this.scanQueryConfig).withOffset(0L).withLimit(newLimit);
            Sequence<ScanResultValue> results = !queryToRun.isLimited() ? runner.run(queryPlus.withQuery(queryToRun), responseContext) : new BaseSequence<ScanResultValue, ScanQueryLimitRowIterator>(new BaseSequence.IteratorMaker<ScanResultValue, ScanQueryLimitRowIterator>(){

                @Override
                public ScanQueryLimitRowIterator make() {
                    return new ScanQueryLimitRowIterator(runner, queryPlus.withQuery(queryToRun), responseContext);
                }

                @Override
                public void cleanup(ScanQueryLimitRowIterator iterFromMake) {
                    CloseableUtils.closeAndWrapExceptions(iterFromMake);
                }
            });
            if (originalQuery.getScanRowsOffset() > 0L) {
                return new ScanQueryOffsetSequence(results, originalQuery.getScanRowsOffset());
            }
            return results;
        };
    }

    @Override
    public QueryMetrics<Query<?>> makeMetrics(ScanQuery query) {
        return this.queryMetricsFactory.makeMetrics(query);
    }

    @Override
    public Function<ScanResultValue, ScanResultValue> makePreComputeManipulatorFn(ScanQuery query, MetricManipulationFn fn) {
        return Functions.identity();
    }

    @Override
    public TypeReference<ScanResultValue> getResultTypeReference() {
        return TYPE_REFERENCE;
    }

    @Override
    public QueryRunner<ScanResultValue> preMergeQueryDecoration(QueryRunner<ScanResultValue> runner) {
        return (queryPlus, responseContext) -> runner.run(queryPlus, responseContext);
    }

    @Override
    public RowSignature resultArraySignature(ScanQuery query) {
        if (query.getColumns() == null || query.getColumns().isEmpty()) {
            return RowSignature.empty();
        }
        RowSignature.Builder builder = RowSignature.builder();
        if (query.withNonNullLegacy(this.scanQueryConfig).isLegacy().booleanValue()) {
            builder.add("timestamp", null);
        }
        for (String columnName : query.getColumns()) {
            ColumnCapabilities capabilities;
            VirtualColumn virtualColumn = query.getVirtualColumns().getVirtualColumn(columnName);
            ColumnType columnType = virtualColumn != null ? ((capabilities = virtualColumn.capabilities(c -> null, columnName)) != null ? capabilities.toColumnType() : null) : null;
            builder.add(columnName, columnType);
        }
        return builder.build();
    }

    @Override
    public Optional<Sequence<FrameSignaturePair>> resultsAsFrames(final ScanQuery query, final Sequence<ScanResultValue> resultSequence, final MemoryAllocatorFactory memoryAllocatorFactory, final boolean useNestedForUnknownTypes) {
        final RowSignature defaultRowSignature = this.resultArraySignature(query);
        final Iterator<ScanResultValue> resultSequenceIterator = new Iterator<ScanResultValue>(){
            Yielder<ScanResultValue> yielder;
            {
                this.yielder = Yielders.each(resultSequence);
            }

            @Override
            public boolean hasNext() {
                return !this.yielder.isDone();
            }

            @Override
            public ScanResultValue next() {
                ScanResultValue scanResultValue = this.yielder.get();
                this.yielder = this.yielder.next(null);
                return scanResultValue;
            }
        };
        Iterable retVal = () -> new Iterator<Sequence<FrameSignaturePair>>(){
            PeekingIterator scanResultValuePeekingIterator;
            {
                this.scanResultValuePeekingIterator = Iterators.peekingIterator((Iterator)resultSequenceIterator);
            }

            @Override
            public boolean hasNext() {
                return this.scanResultValuePeekingIterator.hasNext();
            }

            @Override
            public Sequence<FrameSignaturePair> next() {
                RowSignature rowSignature;
                ArrayList<Object> batch = new ArrayList<Object>();
                ScanResultValue scanResultValue = (ScanResultValue)this.scanResultValuePeekingIterator.next();
                batch.add(scanResultValue);
                RowSignature rowSignature2 = rowSignature = scanResultValue.getRowSignature() != null ? scanResultValue.getRowSignature() : defaultRowSignature;
                while (this.scanResultValuePeekingIterator.hasNext()) {
                    RowSignature nextRowSignature = ((ScanResultValue)this.scanResultValuePeekingIterator.peek()).getRowSignature();
                    if (nextRowSignature == null) {
                        nextRowSignature = defaultRowSignature;
                    }
                    if (nextRowSignature == null || !nextRowSignature.equals(rowSignature)) break;
                    batch.add(this.scanResultValuePeekingIterator.next());
                }
                return ScanQueryQueryToolChest.this.convertScanResultValuesToFrame(batch, rowSignature, query, memoryAllocatorFactory, useNestedForUnknownTypes);
            }
        };
        return Optional.of(Sequences.concat(retVal));
    }

    private Sequence<FrameSignaturePair> convertScanResultValuesToFrame(List<ScanResultValue> batch, RowSignature rowSignature, ScanQuery query, MemoryAllocatorFactory memoryAllocatorFactory, boolean useNestedForUnknownTypes) {
        Preconditions.checkNotNull((Object)rowSignature, (Object)"'rowSignature' must be provided");
        ArrayList<Cursor> cursors = new ArrayList<Cursor>();
        for (ScanResultValue scanResultValue : batch) {
            List rows = (List)scanResultValue.getEvents();
            Function<?, Object[]> mapper = this.getResultFormatMapper(query.getResultFormat(), rowSignature.getColumnNames());
            ArrayList formattedRows = Lists.newArrayList((Iterable)Iterables.transform((Iterable)rows, mapper));
            cursors.add(IterableRowsCursorHelper.getCursorFromIterable(formattedRows, rowSignature));
        }
        RowSignature modifiedRowSignature = useNestedForUnknownTypes ? FrameWriterUtils.replaceUnknownTypesWithNestedColumns(rowSignature) : rowSignature;
        FrameWriterFactory frameWriterFactory = FrameWriters.makeFrameWriterFactory(FrameType.COLUMNAR, memoryAllocatorFactory, modifiedRowSignature, new ArrayList<KeyColumn>());
        ConcatCursor concatCursor = new ConcatCursor(cursors);
        Sequence<Frame> frames = FrameCursorUtils.cursorToFrames(concatCursor, frameWriterFactory);
        return frames.map(frame -> new FrameSignaturePair((Frame)frame, modifiedRowSignature));
    }

    @Override
    public Sequence<Object[]> resultsAsArrays(ScanQuery query, Sequence<ScanResultValue> resultSequence) {
        Function<?, Object[]> mapper = this.getResultFormatMapper(query.getResultFormat(), this.resultArraySignature(query).getColumnNames());
        return resultSequence.flatMap(result -> {
            List rows = (List)result.getEvents();
            Iterable arrays = Iterables.transform((Iterable)rows, (Function)mapper);
            return Sequences.simple(arrays);
        });
    }

    private Function<?, Object[]> getResultFormatMapper(ScanQuery.ResultFormat resultFormat, List<String> fields) {
        Function mapper;
        switch (resultFormat) {
            case RESULT_FORMAT_LIST: {
                mapper = row -> {
                    Object[] rowArray = new Object[fields.size()];
                    for (int i = 0; i < fields.size(); ++i) {
                        rowArray[i] = row.get(fields.get(i));
                    }
                    return rowArray;
                };
                break;
            }
            case RESULT_FORMAT_COMPACTED_LIST: {
                mapper = row -> {
                    if (row.size() == fields.size()) {
                        return row.toArray();
                    }
                    if (fields.isEmpty()) {
                        return new Object[0];
                    }
                    throw new ISE("Mismatch in expected[%d] vs actual[%s] field count", fields.size(), row.size());
                };
                break;
            }
            default: {
                throw new UOE("Unsupported resultFormat for array-based results: %s", new Object[]{resultFormat});
            }
        }
        return mapper;
    }
}

