/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.spec;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Supplier;
import java.io.IOException;
import java.util.Collections;
import org.apache.druid.java.util.common.guava.Accumulator;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.SequenceWrapper;
import org.apache.druid.java.util.common.guava.Sequences;
import org.apache.druid.java.util.common.guava.Yielder;
import org.apache.druid.java.util.common.guava.Yielders;
import org.apache.druid.java.util.common.guava.YieldingAccumulator;
import org.apache.druid.query.Queries;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryPlus;
import org.apache.druid.query.QueryRunner;
import org.apache.druid.query.context.ResponseContext;
import org.apache.druid.query.spec.SpecificSegmentSpec;
import org.apache.druid.segment.SegmentMissingException;

public class SpecificSegmentQueryRunner<T>
implements QueryRunner<T> {
    private final QueryRunner<T> base;
    private final SpecificSegmentSpec specificSpec;
    @VisibleForTesting
    static final String CTX_SET_THREAD_NAME = "setProcessingThreadNames";

    public SpecificSegmentQueryRunner(QueryRunner<T> base, SpecificSegmentSpec specificSpec) {
        this.base = base;
        this.specificSpec = specificSpec;
    }

    @Override
    public Sequence<T> run(QueryPlus<T> input, final ResponseContext responseContext) {
        QueryPlus<T> queryPlus = input.withQuery(Queries.withSpecificSegments(input.getQuery(), Collections.singletonList(this.specificSpec.getDescriptor())));
        final boolean setName = input.getQuery().context().getBoolean(CTX_SET_THREAD_NAME, true);
        Query<T> query = queryPlus.getQuery();
        final Thread currThread = setName ? Thread.currentThread() : null;
        final String currThreadName = setName ? currThread.getName() : null;
        final String newName = setName ? query.getType() + "_" + query.getDataSource() + "_" + query.getIntervals() : null;
        final Sequence baseSequence = setName ? (Sequence)this.doNamed(currThread, currThreadName, newName, () -> this.base.run(queryPlus, responseContext)) : this.base.run(queryPlus, responseContext);
        Sequence segmentMissingCatchingSequence = new Sequence<T>(){

            @Override
            public <OutType> OutType accumulate(OutType initValue, Accumulator<OutType, T> accumulator) {
                try {
                    return baseSequence.accumulate(initValue, accumulator);
                }
                catch (SegmentMissingException e) {
                    SpecificSegmentQueryRunner.this.appendMissingSegment(responseContext);
                    return initValue;
                }
            }

            @Override
            public <OutType> Yielder<OutType> toYielder(OutType initValue, YieldingAccumulator<OutType, T> accumulator) {
                try {
                    return this.makeYielder(baseSequence.toYielder(initValue, accumulator));
                }
                catch (SegmentMissingException e) {
                    SpecificSegmentQueryRunner.this.appendMissingSegment(responseContext);
                    return Yielders.done(initValue, null);
                }
            }

            private <OutType> Yielder<OutType> makeYielder(final Yielder<OutType> yielder) {
                return new Yielder<OutType>(){

                    @Override
                    public OutType get() {
                        return yielder.get();
                    }

                    @Override
                    public Yielder<OutType> next(OutType initValue) {
                        try {
                            return yielder.next(initValue);
                        }
                        catch (SegmentMissingException e) {
                            SpecificSegmentQueryRunner.this.appendMissingSegment(responseContext);
                            return Yielders.done(initValue, null);
                        }
                    }

                    @Override
                    public boolean isDone() {
                        return yielder.isDone();
                    }

                    @Override
                    public void close() throws IOException {
                        yielder.close();
                    }
                };
            }
        };
        return Sequences.wrap(segmentMissingCatchingSequence, new SequenceWrapper(){

            @Override
            public <RetType> RetType wrap(Supplier<RetType> sequenceProcessing) {
                if (setName) {
                    return (RetType)SpecificSegmentQueryRunner.this.doNamed(currThread, currThreadName, newName, sequenceProcessing);
                }
                return (RetType)sequenceProcessing.get();
            }
        });
    }

    private void appendMissingSegment(ResponseContext responseContext) {
        responseContext.addMissingSegments(Collections.singletonList(this.specificSpec.getDescriptor()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <RetType> RetType doNamed(Thread currThread, String currName, String newName, Supplier<RetType> toRun) {
        try {
            currThread.setName(newName);
            Object object = toRun.get();
            return (RetType)object;
        }
        finally {
            currThread.setName(currName);
        }
    }
}

