/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.timeboundary;

import com.google.common.base.Function;
import com.google.inject.Inject;
import java.util.Iterator;
import java.util.List;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.guava.BaseSequence;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.query.ChainedExecutionQueryRunner;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryPlus;
import org.apache.druid.query.QueryProcessingPool;
import org.apache.druid.query.QueryRunner;
import org.apache.druid.query.QueryRunnerFactory;
import org.apache.druid.query.QueryRunnerHelper;
import org.apache.druid.query.QueryToolChest;
import org.apache.druid.query.QueryWatcher;
import org.apache.druid.query.Result;
import org.apache.druid.query.TableDataSource;
import org.apache.druid.query.context.ResponseContext;
import org.apache.druid.query.timeboundary.TimeBoundaryQuery;
import org.apache.druid.query.timeboundary.TimeBoundaryQueryQueryToolChest;
import org.apache.druid.query.timeboundary.TimeBoundaryResultValue;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.Cursor;
import org.apache.druid.segment.Segment;
import org.apache.druid.segment.StorageAdapter;
import org.apache.druid.segment.VirtualColumns;
import org.apache.druid.segment.filter.Filters;
import org.apache.druid.utils.CollectionUtils;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInterval;

public class TimeBoundaryQueryRunnerFactory
implements QueryRunnerFactory<Result<TimeBoundaryResultValue>, TimeBoundaryQuery> {
    private static final TimeBoundaryQueryQueryToolChest TOOL_CHEST = new TimeBoundaryQueryQueryToolChest();
    private final QueryWatcher queryWatcher;

    @Inject
    public TimeBoundaryQueryRunnerFactory(QueryWatcher queryWatcher) {
        this.queryWatcher = queryWatcher;
    }

    @Override
    public QueryRunner<Result<TimeBoundaryResultValue>> createRunner(Segment segment) {
        return new TimeBoundaryQueryRunner(segment);
    }

    @Override
    public QueryRunner<Result<TimeBoundaryResultValue>> mergeRunners(QueryProcessingPool queryProcessingPool, Iterable<QueryRunner<Result<TimeBoundaryResultValue>>> queryRunners) {
        return new ChainedExecutionQueryRunner<Result<TimeBoundaryResultValue>>(queryProcessingPool, this.queryWatcher, queryRunners);
    }

    @Override
    public QueryToolChest<Result<TimeBoundaryResultValue>, TimeBoundaryQuery> getToolchest() {
        return TOOL_CHEST;
    }

    private static boolean canUseAdapterMinMaxTime(TimeBoundaryQuery query, StorageAdapter adapter) {
        if (query.getFilter() != null) {
            return false;
        }
        if (!(query.getDataSource() instanceof TableDataSource)) {
            return false;
        }
        Interval queryInterval = (Interval)CollectionUtils.getOnlyElement(query.getQuerySegmentSpec().getIntervals(), xs -> new IAE("Should only have one interval, got[%s]", xs));
        return queryInterval.contains((ReadableInterval)adapter.getInterval());
    }

    private static class TimeBoundaryQueryRunner
    implements QueryRunner<Result<TimeBoundaryResultValue>> {
        private final StorageAdapter adapter;
        private final Function<Cursor, Result<DateTime>> skipToFirstMatching;

        public TimeBoundaryQueryRunner(Segment segment) {
            this.adapter = segment.asStorageAdapter();
            this.skipToFirstMatching = new Function<Cursor, Result<DateTime>>(){

                public Result<DateTime> apply(Cursor cursor) {
                    if (cursor.isDone()) {
                        return null;
                    }
                    ColumnValueSelector timestampColumnSelector = cursor.getColumnSelectorFactory().makeColumnValueSelector("__time");
                    DateTime timestamp = DateTimes.utc(timestampColumnSelector.getLong());
                    return new Result<DateTime>(adapter.getInterval().getStart(), timestamp);
                }
            };
        }

        private DateTime getTimeBoundary(StorageAdapter adapter, TimeBoundaryQuery legacyQuery, boolean descending) {
            Sequence<Result<DateTime>> resultSequence = QueryRunnerHelper.makeCursorBasedQuery(adapter, legacyQuery.getQuerySegmentSpec().getIntervals(), Filters.toFilter(legacyQuery.getFilter()), VirtualColumns.EMPTY, descending, Granularities.ALL, this.skipToFirstMatching, null);
            List<Result<DateTime>> resultList = resultSequence.limit(1L).toList();
            if (resultList.size() > 0) {
                return resultList.get(0).getValue();
            }
            return null;
        }

        @Override
        public Sequence<Result<TimeBoundaryResultValue>> run(QueryPlus<Result<TimeBoundaryResultValue>> queryPlus, ResponseContext responseContext) {
            Query<Result<TimeBoundaryResultValue>> input = queryPlus.getQuery();
            if (!(input instanceof TimeBoundaryQuery)) {
                throw new ISE("Got a [%s] which isn't a %s", input.getClass(), TimeBoundaryQuery.class);
            }
            final TimeBoundaryQuery query = (TimeBoundaryQuery)input;
            return new BaseSequence<Result<TimeBoundaryResultValue>, Iterator<Result<TimeBoundaryResultValue>>>(new BaseSequence.IteratorMaker<Result<TimeBoundaryResultValue>, Iterator<Result<TimeBoundaryResultValue>>>(){

                @Override
                public Iterator<Result<TimeBoundaryResultValue>> make() {
                    if (adapter == null) {
                        throw new ISE("Null storage adapter found. Probably trying to issue a query against a segment being memory unmapped.", new Object[0]);
                    }
                    DateTime minTime = null;
                    DateTime maxTime = null;
                    if (TimeBoundaryQueryRunnerFactory.canUseAdapterMinMaxTime(query, adapter)) {
                        if (!query.isMaxTime()) {
                            minTime = adapter.getMinTime();
                        }
                        if (!query.isMinTime()) {
                            maxTime = adapter.getMaxTime();
                        }
                    } else {
                        if (!query.isMaxTime()) {
                            minTime = this.getTimeBoundary(adapter, query, false);
                        }
                        if (!query.isMinTime() && (query.isMaxTime() || minTime != null)) {
                            maxTime = this.getTimeBoundary(adapter, query, true);
                        }
                    }
                    return query.buildResult(adapter.getInterval().getStart(), minTime, maxTime).iterator();
                }

                @Override
                public void cleanup(Iterator<Result<TimeBoundaryResultValue>> toClean) {
                }
            });
        }
    }
}

