/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import com.google.common.collect.PeekingIterator;
import java.io.IOException;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.PriorityQueue;
import java.util.TreeMap;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.DimensionMergerV9;
import org.apache.druid.segment.IndexSpec;
import org.apache.druid.segment.IndexableAdapter;
import org.apache.druid.segment.NestedDataColumnMerger;
import org.apache.druid.segment.SimpleDictionaryMergingIterator;
import org.apache.druid.segment.column.ColumnDescriptor;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.ColumnTypeFactory;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.data.FrontCodedIntArrayIndexedWriter;
import org.apache.druid.segment.data.Indexed;
import org.apache.druid.segment.nested.DictionaryIdLookup;
import org.apache.druid.segment.nested.FieldTypeInfo;
import org.apache.druid.segment.nested.NestedCommonFormatColumnSerializer;
import org.apache.druid.segment.nested.NestedDataColumnSerializer;
import org.apache.druid.segment.nested.ScalarDoubleColumnSerializer;
import org.apache.druid.segment.nested.ScalarLongColumnSerializer;
import org.apache.druid.segment.nested.ScalarStringColumnSerializer;
import org.apache.druid.segment.nested.SortedValueDictionary;
import org.apache.druid.segment.nested.VariantColumnSerializer;
import org.apache.druid.segment.serde.NestedCommonFormatColumnPartSerde;
import org.apache.druid.segment.writeout.SegmentWriteOutMedium;

public class AutoTypeColumnMerger
implements DimensionMergerV9 {
    private static final Logger log = new Logger(NestedDataColumnMerger.class);
    public static final Comparator<PeekingIterator<String>> STRING_MERGING_COMPARATOR = SimpleDictionaryMergingIterator.makePeekingComparator();
    public static final Comparator<PeekingIterator<Long>> LONG_MERGING_COMPARATOR = SimpleDictionaryMergingIterator.makePeekingComparator();
    public static final Comparator<PeekingIterator<Double>> DOUBLE_MERGING_COMPARATOR = SimpleDictionaryMergingIterator.makePeekingComparator();
    private final String name;
    private final IndexSpec indexSpec;
    private final SegmentWriteOutMedium segmentWriteOutMedium;
    private final Closer closer;
    private NestedCommonFormatColumnSerializer serializer;
    private ColumnType logicalType;
    private boolean isVariantType = false;

    public AutoTypeColumnMerger(String name, IndexSpec indexSpec, SegmentWriteOutMedium segmentWriteOutMedium, Closer closer) {
        this.name = name;
        this.indexSpec = indexSpec;
        this.segmentWriteOutMedium = segmentWriteOutMedium;
        this.closer = closer;
    }

    @Override
    public void writeMergedValueDictionary(List<IndexableAdapter> adapters) throws IOException {
        try {
            int arrayCardinality;
            int doubleCardinality;
            int longCardinality;
            int stringCardinality;
            TreeMap<String, FieldTypeInfo.MutableTypeSet> mergedFields;
            Indexed[] sortedArrayLookups;
            Indexed[] sortedDoubleLookups;
            Indexed[] sortedLongLookups;
            Indexed[] sortedLookups;
            SortedValueDictionary sortedLookup;
            int numMergeIndex;
            long dimStartTime;
            block17: {
                boolean rootOnly;
                FieldTypeInfo.MutableTypeSet rootTypes;
                boolean hasArrays;
                boolean forceNested;
                block18: {
                    block16: {
                        dimStartTime = System.currentTimeMillis();
                        numMergeIndex = 0;
                        sortedLookup = null;
                        sortedLookups = new Indexed[adapters.size()];
                        sortedLongLookups = new Indexed[adapters.size()];
                        sortedDoubleLookups = new Indexed[adapters.size()];
                        sortedArrayLookups = new Indexed[adapters.size()];
                        mergedFields = new TreeMap<String, FieldTypeInfo.MutableTypeSet>();
                        forceNested = false;
                        Object constantValue = null;
                        hasArrays = false;
                        boolean isConstant = true;
                        for (int i = 0; i < adapters.size(); ++i) {
                            boolean allNulls;
                            IndexableAdapter adapter = adapters.get(i);
                            IndexableAdapter.NestedColumnMergable mergable = this.closer.register(adapter.getNestedColumnMergeables(this.name));
                            if (mergable == null) continue;
                            forceNested = forceNested || mergable.isForceNestedType();
                            isConstant = isConstant && mergable.isConstant();
                            constantValue = mergable.getConstantValue();
                            SortedValueDictionary dimValues = mergable.getValueDictionary();
                            boolean bl = allNulls = dimValues == null || dimValues.allNull();
                            if (allNulls) continue;
                            sortedLookup = dimValues;
                            mergable.mergeFieldsInto(mergedFields);
                            sortedLookups[i] = dimValues.getSortedStrings();
                            sortedLongLookups[i] = dimValues.getSortedLongs();
                            sortedDoubleLookups[i] = dimValues.getSortedDoubles();
                            sortedArrayLookups[i] = dimValues.getSortedArrays();
                            hasArrays = sortedArrayLookups[i].size() > 0;
                            ++numMergeIndex;
                        }
                        rootTypes = (FieldTypeInfo.MutableTypeSet)mergedFields.get("$");
                        boolean bl = rootOnly = mergedFields.size() == 1 && rootTypes != null;
                        if (forceNested || (!isConstant || constantValue != null) && numMergeIndex != 0) break block16;
                        this.logicalType = ColumnType.STRING;
                        this.serializer = new ScalarStringColumnSerializer(this.name, this.indexSpec, this.segmentWriteOutMedium, this.closer);
                        break block17;
                    }
                    if (forceNested || !rootOnly || rootTypes.getSingleType() == null) break block18;
                    this.logicalType = rootTypes.getSingleType();
                    if (!this.logicalType.isArray() && hasArrays) {
                        this.logicalType = ColumnTypeFactory.getInstance().ofArray(this.logicalType);
                    }
                    switch ((ValueType)this.logicalType.getType()) {
                        case LONG: {
                            this.serializer = new ScalarLongColumnSerializer(this.name, this.indexSpec, this.segmentWriteOutMedium, this.closer);
                            break block17;
                        }
                        case DOUBLE: {
                            this.serializer = new ScalarDoubleColumnSerializer(this.name, this.indexSpec, this.segmentWriteOutMedium, this.closer);
                            break block17;
                        }
                        case STRING: {
                            this.serializer = new ScalarStringColumnSerializer(this.name, this.indexSpec, this.segmentWriteOutMedium, this.closer);
                            break block17;
                        }
                        case ARRAY: {
                            this.serializer = new VariantColumnSerializer(this.name, null, this.indexSpec, this.segmentWriteOutMedium, this.closer);
                            break block17;
                        }
                        default: {
                            throw new ISE("How did we get here? Column [%s] with type [%s] does not have specialized serializer", this.name, this.logicalType);
                        }
                    }
                }
                if (!forceNested && rootOnly) {
                    this.isVariantType = true;
                    for (ColumnType type : FieldTypeInfo.convertToSet(rootTypes.getByteValue())) {
                        this.logicalType = ColumnType.leastRestrictiveType(this.logicalType, type);
                    }
                    if (!this.logicalType.isArray() && hasArrays) {
                        this.logicalType = ColumnTypeFactory.getInstance().ofArray(this.logicalType);
                    }
                    this.serializer = new VariantColumnSerializer(this.name, rootTypes.getByteValue(), this.indexSpec, this.segmentWriteOutMedium, this.closer);
                } else {
                    this.logicalType = ColumnType.NESTED_DATA;
                    NestedDataColumnSerializer defaultSerializer = new NestedDataColumnSerializer(this.name, this.indexSpec, this.segmentWriteOutMedium, this.closer);
                    this.serializer = defaultSerializer;
                }
            }
            this.serializer.openDictionaryWriter();
            this.serializer.serializeFields(mergedFields);
            if (numMergeIndex == 1) {
                this.serializer.serializeDictionaries(sortedLookup.getSortedStrings(), sortedLookup.getSortedLongs(), sortedLookup.getSortedDoubles(), () -> new ArrayDictionaryMergingIterator(sortedArrayLookups, this.serializer.getGlobalLookup()));
                stringCardinality = sortedLookup.getStringCardinality();
                longCardinality = sortedLookup.getLongCardinality();
                doubleCardinality = sortedLookup.getDoubleCardinality();
                arrayCardinality = sortedLookup.getArrayCardinality();
            } else {
                SimpleDictionaryMergingIterator stringIterator = new SimpleDictionaryMergingIterator(sortedLookups, STRING_MERGING_COMPARATOR);
                SimpleDictionaryMergingIterator longIterator = new SimpleDictionaryMergingIterator(sortedLongLookups, LONG_MERGING_COMPARATOR);
                SimpleDictionaryMergingIterator doubleIterator = new SimpleDictionaryMergingIterator(sortedDoubleLookups, DOUBLE_MERGING_COMPARATOR);
                ArrayDictionaryMergingIterator arrayIterator = new ArrayDictionaryMergingIterator(sortedArrayLookups, this.serializer.getGlobalLookup());
                this.serializer.serializeDictionaries(() -> stringIterator, () -> longIterator, () -> doubleIterator, () -> arrayIterator);
                stringCardinality = stringIterator.getCardinality();
                longCardinality = longIterator.getCardinality();
                doubleCardinality = doubleIterator.getCardinality();
                arrayCardinality = arrayIterator.getCardinality();
            }
            this.serializer.open();
            log.debug("Completed dim[%s] conversions with string cardinality[%,d], long cardinality[%,d], double cardinality[%,d], array cardinality[%,d] in %,d millis.", this.name, stringCardinality, longCardinality, doubleCardinality, arrayCardinality, System.currentTimeMillis() - dimStartTime);
        }
        catch (IOException ioe) {
            log.error(ioe, "Failed to merge dictionary for column [%s]", this.name);
            throw ioe;
        }
    }

    @Override
    public ColumnValueSelector convertSortedSegmentRowValuesToMergedRowValues(int segmentIndex, ColumnValueSelector source) {
        return source;
    }

    @Override
    public void processMergedRow(ColumnValueSelector selector) throws IOException {
        this.serializer.serialize(selector);
    }

    @Override
    public void writeIndexes(@Nullable List<IntBuffer> segmentRowNumConversions) {
    }

    @Override
    public boolean hasOnlyNulls() {
        return false;
    }

    @Override
    public ColumnDescriptor makeColumnDescriptor() {
        ColumnDescriptor.Builder descriptorBuilder = new ColumnDescriptor.Builder();
        NestedCommonFormatColumnPartSerde partSerde = NestedCommonFormatColumnPartSerde.serializerBuilder().withLogicalType(this.logicalType).withHasNulls(this.serializer.hasNulls()).isVariantType(this.isVariantType).withByteOrder(ByteOrder.nativeOrder()).withBitmapSerdeFactory(this.indexSpec.getBitmapSerdeFactory()).withSerializer(this.serializer).build();
        descriptorBuilder.setValueType(ValueType.COMPLEX).setHasMultipleValues(false).addSerde(partSerde);
        return descriptorBuilder.build();
    }

    public static class IdLookupArrayIterator
    implements Iterator<int[]> {
        private final DictionaryIdLookup idLookup;
        private final Iterator<Object[]> delegate;

        public IdLookupArrayIterator(DictionaryIdLookup idLookup, Iterator<Object[]> delegate) {
            this.idLookup = idLookup;
            this.delegate = delegate;
        }

        @Override
        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        @Override
        public int[] next() {
            Object[] next = this.delegate.next();
            if (next == null) {
                return null;
            }
            int[] globalIds = new int[next.length];
            for (int i = 0; i < next.length; ++i) {
                globalIds[i] = next[i] == null ? 0 : (next[i] instanceof String ? this.idLookup.lookupString((String)next[i]) : (next[i] instanceof Long ? this.idLookup.lookupLong((Long)next[i]) : (next[i] instanceof Double ? this.idLookup.lookupDouble((Double)next[i]) : -1)));
                Preconditions.checkArgument((globalIds[i] >= 0 ? 1 : 0) != 0, (String)"unknown global id [%s] for value [%s]", (Object[])new Object[]{globalIds[i], next[i]});
            }
            return globalIds;
        }
    }

    public static class ArrayDictionaryMergingIterator
    implements Iterator<int[]> {
        private static final Comparator<PeekingIterator<int[]>> PEEKING_ITERATOR_COMPARATOR = (lhs, rhs) -> FrontCodedIntArrayIndexedWriter.ARRAY_COMPARATOR.compare((int[])lhs.peek(), (int[])rhs.peek());
        protected final PriorityQueue<PeekingIterator<int[]>> pQueue = new PriorityQueue<PeekingIterator<int[]>>(PEEKING_ITERATOR_COMPARATOR);
        private final Iterable<Object[]>[] dimValueLookups;
        private final DictionaryIdLookup idLookup;
        protected int counter;
        private boolean initialized;

        public ArrayDictionaryMergingIterator(Iterable<Object[]>[] dimValueLookups, DictionaryIdLookup idLookup) {
            this.dimValueLookups = dimValueLookups;
            this.idLookup = idLookup;
        }

        private void initialize() {
            for (Iterable<Object[]> dimValueLookup : this.dimValueLookups) {
                PeekingIterator iter;
                if (dimValueLookup == null || !(iter = Iterators.peekingIterator((Iterator)new IdLookupArrayIterator(this.idLookup, dimValueLookup.iterator()))).hasNext()) continue;
                this.pQueue.add((PeekingIterator<int[]>)iter);
            }
            this.initialized = true;
        }

        @Override
        public boolean hasNext() {
            if (!this.initialized) {
                this.initialize();
            }
            return !this.pQueue.isEmpty();
        }

        @Override
        public int[] next() {
            PeekingIterator smallest;
            if (!this.initialized) {
                this.initialize();
            }
            if ((smallest = (PeekingIterator)this.pQueue.remove()) == null) {
                throw new NoSuchElementException();
            }
            int[] value = (int[])smallest.next();
            if (smallest.hasNext()) {
                this.pQueue.add((PeekingIterator<int[]>)smallest);
            }
            while (!this.pQueue.isEmpty() && Arrays.equals(value, (int[])this.pQueue.peek().peek())) {
                PeekingIterator same = (PeekingIterator)this.pQueue.remove();
                same.next();
                if (!same.hasNext()) continue;
                this.pQueue.add((PeekingIterator<int[]>)same);
            }
            ++this.counter;
            return value;
        }

        public int getCardinality() {
            return this.counter;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove");
        }
    }
}

