/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import javax.annotation.Nullable;
import org.apache.druid.collections.bitmap.BitmapFactory;
import org.apache.druid.query.filter.ColumnIndexSelector;
import org.apache.druid.segment.ColumnSelector;
import org.apache.druid.segment.VirtualColumns;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnHolder;
import org.apache.druid.segment.column.ColumnIndexSupplier;
import org.apache.druid.segment.column.NumericColumn;

public class ColumnSelectorColumnIndexSelector
implements ColumnIndexSelector {
    private final BitmapFactory bitmapFactory;
    private final VirtualColumns virtualColumns;
    private final ColumnSelector columnSelector;

    public ColumnSelectorColumnIndexSelector(BitmapFactory bitmapFactory, VirtualColumns virtualColumns, ColumnSelector index) {
        this.bitmapFactory = bitmapFactory;
        this.virtualColumns = virtualColumns;
        this.columnSelector = index;
    }

    @Override
    public int getNumRows() {
        try (NumericColumn column = (NumericColumn)this.columnSelector.getColumnHolder("__time").getColumn();){
            int n = column.length();
            return n;
        }
    }

    @Override
    public BitmapFactory getBitmapFactory() {
        return this.bitmapFactory;
    }

    @Override
    public ColumnIndexSupplier getIndexSupplier(String column) {
        ColumnIndexSupplier indexSupplier;
        if (this.isVirtualColumn(column)) {
            indexSupplier = this.virtualColumns.getIndexSupplier(column, this.columnSelector);
        } else {
            ColumnHolder columnHolder = this.columnSelector.getColumnHolder(column);
            if (columnHolder == null) {
                return null;
            }
            indexSupplier = columnHolder.getIndexSupplier();
        }
        return indexSupplier;
    }

    private boolean isVirtualColumn(String columnName) {
        return this.virtualColumns.getVirtualColumn(columnName) != null;
    }

    @Override
    @Nullable
    public ColumnCapabilities getColumnCapabilities(String column) {
        return this.virtualColumns.getColumnCapabilities(this.columnSelector, column);
    }
}

