/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Sequences;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.query.QueryMetrics;
import org.apache.druid.query.filter.BooleanFilter;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.Filter;
import org.apache.druid.query.filter.InDimFilter;
import org.apache.druid.segment.Cursor;
import org.apache.druid.segment.Metadata;
import org.apache.druid.segment.StorageAdapter;
import org.apache.druid.segment.UnnestColumnValueSelectorCursor;
import org.apache.druid.segment.UnnestDimensionCursor;
import org.apache.druid.segment.VirtualColumn;
import org.apache.druid.segment.VirtualColumns;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.data.Indexed;
import org.apache.druid.segment.data.ListIndexed;
import org.apache.druid.segment.filter.BoundFilter;
import org.apache.druid.segment.filter.Filters;
import org.apache.druid.segment.filter.LikeFilter;
import org.apache.druid.segment.filter.NotFilter;
import org.apache.druid.segment.filter.OrFilter;
import org.apache.druid.segment.filter.SelectorFilter;
import org.apache.druid.segment.join.PostJoinCursor;
import org.apache.druid.segment.virtual.ExpressionVirtualColumn;
import org.joda.time.DateTime;
import org.joda.time.Interval;

public class UnnestStorageAdapter
implements StorageAdapter {
    private final StorageAdapter baseAdapter;
    private final VirtualColumn unnestColumn;
    private final String outputColumnName;
    @Nullable
    private final DimFilter unnestFilter;

    public StorageAdapter getBaseAdapter() {
        return this.baseAdapter;
    }

    public UnnestStorageAdapter(StorageAdapter baseAdapter, VirtualColumn unnestColumn, @Nullable DimFilter unnestFilter) {
        this.baseAdapter = baseAdapter;
        this.unnestColumn = unnestColumn;
        this.outputColumnName = unnestColumn.getOutputName();
        this.unnestFilter = unnestFilter;
    }

    @Override
    public Sequence<Cursor> makeCursors(@Nullable Filter filter, Interval interval, VirtualColumns virtualColumns, Granularity gran, boolean descending, @Nullable QueryMetrics<?> queryMetrics) {
        String inputColumn = this.getUnnestInputIfDirectAccess(this.unnestColumn);
        Pair<Filter, Filter> filterPair = this.computeBaseAndPostUnnestFilters(filter, this.unnestFilter != null ? this.unnestFilter.toFilter() : null, virtualColumns, inputColumn, inputColumn == null ? null : virtualColumns.getColumnCapabilitiesWithFallback(this.baseAdapter, inputColumn));
        Sequence<Cursor> baseCursorSequence = this.baseAdapter.makeCursors((Filter)filterPair.lhs, interval, VirtualColumns.create(Collections.singletonList(this.unnestColumn)), gran, descending, queryMetrics);
        return Sequences.map(baseCursorSequence, cursor -> {
            Objects.requireNonNull(cursor);
            ColumnCapabilities capabilities = this.unnestColumn.capabilities(cursor.getColumnSelectorFactory(), this.unnestColumn.getOutputName());
            Cursor unnestCursor = UnnestStorageAdapter.useDimensionCursor(capabilities) ? new UnnestDimensionCursor((Cursor)cursor, cursor.getColumnSelectorFactory(), this.unnestColumn, this.outputColumnName) : new UnnestColumnValueSelectorCursor((Cursor)cursor, cursor.getColumnSelectorFactory(), this.unnestColumn, this.outputColumnName);
            return PostJoinCursor.wrap(unnestCursor, virtualColumns, (Filter)filterPair.rhs);
        });
    }

    @Override
    public Interval getInterval() {
        return this.baseAdapter.getInterval();
    }

    @Override
    public Indexed<String> getAvailableDimensions() {
        LinkedHashSet<String> availableDimensions = new LinkedHashSet<String>();
        for (String dim : this.baseAdapter.getAvailableDimensions()) {
            availableDimensions.add(dim);
        }
        availableDimensions.add(this.outputColumnName);
        return new ListIndexed<String>(Lists.newArrayList(availableDimensions));
    }

    @Override
    public Iterable<String> getAvailableMetrics() {
        return this.baseAdapter.getAvailableMetrics();
    }

    @Nullable
    public Filter getUnnestFilter() {
        return this.unnestFilter == null ? null : this.unnestFilter.toFilter();
    }

    @Override
    public int getDimensionCardinality(String column) {
        if (!this.outputColumnName.equals(column)) {
            return this.baseAdapter.getDimensionCardinality(column);
        }
        return -1;
    }

    @Override
    public DateTime getMinTime() {
        return this.baseAdapter.getMinTime();
    }

    @Override
    public DateTime getMaxTime() {
        return this.baseAdapter.getMaxTime();
    }

    @Override
    @Nullable
    public Comparable getMinValue(String column) {
        if (this.outputColumnName.equals(column)) {
            return null;
        }
        return this.baseAdapter.getMinValue(column);
    }

    @Override
    @Nullable
    public Comparable getMaxValue(String column) {
        if (this.outputColumnName.equals(column)) {
            return null;
        }
        return this.baseAdapter.getMaxValue(column);
    }

    @Override
    @Nullable
    public ColumnCapabilities getColumnCapabilities(String column) {
        if (this.outputColumnName.equals(column)) {
            return this.unnestColumn.capabilities(this.baseAdapter, column);
        }
        return this.baseAdapter.getColumnCapabilities(column);
    }

    @Override
    public int getNumRows() {
        return 0;
    }

    @Override
    public DateTime getMaxIngestedEventTime() {
        return this.baseAdapter.getMaxIngestedEventTime();
    }

    @Override
    @Nullable
    public Metadata getMetadata() {
        return this.baseAdapter.getMetadata();
    }

    public VirtualColumn getUnnestColumn() {
        return this.unnestColumn;
    }

    public Pair<Filter, Filter> computeBaseAndPostUnnestFilters(@Nullable Filter queryFilter, @Nullable Filter unnestFilter, final VirtualColumns queryVirtualColumns, final @Nullable String inputColumn, final @Nullable ColumnCapabilities inputColumnCapabilites) {
        class FilterSplitter {
            final List<Filter> filtersPushedDownToBaseCursor = new ArrayList<Filter>();
            final List<Filter> filtersForPostUnnestCursor = new ArrayList<Filter>();

            FilterSplitter() {
            }

            void addPostFilterWithPreFilterIfRewritePossible(@Nullable Filter filter, boolean skipPreFilters) {
                Filter newFilter;
                if (filter == null) {
                    return;
                }
                if (!skipPreFilters && (newFilter = UnnestStorageAdapter.this.rewriteFilterOnUnnestColumnIfPossible(filter, inputColumn, inputColumnCapabilites)) != null) {
                    this.filtersPushedDownToBaseCursor.add(newFilter);
                }
                this.filtersForPostUnnestCursor.add(filter);
            }

            void addPreFilter(@Nullable Filter filter) {
                if (filter == null) {
                    return;
                }
                Set<String> requiredColumns = filter.getRequiredColumns();
                if (queryVirtualColumns.getVirtualColumns().length > 0) {
                    for (String column : requiredColumns) {
                        if (!queryVirtualColumns.exists(column)) continue;
                        this.filtersForPostUnnestCursor.add(filter);
                        return;
                    }
                }
                this.filtersPushedDownToBaseCursor.add(filter);
            }
        }
        FilterSplitter filterSplitter = new FilterSplitter();
        if (queryFilter != null) {
            ArrayList<Filter> preFilterList = new ArrayList<Filter>();
            if (queryFilter.getRequiredColumns().contains(this.outputColumnName)) {
                if (queryFilter instanceof OrFilter) {
                    int origFilterSize = ((OrFilter)queryFilter).getFilters().size();
                    for (Filter filter : ((OrFilter)queryFilter).getFilters()) {
                        if (filter.getRequiredColumns().contains(this.outputColumnName)) {
                            Filter newFilter = this.rewriteFilterOnUnnestColumnIfPossible(filter, inputColumn, inputColumnCapabilites);
                            if (newFilter == null) continue;
                            preFilterList.add(newFilter);
                            continue;
                        }
                        preFilterList.add(filter);
                    }
                    if (preFilterList.size() == origFilterSize) {
                        OrFilter preOrFilter = new OrFilter(preFilterList);
                        filterSplitter.addPreFilter(preOrFilter);
                    }
                    filterSplitter.addPostFilterWithPreFilterIfRewritePossible(queryFilter, true);
                } else {
                    filterSplitter.addPostFilterWithPreFilterIfRewritePossible(queryFilter, false);
                }
            } else {
                filterSplitter.addPreFilter(queryFilter);
            }
        }
        filterSplitter.addPostFilterWithPreFilterIfRewritePossible(unnestFilter, false);
        return Pair.of(Filters.maybeAnd(filterSplitter.filtersPushedDownToBaseCursor).orElse(null), Filters.maybeAnd(filterSplitter.filtersForPostUnnestCursor).orElse(null));
    }

    @Nullable
    public String getUnnestInputIfDirectAccess(VirtualColumn unnestColumn) {
        if (unnestColumn instanceof ExpressionVirtualColumn) {
            return ((Expr)((ExpressionVirtualColumn)unnestColumn).getParsedExpression().get()).getBindingIfIdentifier();
        }
        return null;
    }

    @Nullable
    private Filter rewriteFilterOnUnnestColumnIfPossible(Filter filter, @Nullable String inputColumn, @Nullable ColumnCapabilities inputColumnCapabilities) {
        if (inputColumn == null || inputColumnCapabilities == null || inputColumnCapabilities.getType() != ValueType.STRING) {
            return null;
        }
        if (UnnestStorageAdapter.filterMapsOverMultiValueStrings(filter)) {
            return filter.rewriteRequiredColumns((Map<String, String>)ImmutableMap.of((Object)this.outputColumnName, (Object)inputColumn));
        }
        return null;
    }

    private static boolean filterMapsOverMultiValueStrings(Filter filter) {
        if (filter instanceof BooleanFilter) {
            for (Filter child : ((BooleanFilter)filter).getFilters()) {
                if (UnnestStorageAdapter.filterMapsOverMultiValueStrings(child)) continue;
                return false;
            }
            return true;
        }
        if (filter instanceof NotFilter) {
            return UnnestStorageAdapter.filterMapsOverMultiValueStrings(((NotFilter)filter).getBaseFilter());
        }
        return filter instanceof SelectorFilter || filter instanceof InDimFilter || filter instanceof LikeFilter || filter instanceof BoundFilter;
    }

    private static boolean useDimensionCursor(@Nullable ColumnCapabilities capabilities) {
        if (capabilities == null) {
            return false;
        }
        if (capabilities.isDictionaryEncoded().and(capabilities.areDictionaryValuesUnique()).isTrue()) {
            return capabilities.is(ValueType.STRING);
        }
        return false;
    }
}

