/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.data;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.druid.collections.ResourceHolder;
import org.apache.druid.segment.CompressedPools;
import org.apache.druid.segment.data.CompressionStrategy;
import org.apache.druid.segment.data.ObjectStrategy;

public class DecompressingByteBufferObjectStrategy
implements ObjectStrategy<ResourceHolder<ByteBuffer>> {
    private final ByteOrder order;
    private final CompressionStrategy.Decompressor decompressor;

    DecompressingByteBufferObjectStrategy(ByteOrder order, CompressionStrategy compression) {
        this.order = order;
        this.decompressor = compression.getDecompressor();
    }

    @Override
    public Class<ResourceHolder<ByteBuffer>> getClazz() {
        return ResourceHolder.class;
    }

    @Override
    public ResourceHolder<ByteBuffer> fromByteBuffer(ByteBuffer buffer, int numBytes) {
        final ResourceHolder<ByteBuffer> bufHolder = CompressedPools.getByteBuf(this.order);
        final ByteBuffer buf = bufHolder.get();
        buf.clear();
        this.decompressor.decompress(buffer, numBytes, buf);
        buf.limit(buf.capacity());
        return new ResourceHolder<ByteBuffer>(){

            @Override
            public ByteBuffer get() {
                return buf;
            }

            @Override
            public void close() {
                bufHolder.close();
            }
        };
    }

    @Override
    public boolean canCompare() {
        return false;
    }

    @Override
    public int compare(ResourceHolder<ByteBuffer> o1, ResourceHolder<ByteBuffer> o2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public byte[] toBytes(ResourceHolder<ByteBuffer> holder) {
        throw new UnsupportedOperationException();
    }
}

