/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.data;

import com.google.common.primitives.Ints;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.WritableByteChannel;
import javax.annotation.Nullable;
import org.apache.druid.io.Channels;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.io.smoosh.FileSmoosher;
import org.apache.druid.segment.data.DictionaryWriter;
import org.apache.druid.segment.data.FrontCodedIndexed;
import org.apache.druid.segment.data.VByte;
import org.apache.druid.segment.writeout.SegmentWriteOutMedium;
import org.apache.druid.segment.writeout.WriteOutBytes;

public class FrontCodedIndexedWriter
implements DictionaryWriter<byte[]> {
    private static final int MAX_LOG_BUFFER_SIZE = 26;
    private final SegmentWriteOutMedium segmentWriteOutMedium;
    private final int bucketSize;
    private final ByteOrder byteOrder;
    private final byte[][] bucketBuffer;
    private final ByteBuffer getOffsetBuffer;
    private final int div;
    private final byte version;
    @Nullable
    private byte[] prevObject = null;
    @Nullable
    private WriteOutBytes headerOut = null;
    @Nullable
    private WriteOutBytes valuesOut = null;
    private int numWritten = 0;
    private ByteBuffer scratch;
    private int logScratchSize = 10;
    private boolean isClosed = false;
    private boolean hasNulls = false;

    public FrontCodedIndexedWriter(SegmentWriteOutMedium segmentWriteOutMedium, ByteOrder byteOrder, int bucketSize, byte version) {
        if (Integer.bitCount(bucketSize) != 1 || bucketSize < 1 || bucketSize > 128) {
            throw new IAE("bucketSize must be a power of two (from 1 up to 128) but was[%,d]", bucketSize);
        }
        this.segmentWriteOutMedium = segmentWriteOutMedium;
        this.scratch = ByteBuffer.allocate(1 << this.logScratchSize).order(byteOrder);
        this.bucketSize = bucketSize;
        this.byteOrder = byteOrder;
        this.bucketBuffer = new byte[bucketSize][];
        this.getOffsetBuffer = ByteBuffer.allocate(4).order(byteOrder);
        this.div = Integer.numberOfTrailingZeros(bucketSize);
        this.version = FrontCodedIndexed.validateVersion(version);
    }

    @Override
    public void open() throws IOException {
        this.headerOut = this.segmentWriteOutMedium.makeWriteOutBytes();
        this.valuesOut = this.segmentWriteOutMedium.makeWriteOutBytes();
    }

    @Override
    public void write(@Nullable byte[] value) throws IOException {
        if (this.prevObject != null && FrontCodedIndexedWriter.compareNullableUtf8UsingJavaStringOrdering(this.prevObject, value) >= 0) {
            throw new ISE("Values must be sorted and unique. Element [%s] with value [%s] is before or equivalent to [%s]", this.numWritten, value == null ? null : StringUtils.fromUtf8(value), StringUtils.fromUtf8(this.prevObject));
        }
        if (value == null) {
            this.hasNulls = true;
            return;
        }
        if (this.numWritten > 0 && this.numWritten % this.bucketSize == 0) {
            int written;
            this.resetScratch();
            do {
                int n = written = this.version == 1 ? FrontCodedIndexedWriter.writeBucketV1(this.scratch, this.bucketBuffer, this.bucketSize) : FrontCodedIndexedWriter.writeBucketV0(this.scratch, this.bucketBuffer, this.bucketSize);
                if (written >= 0) continue;
                this.growScratch();
            } while (written < 0);
            this.scratch.flip();
            Channels.writeFully(this.valuesOut, this.scratch);
            this.resetScratch();
            this.scratch.putInt((int)this.valuesOut.size());
            this.scratch.flip();
            Channels.writeFully(this.headerOut, this.scratch);
        }
        this.bucketBuffer[this.numWritten % this.bucketSize] = value;
        ++this.numWritten;
        this.prevObject = value;
    }

    @Override
    public long getSerializedSize() throws IOException {
        if (!this.isClosed) {
            this.flush();
        }
        int headerAndValues = Ints.checkedCast((long)(this.headerOut.size() + this.valuesOut.size()));
        return 3 + VByte.computeIntSize(this.numWritten) + VByte.computeIntSize(headerAndValues) + headerAndValues;
    }

    @Override
    public void writeTo(WritableByteChannel channel, FileSmoosher smoosher) throws IOException {
        if (!this.isClosed) {
            this.flush();
        }
        this.resetScratch();
        this.scratch.put(this.version);
        this.scratch.put((byte)this.bucketSize);
        this.scratch.put(this.hasNulls ? (byte)1 : 0);
        VByte.writeInt(this.scratch, this.numWritten);
        VByte.writeInt(this.scratch, Ints.checkedCast((long)(this.headerOut.size() + this.valuesOut.size())));
        this.scratch.flip();
        Channels.writeFully(channel, this.scratch);
        this.headerOut.writeTo(channel);
        this.valuesOut.writeTo(channel);
    }

    @Override
    public boolean isSorted() {
        return true;
    }

    @Override
    @Nullable
    public byte[] get(int index) throws IOException {
        if (index == 0 && this.hasNulls) {
            return null;
        }
        int adjustedIndex = this.hasNulls ? index - 1 : index;
        int relativeIndex = adjustedIndex % this.bucketSize;
        if (adjustedIndex >= this.numWritten - this.bucketSize) {
            return this.bucketBuffer[relativeIndex];
        }
        int bucket = adjustedIndex >> this.div;
        long startOffset = bucket == 0 ? 0L : this.getBucketOffset(bucket - 1);
        long endOffset = this.getBucketOffset(bucket);
        int bucketBytesSize = Ints.checkedCast((long)(endOffset - startOffset));
        if (bucketBytesSize == 0) {
            return null;
        }
        ByteBuffer bucketBuffer = ByteBuffer.allocate(bucketBytesSize).order(this.byteOrder);
        this.valuesOut.readFully(startOffset, bucketBuffer);
        bucketBuffer.clear();
        ByteBuffer valueBuffer = this.version == 1 ? FrontCodedIndexedWriter.getFromBucketV1(bucketBuffer, relativeIndex, this.bucketSize) : FrontCodedIndexed.getFromBucketV0(bucketBuffer, relativeIndex);
        byte[] valueBytes = new byte[valueBuffer.limit() - valueBuffer.position()];
        valueBuffer.get(valueBytes);
        return valueBytes;
    }

    @Override
    public int getCardinality() {
        return this.numWritten + (this.hasNulls ? 1 : 0);
    }

    private long getBucketOffset(int index) throws IOException {
        this.getOffsetBuffer.clear();
        this.headerOut.readFully((long)index * 4L, this.getOffsetBuffer);
        return this.getOffsetBuffer.getInt(0);
    }

    private void flush() throws IOException {
        int written;
        if (this.numWritten == 0) {
            return;
        }
        int remainder = this.numWritten % this.bucketSize;
        this.resetScratch();
        do {
            int flushSize = remainder == 0 ? this.bucketSize : remainder;
            int n = written = this.version == 1 ? FrontCodedIndexedWriter.writeBucketV1(this.scratch, this.bucketBuffer, flushSize) : FrontCodedIndexedWriter.writeBucketV0(this.scratch, this.bucketBuffer, flushSize);
            if (written >= 0) continue;
            this.growScratch();
        } while (written < 0);
        this.scratch.flip();
        Channels.writeFully(this.valuesOut, this.scratch);
        this.resetScratch();
        this.isClosed = true;
    }

    private void resetScratch() {
        this.scratch.position(0);
        this.scratch.limit(this.scratch.capacity());
    }

    private void growScratch() {
        if (this.logScratchSize >= 26) {
            throw new IllegalStateException("scratch buffer to big to write buckets");
        }
        this.scratch = ByteBuffer.allocate(1 << ++this.logScratchSize).order(this.byteOrder);
    }

    public static int writeBucketV0(ByteBuffer buffer, byte[][] values, int numValues) {
        int written;
        byte[] first = null;
        for (written = 0; written < numValues; ++written) {
            int cmp;
            int prefixLength;
            byte[] next = values[written];
            if (written == 0) {
                first = next;
                int rem = FrontCodedIndexedWriter.writeValue(buffer, first);
                if (rem >= 0) continue;
                return rem;
            }
            for (prefixLength = 0; prefixLength < first.length && (cmp = StringUtils.compareUtf8UsingJavaStringOrdering(first[prefixLength], next[prefixLength])) == 0; ++prefixLength) {
            }
            byte[] suffix = new byte[next.length - prefixLength];
            System.arraycopy(next, prefixLength, suffix, 0, suffix.length);
            int rem = buffer.remaining() - VByte.computeIntSize(prefixLength);
            if (rem < 0) {
                return rem;
            }
            VByte.writeInt(buffer, prefixLength);
            rem = FrontCodedIndexedWriter.writeValue(buffer, suffix);
            if (rem >= 0) continue;
            return rem;
        }
        return written;
    }

    public static int writeBucketV1(ByteBuffer buffer, byte[][] values, int numValues) {
        int written;
        byte[] prev = null;
        for (written = 0; written < numValues; ++written) {
            int cmp;
            int prefixLength;
            byte[] next = values[written];
            if (written == 0) {
                prev = next;
                int rem = FrontCodedIndexedWriter.writeValue(buffer, prev);
                if (rem >= 0) continue;
                return rem;
            }
            for (prefixLength = 0; prefixLength < prev.length && (cmp = StringUtils.compareUtf8UsingJavaStringOrdering(prev[prefixLength], next[prefixLength])) == 0; ++prefixLength) {
            }
            byte[] suffix = new byte[next.length - prefixLength];
            System.arraycopy(next, prefixLength, suffix, 0, suffix.length);
            int rem = buffer.remaining() - VByte.computeIntSize(prefixLength);
            if (rem < 0) {
                return rem;
            }
            VByte.writeInt(buffer, prefixLength);
            rem = FrontCodedIndexedWriter.writeValue(buffer, suffix);
            prev = next;
            if (rem >= 0) continue;
            return rem;
        }
        return written;
    }

    public static int writeValue(ByteBuffer buffer, byte[] bytes) {
        int remaining = buffer.remaining() - VByte.computeIntSize(bytes.length) - bytes.length;
        if (remaining < 0) {
            return remaining;
        }
        int pos = buffer.position();
        VByte.writeInt(buffer, bytes.length);
        buffer.put(bytes, 0, bytes.length);
        return buffer.position() - pos;
    }

    private static int compareNullableUtf8UsingJavaStringOrdering(@Nullable byte[] b1, @Nullable byte[] b2) {
        if (b1 == null) {
            return b2 == null ? 0 : -1;
        }
        if (b2 == null) {
            return 1;
        }
        return StringUtils.compareUtf8UsingJavaStringOrdering(b1, b2);
    }

    static ByteBuffer getFromBucketV1(ByteBuffer buffer, int offset, int bucketSize) {
        int prefixLength;
        int[] unwindPrefixLength = new int[bucketSize];
        int[] unwindBufferPosition = new int[bucketSize];
        int length = VByte.readInt(buffer);
        if (offset == 0) {
            ByteBuffer value = buffer.asReadOnlyBuffer();
            value.limit(value.position() + length);
            return value;
        }
        int pos = 0;
        unwindPrefixLength[pos] = 0;
        unwindBufferPosition[pos] = buffer.position();
        buffer.position(buffer.position() + length);
        while (true) {
            prefixLength = VByte.readInt(buffer);
            if (++pos >= offset) break;
            int skipLength = VByte.readInt(buffer);
            unwindPrefixLength[pos] = prefixLength;
            unwindBufferPosition[pos] = buffer.position();
            buffer.position(buffer.position() + skipLength);
        }
        int fragmentLength = VByte.readInt(buffer);
        if (prefixLength == 0) {
            ByteBuffer value = buffer.asReadOnlyBuffer();
            value.limit(value.position() + fragmentLength);
            return value;
        }
        int valueLength = prefixLength + fragmentLength;
        byte[] valueBytes = new byte[valueLength];
        buffer.get(valueBytes, prefixLength, fragmentLength);
        int i = prefixLength;
        while (i > 0) {
            if (unwindPrefixLength[--pos] >= i) continue;
            buffer.position(unwindBufferPosition[pos]);
            buffer.get(valueBytes, unwindPrefixLength[pos], i - unwindPrefixLength[pos]);
            i = unwindPrefixLength[pos];
        }
        return ByteBuffer.wrap(valueBytes);
    }
}

