/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.filter;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.druid.math.expr.Evals;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.filter.ColumnIndexSelector;
import org.apache.druid.query.filter.Filter;
import org.apache.druid.query.filter.ValueMatcher;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.BaseDoubleColumnValueSelector;
import org.apache.druid.segment.BaseFloatColumnValueSelector;
import org.apache.druid.segment.BaseLongColumnValueSelector;
import org.apache.druid.segment.BaseObjectColumnValueSelector;
import org.apache.druid.segment.ColumnProcessorFactory;
import org.apache.druid.segment.ColumnProcessors;
import org.apache.druid.segment.ColumnSelector;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.data.IndexedInts;
import org.apache.druid.segment.filter.BooleanValueMatcher;
import org.apache.druid.segment.index.BitmapColumnIndex;

public class ColumnComparisonFilter
implements Filter {
    private final List<DimensionSpec> dimensions;

    public ColumnComparisonFilter(List<DimensionSpec> dimensions) {
        this.dimensions = (List)Preconditions.checkNotNull(dimensions, (Object)"dimensions");
    }

    @Override
    @Nullable
    public BitmapColumnIndex getBitmapColumnIndex(ColumnIndexSelector selector) {
        return null;
    }

    @Override
    public ValueMatcher makeMatcher(ColumnSelectorFactory factory) {
        ArrayList<Supplier<String[]>> valueGetters = new ArrayList<Supplier<String[]>>(this.dimensions.size());
        for (DimensionSpec dimension : this.dimensions) {
            valueGetters.add(ColumnProcessors.makeProcessor(dimension, ColumnComparisonReaderFactory.INSTANCE, factory));
        }
        return ColumnComparisonFilter.makeValueMatcher(valueGetters);
    }

    public static ValueMatcher makeValueMatcher(final List<Supplier<String[]>> valueGetters) {
        if (valueGetters.isEmpty()) {
            return BooleanValueMatcher.of(true);
        }
        return new ValueMatcher(){

            @Override
            public boolean matches() {
                String[][] values = new String[valueGetters.size()][];
                for (int i = 0; i < valueGetters.size(); ++i) {
                    values[i] = (String[])((Supplier)valueGetters.get(i)).get();
                    for (int j = 0; j < i; ++j) {
                        if (ColumnComparisonFilter.overlap(values[i], values[j])) continue;
                        return false;
                    }
                }
                return true;
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                inspector.visit("oneValueGetter", valueGetters.get(0));
            }
        };
    }

    public static boolean overlap(@Nullable String[] as, @Nullable String[] bs) {
        if (as == null || bs == null) {
            return as == null && bs == null;
        }
        if (as.length == 0 && bs.length == 0) {
            return true;
        }
        for (String a : as) {
            for (String b : bs) {
                if (!Objects.equals(a, b)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean supportsSelectivityEstimation(ColumnSelector columnSelector, ColumnIndexSelector indexSelector) {
        return false;
    }

    @Override
    public Set<String> getRequiredColumns() {
        return this.dimensions.stream().map(DimensionSpec::getDimension).collect(Collectors.toSet());
    }

    @Override
    public double estimateSelectivity(ColumnIndexSelector indexSelector) {
        throw new UnsupportedOperationException();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ColumnComparisonFilter that = (ColumnComparisonFilter)o;
        return Objects.equals(this.dimensions, that.dimensions);
    }

    public int hashCode() {
        return Objects.hash(this.dimensions);
    }

    private static class ColumnComparisonReaderFactory
    implements ColumnProcessorFactory<Supplier<String[]>> {
        private static final ColumnComparisonReaderFactory INSTANCE = new ColumnComparisonReaderFactory();
        private static final String[] NULL_VALUE = new String[]{null};

        private ColumnComparisonReaderFactory() {
        }

        @Override
        public ColumnType defaultType() {
            return ColumnType.STRING;
        }

        @Override
        public Supplier<String[]> makeDimensionProcessor(DimensionSelector selector, boolean multiValue) {
            return () -> {
                IndexedInts row = selector.getRow();
                int size = row.size();
                if (size == 0) {
                    return NULL_VALUE;
                }
                String[] values = new String[size];
                for (int i = 0; i < size; ++i) {
                    values[i] = selector.lookupName(row.get(i));
                }
                return values;
            };
        }

        @Override
        public Supplier<String[]> makeFloatProcessor(BaseFloatColumnValueSelector selector) {
            return () -> {
                if (selector.isNull()) {
                    return NULL_VALUE;
                }
                return new String[]{Float.toString(selector.getFloat())};
            };
        }

        @Override
        public Supplier<String[]> makeDoubleProcessor(BaseDoubleColumnValueSelector selector) {
            return () -> {
                if (selector.isNull()) {
                    return NULL_VALUE;
                }
                return new String[]{Double.toString(selector.getDouble())};
            };
        }

        @Override
        public Supplier<String[]> makeLongProcessor(BaseLongColumnValueSelector selector) {
            return () -> {
                if (selector.isNull()) {
                    return NULL_VALUE;
                }
                return new String[]{Long.toString(selector.getLong())};
            };
        }

        @Override
        public Supplier<String[]> makeArrayProcessor(BaseObjectColumnValueSelector<?> selector, @Nullable ColumnCapabilities columnCapabilities) {
            return () -> {
                Object o = selector.getObject();
                if (o instanceof Object[]) {
                    Object[] arr = (Object[])o;
                    String[] s = new String[arr.length];
                    for (int i = 0; i < arr.length; ++i) {
                        s[i] = Evals.asString(arr[i]);
                    }
                    return s;
                }
                return NULL_VALUE;
            };
        }

        @Override
        public Supplier<String[]> makeComplexProcessor(BaseObjectColumnValueSelector<?> selector) {
            return () -> NULL_VALUE;
        }
    }
}

