/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.filter;

import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.java.util.common.UOE;
import org.apache.druid.math.expr.Evals;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.ExprType;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.math.expr.InputBindings;
import org.apache.druid.query.filter.ColumnIndexSelector;
import org.apache.druid.query.filter.DruidDoublePredicate;
import org.apache.druid.query.filter.DruidFloatPredicate;
import org.apache.druid.query.filter.DruidLongPredicate;
import org.apache.druid.query.filter.DruidPredicateFactory;
import org.apache.druid.query.filter.Filter;
import org.apache.druid.query.filter.FilterTuning;
import org.apache.druid.query.filter.ValueMatcher;
import org.apache.druid.query.filter.vector.BooleanVectorValueMatcher;
import org.apache.druid.query.filter.vector.VectorValueMatcher;
import org.apache.druid.query.filter.vector.VectorValueMatcherColumnProcessorFactory;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.ColumnInspector;
import org.apache.druid.segment.ColumnSelector;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnCapabilitiesImpl;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.TypeSignature;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.filter.Filters;
import org.apache.druid.segment.index.BitmapColumnIndex;
import org.apache.druid.segment.vector.VectorColumnSelectorFactory;
import org.apache.druid.segment.virtual.ExpressionSelectors;
import org.apache.druid.segment.virtual.ExpressionVectorSelectors;

public class ExpressionFilter
implements Filter {
    private final Supplier<Expr> expr;
    private final Supplier<Expr.BindingAnalysis> bindingDetails;
    private final FilterTuning filterTuning;

    public ExpressionFilter(Supplier<Expr> expr, FilterTuning filterTuning) {
        this.expr = expr;
        this.bindingDetails = Suppliers.memoize(() -> ((Expr)expr.get()).analyzeInputs());
        this.filterTuning = filterTuning;
    }

    @Override
    public boolean canVectorizeMatcher(ColumnInspector inspector) {
        return ((Expr)this.expr.get()).canVectorize(inspector);
    }

    @Override
    public VectorValueMatcher makeVectorMatcher(VectorColumnSelectorFactory factory) {
        Expr theExpr = (Expr)this.expr.get();
        DruidPredicateFactory predicateFactory = this.getPredicateFactory();
        ExpressionType outputType = theExpr.getOutputType(factory);
        if (outputType == null) {
            if (NullHandling.sqlCompatible()) {
                return BooleanVectorValueMatcher.of(factory.getReadableVectorInspector(), false);
            }
            return BooleanVectorValueMatcher.of(factory.getReadableVectorInspector(), theExpr.eval(InputBindings.nilBindings()).asBoolean());
        }
        switch ((ExprType)outputType.getType()) {
            case LONG: {
                return VectorValueMatcherColumnProcessorFactory.instance().makeLongProcessor(ColumnCapabilitiesImpl.createSimpleNumericColumnCapabilities(ColumnType.LONG), ExpressionVectorSelectors.makeVectorValueSelector(factory, theExpr)).makeMatcher(predicateFactory);
            }
            case DOUBLE: {
                return VectorValueMatcherColumnProcessorFactory.instance().makeDoubleProcessor(ColumnCapabilitiesImpl.createSimpleNumericColumnCapabilities(ColumnType.DOUBLE), ExpressionVectorSelectors.makeVectorValueSelector(factory, theExpr)).makeMatcher(predicateFactory);
            }
            case STRING: {
                return VectorValueMatcherColumnProcessorFactory.instance().makeObjectProcessor(ColumnCapabilitiesImpl.createSimpleSingleValueStringColumnCapabilities(), ExpressionVectorSelectors.makeVectorObjectSelector(factory, theExpr)).makeMatcher(predicateFactory);
            }
            case ARRAY: {
                return VectorValueMatcherColumnProcessorFactory.instance().makeObjectProcessor(ColumnCapabilitiesImpl.createDefault().setType(ExpressionType.toColumnType(outputType)).setHasNulls(true), ExpressionVectorSelectors.makeVectorObjectSelector(factory, theExpr)).makeMatcher(predicateFactory);
            }
        }
        if (ExpressionType.NESTED_DATA.equals(outputType)) {
            return VectorValueMatcherColumnProcessorFactory.instance().makeObjectProcessor(ColumnCapabilitiesImpl.createDefault().setType(ExpressionType.toColumnType(outputType)).setHasNulls(true), ExpressionVectorSelectors.makeVectorObjectSelector(factory, theExpr)).makeMatcher(predicateFactory);
        }
        throw new UOE("Vectorized expression matchers not implemented for type: [%s]", outputType);
    }

    @Override
    public ValueMatcher makeMatcher(ColumnSelectorFactory factory) {
        final ColumnValueSelector<ExprEval> selector = ExpressionSelectors.makeExprEvalSelector(factory, (Expr)this.expr.get());
        return new ValueMatcher(){

            @Override
            public boolean matches() {
                ExprEval eval = (ExprEval)selector.getObject();
                if (eval.type().isArray()) {
                    switch ((ExprType)eval.elementType().getType()) {
                        case LONG: {
                            Object[] lResult = eval.asArray();
                            if (lResult == null) {
                                return false;
                            }
                            return Arrays.stream(lResult).filter(Objects::nonNull).anyMatch(o -> Evals.asBoolean((Long)o));
                        }
                        case STRING: {
                            Object[] sResult = eval.asArray();
                            if (sResult == null) {
                                return false;
                            }
                            return Arrays.stream(sResult).anyMatch(o -> Evals.asBoolean((String)o));
                        }
                        case DOUBLE: {
                            Object[] dResult = eval.asArray();
                            if (dResult == null) {
                                return false;
                            }
                            return Arrays.stream(dResult).filter(Objects::nonNull).anyMatch(o -> Evals.asBoolean((Double)o));
                        }
                    }
                }
                return eval.asBoolean();
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                inspector.visit("selector", selector);
            }
        };
    }

    @Override
    @Nullable
    public BitmapColumnIndex getBitmapColumnIndex(ColumnIndexSelector selector) {
        String column;
        ColumnCapabilities capabilities;
        Expr.BindingAnalysis details = (Expr.BindingAnalysis)this.bindingDetails.get();
        if (details.getRequiredBindings().isEmpty()) {
            return Filters.makeMissingColumnNullIndex(((Expr)this.expr.get()).eval(InputBindings.nilBindings()).asBoolean(), selector);
        }
        if (details.getRequiredBindings().size() == 1 && ExpressionSelectors.canMapOverDictionary(details, capabilities = selector.getColumnCapabilities(column = (String)Iterables.getOnlyElement(details.getRequiredBindings())))) {
            if (!Filters.checkFilterTuningUseIndex(column, selector, this.filterTuning)) {
                return null;
            }
            return Filters.makePredicateIndex(column, selector, this.getBitmapPredicateFactory(capabilities));
        }
        return null;
    }

    @Override
    public boolean supportsSelectivityEstimation(ColumnSelector columnSelector, ColumnIndexSelector indexSelector) {
        return false;
    }

    @Override
    public double estimateSelectivity(ColumnIndexSelector indexSelector) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<String> getRequiredColumns() {
        return ((Expr.BindingAnalysis)this.bindingDetails.get()).getRequiredBindings();
    }

    @Override
    public boolean supportsRequiredColumnRewrite() {
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExpressionFilter that = (ExpressionFilter)o;
        return Objects.equals(this.expr, that.expr) && Objects.equals(this.filterTuning, that.filterTuning);
    }

    public int hashCode() {
        return Objects.hash(this.expr, this.filterTuning);
    }

    public String toString() {
        return "ExpressionFilter{expr=" + this.expr + ", filterTuning=" + this.filterTuning + '}';
    }

    private DruidPredicateFactory getPredicateFactory() {
        return new DruidPredicateFactory(){

            @Override
            public Predicate<String> makeStringPredicate() {
                return Evals::asBoolean;
            }

            @Override
            public DruidLongPredicate makeLongPredicate() {
                return Evals::asBoolean;
            }

            @Override
            public DruidFloatPredicate makeFloatPredicate() {
                return Evals::asBoolean;
            }

            @Override
            public DruidDoublePredicate makeDoublePredicate() {
                return Evals::asBoolean;
            }

            @Override
            public Predicate<Object> makeObjectPredicate() {
                return Evals::objectAsBoolean;
            }

            public int hashCode() {
                return super.hashCode();
            }

            public boolean equals(Object obj) {
                return super.equals(obj);
            }
        };
    }

    private DruidPredicateFactory getBitmapPredicateFactory(final @Nullable ColumnCapabilities inputCapabilites) {
        return new DruidPredicateFactory(){

            @Override
            public Predicate<String> makeStringPredicate() {
                return value -> ((Expr)ExpressionFilter.this.expr.get()).eval(InputBindings.forInputSupplier(ExpressionType.STRING, () -> NullHandling.nullToEmptyIfNeeded(value))).asBoolean();
            }

            @Override
            public DruidLongPredicate makeLongPredicate() {
                return new DruidLongPredicate(){

                    @Override
                    public boolean applyLong(long input) {
                        return ((Expr)ExpressionFilter.this.expr.get()).eval(InputBindings.forInputSupplier(ExpressionType.LONG, () -> input)).asBoolean();
                    }

                    @Override
                    public boolean applyNull() {
                        return ((Expr)ExpressionFilter.this.expr.get()).eval(InputBindings.nilBindings()).asBoolean();
                    }
                };
            }

            @Override
            public DruidFloatPredicate makeFloatPredicate() {
                return new DruidFloatPredicate(){

                    @Override
                    public boolean applyFloat(float input) {
                        return ((Expr)ExpressionFilter.this.expr.get()).eval(InputBindings.forInputSupplier(ExpressionType.DOUBLE, () -> Float.valueOf(input))).asBoolean();
                    }

                    @Override
                    public boolean applyNull() {
                        return ((Expr)ExpressionFilter.this.expr.get()).eval(InputBindings.nilBindings()).asBoolean();
                    }
                };
            }

            @Override
            public DruidDoublePredicate makeDoublePredicate() {
                return new DruidDoublePredicate(){

                    @Override
                    public boolean applyDouble(double input) {
                        return ((Expr)ExpressionFilter.this.expr.get()).eval(InputBindings.forInputSupplier(ExpressionType.DOUBLE, () -> input)).asBoolean();
                    }

                    @Override
                    public boolean applyNull() {
                        return ((Expr)ExpressionFilter.this.expr.get()).eval(InputBindings.nilBindings()).asBoolean();
                    }
                };
            }

            @Override
            public Predicate<Object[]> makeArrayPredicate(@Nullable TypeSignature<ValueType> arrayType) {
                if (inputCapabilites == null) {
                    return input -> ((Expr)ExpressionFilter.this.expr.get()).eval(InputBindings.forInputSupplier(ExpressionType.STRING_ARRAY, () -> input)).asBoolean();
                }
                return input -> ((Expr)ExpressionFilter.this.expr.get()).eval(InputBindings.forInputSupplier(ExpressionType.fromColumnType(inputCapabilites), () -> input)).asBoolean();
            }

            public int hashCode() {
                return super.hashCode();
            }

            public boolean equals(Object obj) {
                return super.equals(obj);
            }
        };
    }
}

