/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.filter;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.druid.query.filter.ColumnIndexSelector;
import org.apache.druid.query.filter.Filter;
import org.apache.druid.query.filter.ValueMatcher;
import org.apache.druid.query.filter.vector.BooleanVectorValueMatcher;
import org.apache.druid.query.filter.vector.VectorValueMatcher;
import org.apache.druid.segment.ColumnInspector;
import org.apache.druid.segment.ColumnSelector;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.filter.FalseValueMatcher;
import org.apache.druid.segment.index.AllFalseBitmapColumnIndex;
import org.apache.druid.segment.index.BitmapColumnIndex;
import org.apache.druid.segment.vector.VectorColumnSelectorFactory;

public class FalseFilter
implements Filter {
    private static final FalseFilter INSTANCE = new FalseFilter();

    public static FalseFilter instance() {
        return INSTANCE;
    }

    private FalseFilter() {
    }

    @Override
    @Nullable
    public BitmapColumnIndex getBitmapColumnIndex(ColumnIndexSelector selector) {
        return new AllFalseBitmapColumnIndex(selector);
    }

    @Override
    public double estimateSelectivity(ColumnIndexSelector indexSelector) {
        return 0.0;
    }

    @Override
    public ValueMatcher makeMatcher(ColumnSelectorFactory factory) {
        return FalseValueMatcher.instance();
    }

    @Override
    public VectorValueMatcher makeVectorMatcher(VectorColumnSelectorFactory factory) {
        return BooleanVectorValueMatcher.of(factory.getReadableVectorInspector(), false);
    }

    @Override
    public boolean supportsSelectivityEstimation(ColumnSelector columnSelector, ColumnIndexSelector indexSelector) {
        return true;
    }

    @Override
    public boolean canVectorizeMatcher(ColumnInspector inspector) {
        return true;
    }

    @Override
    public Set<String> getRequiredColumns() {
        return Collections.emptySet();
    }

    @Override
    public boolean supportsRequiredColumnRewrite() {
        return true;
    }

    @Override
    public Filter rewriteRequiredColumns(Map<String, String> columnRewrites) {
        return this;
    }

    public String toString() {
        return "false";
    }

    public final int hashCode() {
        return FalseFilter.class.hashCode();
    }

    public final boolean equals(Object obj) {
        return obj instanceof FalseFilter;
    }
}

