/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.filter;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.druid.collections.bitmap.ImmutableBitmap;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.query.DefaultBitmapResultFactory;
import org.apache.druid.query.Query;
import org.apache.druid.query.filter.ColumnIndexSelector;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.DruidPredicateFactory;
import org.apache.druid.query.filter.Filter;
import org.apache.druid.query.filter.FilterTuning;
import org.apache.druid.query.filter.ValueMatcher;
import org.apache.druid.segment.ColumnProcessors;
import org.apache.druid.segment.ColumnSelector;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.column.ColumnHolder;
import org.apache.druid.segment.column.ColumnIndexSupplier;
import org.apache.druid.segment.filter.AndFilter;
import org.apache.druid.segment.filter.FalseFilter;
import org.apache.druid.segment.filter.OrFilter;
import org.apache.druid.segment.filter.PredicateValueMatcherFactory;
import org.apache.druid.segment.filter.TrueFilter;
import org.apache.druid.segment.filter.cnf.CNFFilterExplosionException;
import org.apache.druid.segment.filter.cnf.CalciteCnfHelper;
import org.apache.druid.segment.filter.cnf.HiveCnfHelper;
import org.apache.druid.segment.index.AllFalseBitmapColumnIndex;
import org.apache.druid.segment.index.AllTrueBitmapColumnIndex;
import org.apache.druid.segment.index.BitmapColumnIndex;
import org.apache.druid.segment.index.semantic.DictionaryEncodedStringValueIndex;
import org.apache.druid.segment.index.semantic.DruidPredicateIndexes;
import org.apache.druid.segment.join.filter.AllNullColumnSelectorFactory;

public class Filters {
    private static final ColumnSelectorFactory ALL_NULL_COLUMN_SELECTOR_FACTORY = new AllNullColumnSelectorFactory();

    public static List<Filter> toFilters(List<DimFilter> dimFilters) {
        return dimFilters.stream().map(Filters::toFilter).collect(Collectors.toList());
    }

    @Nullable
    public static Filter toFilter(@Nullable DimFilter dimFilter) {
        return dimFilter == null ? null : dimFilter.toOptimizedFilter();
    }

    public static ValueMatcher makeValueMatcher(ColumnSelectorFactory columnSelectorFactory, String columnName, DruidPredicateFactory predicateFactory) {
        return ColumnProcessors.makeProcessor(columnName, new PredicateValueMatcherFactory(predicateFactory), columnSelectorFactory);
    }

    @Nullable
    public static BitmapColumnIndex makePredicateIndex(String column, ColumnIndexSelector selector, DruidPredicateFactory predicateFactory) {
        Preconditions.checkNotNull((Object)column, (Object)"column");
        Preconditions.checkNotNull((Object)selector, (Object)"selector");
        Preconditions.checkNotNull((Object)predicateFactory, (Object)"predicateFactory");
        ColumnIndexSupplier indexSupplier = selector.getIndexSupplier(column);
        if (indexSupplier != null) {
            DruidPredicateIndexes predicateIndexes = indexSupplier.as(DruidPredicateIndexes.class);
            if (predicateIndexes != null) {
                return predicateIndexes.forPredicate(predicateFactory);
            }
            return null;
        }
        return predicateFactory.makeStringPredicate().apply(null) ? new AllTrueBitmapColumnIndex(selector) : new AllFalseBitmapColumnIndex(selector);
    }

    public static BitmapColumnIndex makeMissingColumnNullIndex(boolean matchesNull, ColumnIndexSelector selector) {
        return matchesNull ? new AllTrueBitmapColumnIndex(selector) : new AllFalseBitmapColumnIndex(selector);
    }

    public static ImmutableBitmap computeDefaultBitmapResults(Filter filter, ColumnIndexSelector selector) {
        return filter.getBitmapColumnIndex(selector).computeBitmapResult(new DefaultBitmapResultFactory(selector.getBitmapFactory()));
    }

    public static boolean supportsSelectivityEstimation(Filter filter, String dimension, ColumnSelector columnSelector, ColumnIndexSelector indexSelector) {
        ColumnHolder columnHolder;
        if (filter.getBitmapColumnIndex(indexSelector) != null && (columnHolder = columnSelector.getColumnHolder(dimension)) != null) {
            return columnHolder.getCapabilities().hasMultipleValues().isFalse();
        }
        return false;
    }

    public static double estimateSelectivity(Iterator<ImmutableBitmap> bitmaps, long totalNumRows) {
        long numMatchedRows = 0L;
        while (bitmaps.hasNext()) {
            ImmutableBitmap bitmap = bitmaps.next();
            numMatchedRows += (long)bitmap.size();
        }
        return Math.min(1.0, (double)numMatchedRows / (double)totalNumRows);
    }

    @Nullable
    public static Filter convertToCNFFromQueryContext(Query query, @Nullable Filter filter) {
        if (filter == null) {
            return null;
        }
        boolean useCNF = query.context().getBoolean("useFilterCNF", false);
        try {
            return useCNF ? Filters.toCnf(filter) : filter;
        }
        catch (CNFFilterExplosionException cnfFilterExplosionException) {
            return filter;
        }
    }

    public static Filter toCnf(Filter current) throws CNFFilterExplosionException {
        current = HiveCnfHelper.pushDownNot(current);
        current = HiveCnfHelper.flatten(current);
        current = CalciteCnfHelper.pull(current);
        current = HiveCnfHelper.convertToCnf(current);
        current = HiveCnfHelper.flatten(current);
        return current;
    }

    public static boolean checkFilterTuningUseIndex(String columnName, ColumnIndexSelector indexSelector, @Nullable FilterTuning filterTuning) {
        if (filterTuning != null) {
            DictionaryEncodedStringValueIndex valueIndex;
            ColumnIndexSupplier indexSupplier;
            if (!filterTuning.getUseBitmapIndex()) {
                return false;
            }
            if (filterTuning.hasValueCardinalityThreshold() && (indexSupplier = indexSelector.getIndexSupplier(columnName)) != null && (valueIndex = indexSupplier.as(DictionaryEncodedStringValueIndex.class)) != null) {
                int cardinality = valueIndex.getCardinality();
                Integer min = filterTuning.getMinCardinalityToUseBitmapIndex();
                Integer max = filterTuning.getMaxCardinalityToUseBitmapIndex();
                if (min != null && cardinality < min) {
                    return false;
                }
                if (max != null && cardinality > max) {
                    return false;
                }
            }
        }
        return true;
    }

    public static Filter and(List<Filter> filters) {
        return Filters.maybeAnd(filters).orElseThrow(() -> new IAE("Expected nonempty filters list", new Object[0]));
    }

    public static Optional<Filter> maybeAnd(List<Filter> filters) {
        List<Filter> nonNullFilters = Filters.nonNull(filters);
        if (nonNullFilters.isEmpty()) {
            return Optional.empty();
        }
        LinkedHashSet<Filter> filtersToUse = Filters.flattenAndChildren(nonNullFilters);
        if (filtersToUse.isEmpty()) {
            assert (!filters.isEmpty());
            return Optional.of(TrueFilter.instance());
        }
        if (filtersToUse.stream().anyMatch(filter -> filter instanceof FalseFilter)) {
            return Optional.of(FalseFilter.instance());
        }
        if (filtersToUse.size() == 1) {
            return Optional.of(Iterables.getOnlyElement(filtersToUse));
        }
        return Optional.of(new AndFilter(filtersToUse));
    }

    public static Filter or(List<Filter> filters) {
        return Filters.maybeOr(filters).orElseThrow(() -> new IAE("Expected nonempty filters list", new Object[0]));
    }

    public static Optional<Filter> maybeOr(List<Filter> filters) {
        List<Filter> nonNullFilters = Filters.nonNull(filters);
        if (nonNullFilters.isEmpty()) {
            return Optional.empty();
        }
        LinkedHashSet<Filter> filtersToUse = Filters.flattenOrChildren(nonNullFilters);
        if (filtersToUse.isEmpty()) {
            assert (!nonNullFilters.isEmpty());
            return Optional.of(FalseFilter.instance());
        }
        if (filtersToUse.stream().anyMatch(filter -> filter instanceof TrueFilter)) {
            return Optional.of(TrueFilter.instance());
        }
        if (filtersToUse.size() == 1) {
            return Optional.of(Iterables.getOnlyElement(filtersToUse));
        }
        return Optional.of(new OrFilter(filtersToUse));
    }

    public static List<Filter> toNormalizedOrClauses(Filter filter) throws CNFFilterExplosionException {
        Filter normalizedFilter = Filters.toCnf(filter);
        List<Filter> normalizedOrClauses = normalizedFilter instanceof AndFilter ? new ArrayList<Filter>(((AndFilter)normalizedFilter).getFilters()) : Collections.singletonList(normalizedFilter);
        return normalizedOrClauses;
    }

    public static boolean filterMatchesNull(Filter filter) {
        ValueMatcher valueMatcher = filter.makeMatcher(ALL_NULL_COLUMN_SELECTOR_FACTORY);
        return valueMatcher.matches();
    }

    private static List<Filter> nonNull(List<Filter> filters) {
        if (filters.stream().anyMatch(Objects::isNull)) {
            return filters.stream().filter(Objects::nonNull).collect(Collectors.toList());
        }
        return filters;
    }

    private static LinkedHashSet<Filter> flattenAndChildren(Collection<Filter> filters) {
        LinkedHashSet<Filter> retVal = new LinkedHashSet<Filter>();
        for (Filter child : filters) {
            if (child instanceof AndFilter) {
                retVal.addAll(Filters.flattenAndChildren(((AndFilter)child).getFilters()));
                continue;
            }
            if (child instanceof TrueFilter) continue;
            retVal.add(child);
        }
        return retVal;
    }

    private static LinkedHashSet<Filter> flattenOrChildren(Collection<Filter> filters) {
        LinkedHashSet<Filter> retVal = new LinkedHashSet<Filter>();
        for (Filter child : filters) {
            if (child instanceof OrFilter) {
                retVal.addAll(Filters.flattenOrChildren(((OrFilter)child).getFilters()));
                continue;
            }
            if (child instanceof FalseFilter) continue;
            retVal.add(child);
        }
        return retVal;
    }
}

