/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.filter;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.query.extraction.ExtractionFn;
import org.apache.druid.query.filter.ColumnIndexSelector;
import org.apache.druid.query.filter.Filter;
import org.apache.druid.query.filter.FilterTuning;
import org.apache.druid.query.filter.LikeDimFilter;
import org.apache.druid.query.filter.ValueMatcher;
import org.apache.druid.query.filter.vector.VectorValueMatcher;
import org.apache.druid.query.filter.vector.VectorValueMatcherColumnProcessorFactory;
import org.apache.druid.segment.ColumnInspector;
import org.apache.druid.segment.ColumnProcessors;
import org.apache.druid.segment.ColumnSelector;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.column.ColumnIndexSupplier;
import org.apache.druid.segment.filter.Filters;
import org.apache.druid.segment.index.AllFalseBitmapColumnIndex;
import org.apache.druid.segment.index.AllTrueBitmapColumnIndex;
import org.apache.druid.segment.index.BitmapColumnIndex;
import org.apache.druid.segment.index.semantic.LexicographicalRangeIndexes;
import org.apache.druid.segment.index.semantic.StringValueSetIndexes;
import org.apache.druid.segment.vector.VectorColumnSelectorFactory;

public class LikeFilter
implements Filter {
    private final String dimension;
    private final ExtractionFn extractionFn;
    private final LikeDimFilter.LikeMatcher likeMatcher;
    private final FilterTuning filterTuning;

    public LikeFilter(String dimension, ExtractionFn extractionFn, LikeDimFilter.LikeMatcher likeMatcher, FilterTuning filterTuning) {
        this.dimension = dimension;
        this.extractionFn = extractionFn;
        this.likeMatcher = likeMatcher;
        this.filterTuning = filterTuning;
    }

    @Override
    @Nullable
    public BitmapColumnIndex getBitmapColumnIndex(ColumnIndexSelector selector) {
        LexicographicalRangeIndexes rangeIndexes;
        StringValueSetIndexes valueIndexes;
        if (!Filters.checkFilterTuningUseIndex(this.dimension, selector, this.filterTuning)) {
            return null;
        }
        ColumnIndexSupplier indexSupplier = selector.getIndexSupplier(this.dimension);
        if (indexSupplier == null) {
            return this.likeMatcher.matches(null) ? new AllTrueBitmapColumnIndex(selector) : new AllFalseBitmapColumnIndex(selector);
        }
        if (this.isSimpleEquals() && (valueIndexes = indexSupplier.as(StringValueSetIndexes.class)) != null) {
            return valueIndexes.forValue(NullHandling.emptyToNullIfNeeded(this.likeMatcher.getPrefix()));
        }
        if (this.isSimplePrefix() && (rangeIndexes = indexSupplier.as(LexicographicalRangeIndexes.class)) != null) {
            String lower = NullHandling.nullToEmptyIfNeeded(this.likeMatcher.getPrefix());
            String upper = NullHandling.nullToEmptyIfNeeded(this.likeMatcher.getPrefix()) + '\uffff';
            if (this.likeMatcher.getSuffixMatch() == LikeDimFilter.LikeMatcher.SuffixMatch.MATCH_ANY) {
                return rangeIndexes.forRange(lower, false, upper, false);
            }
            return rangeIndexes.forRange(lower, false, upper, false, (Predicate<String>)((Predicate)this.likeMatcher::matchesSuffixOnly));
        }
        return Filters.makePredicateIndex(this.dimension, selector, this.likeMatcher.predicateFactory(this.extractionFn));
    }

    @Override
    public ValueMatcher makeMatcher(ColumnSelectorFactory factory) {
        return Filters.makeValueMatcher(factory, this.dimension, this.likeMatcher.predicateFactory(this.extractionFn));
    }

    @Override
    public VectorValueMatcher makeVectorMatcher(VectorColumnSelectorFactory factory) {
        return ColumnProcessors.makeVectorProcessor(this.dimension, VectorValueMatcherColumnProcessorFactory.instance(), factory).makeMatcher(this.likeMatcher.predicateFactory(this.extractionFn));
    }

    @Override
    public boolean canVectorizeMatcher(ColumnInspector inspector) {
        return true;
    }

    @Override
    public Set<String> getRequiredColumns() {
        return ImmutableSet.of((Object)this.dimension);
    }

    @Override
    public boolean supportsRequiredColumnRewrite() {
        return true;
    }

    @Override
    public Filter rewriteRequiredColumns(Map<String, String> columnRewrites) {
        String rewriteDimensionTo = columnRewrites.get(this.dimension);
        if (rewriteDimensionTo == null) {
            throw new IAE("Received a non-applicable rewrite: %s, filter's dimension: %s", columnRewrites, this.dimension);
        }
        return new LikeFilter(rewriteDimensionTo, this.extractionFn, this.likeMatcher, this.filterTuning);
    }

    @Override
    public boolean supportsSelectivityEstimation(ColumnSelector columnSelector, ColumnIndexSelector indexSelector) {
        return Filters.supportsSelectivityEstimation(this, this.dimension, columnSelector, indexSelector);
    }

    private boolean isSimpleEquals() {
        return this.extractionFn == null && this.likeMatcher.getSuffixMatch() == LikeDimFilter.LikeMatcher.SuffixMatch.MATCH_EMPTY;
    }

    private boolean isSimplePrefix() {
        return this.extractionFn == null && !this.likeMatcher.getPrefix().isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LikeFilter that = (LikeFilter)o;
        return Objects.equals(this.dimension, that.dimension) && Objects.equals(this.extractionFn, that.extractionFn) && Objects.equals(this.likeMatcher, that.likeMatcher) && Objects.equals(this.filterTuning, that.filterTuning);
    }

    public int hashCode() {
        return Objects.hash(this.dimension, this.extractionFn, this.likeMatcher, this.filterTuning);
    }
}

