/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.index;

import org.apache.druid.collections.bitmap.BitmapFactory;
import org.apache.druid.query.BitmapResultFactory;
import org.apache.druid.query.filter.ColumnIndexSelector;
import org.apache.druid.segment.column.ColumnIndexCapabilities;
import org.apache.druid.segment.column.SimpleColumnIndexCapabilities;
import org.apache.druid.segment.index.BitmapColumnIndex;

public class AllFalseBitmapColumnIndex
implements BitmapColumnIndex {
    private final BitmapFactory bitmapFactory;

    public AllFalseBitmapColumnIndex(ColumnIndexSelector indexSelector) {
        this(indexSelector.getBitmapFactory());
    }

    public AllFalseBitmapColumnIndex(BitmapFactory bitmapFactory) {
        this.bitmapFactory = bitmapFactory;
    }

    @Override
    public ColumnIndexCapabilities getIndexCapabilities() {
        return SimpleColumnIndexCapabilities.getConstant();
    }

    @Override
    public double estimateSelectivity(int totalRows) {
        return 0.0;
    }

    @Override
    public <T> T computeBitmapResult(BitmapResultFactory<T> bitmapResultFactory) {
        return bitmapResultFactory.wrapAllFalse(this.bitmapFactory.makeEmptyImmutableBitmap());
    }
}

