/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.index;

import org.apache.druid.query.BitmapResultFactory;
import org.apache.druid.query.filter.ColumnIndexSelector;
import org.apache.druid.segment.column.ColumnIndexCapabilities;
import org.apache.druid.segment.column.SimpleColumnIndexCapabilities;
import org.apache.druid.segment.index.BitmapColumnIndex;

public class AllTrueBitmapColumnIndex
implements BitmapColumnIndex {
    private final ColumnIndexSelector selector;

    public AllTrueBitmapColumnIndex(ColumnIndexSelector indexSelector) {
        this.selector = indexSelector;
    }

    @Override
    public ColumnIndexCapabilities getIndexCapabilities() {
        return SimpleColumnIndexCapabilities.getConstant();
    }

    @Override
    public double estimateSelectivity(int totalRows) {
        return 1.0;
    }

    @Override
    public <T> T computeBitmapResult(BitmapResultFactory<T> bitmapResultFactory) {
        return bitmapResultFactory.wrapAllTrue(this.selector.getBitmapFactory().complement(this.selector.getBitmapFactory().makeEmptyImmutableBitmap(), this.selector.getNumRows()));
    }
}

