/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.join.table;

import com.google.common.primitives.Ints;
import it.unimi.dsi.fastutil.ints.IntAVLTreeSet;
import it.unimi.dsi.fastutil.ints.IntSortedSet;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.segment.DimensionHandlerUtils;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.join.table.IndexedTable;
import org.apache.druid.segment.join.table.MapIndex;
import org.apache.druid.segment.join.table.UniqueLongArrayIndex;

public class RowBasedIndexBuilder {
    private static final long INT_ARRAY_SPACE_SAVINGS_FACTOR = 15L;
    private static final long INT_ARRAY_SMALL_SIZE_OK = 250000L;
    private int currentRow = 0;
    private int nullKeys = 0;
    private final ColumnType keyType;
    private final Map<Object, IntSortedSet> index;
    private long minLongKey = Long.MAX_VALUE;
    private long maxLongKey = Long.MIN_VALUE;

    public RowBasedIndexBuilder(ColumnType keyType) {
        Long2ObjectOpenHashMap theMap;
        this.keyType = keyType;
        this.index = keyType.is(ValueType.LONG) ? (theMap = new Long2ObjectOpenHashMap()) : new HashMap<Object, IntSortedSet>();
    }

    public RowBasedIndexBuilder add(@Nullable Object key) {
        Comparable<?> castKey = DimensionHandlerUtils.convertObjectToType(key, this.keyType);
        if (castKey != null) {
            IntSortedSet rowNums = this.index.computeIfAbsent(castKey, k -> new IntAVLTreeSet());
            rowNums.add(this.currentRow);
            if (this.keyType.is(ValueType.LONG) && (Long)castKey < this.minLongKey) {
                this.minLongKey = (Long)castKey;
            }
            if (this.keyType.is(ValueType.LONG) && (Long)castKey > this.maxLongKey) {
                this.maxLongKey = (Long)castKey;
            }
        } else {
            ++this.nullKeys;
        }
        ++this.currentRow;
        return this;
    }

    public IndexedTable.Index build() {
        boolean keysUnique;
        boolean bl = keysUnique = this.index.size() == this.currentRow - this.nullKeys;
        if (this.keyType.is(ValueType.LONG) && keysUnique && this.index.size() > 0) {
            long range;
            try {
                range = Math.addExact(Math.subtractExact(this.maxLongKey, this.minLongKey), 1L);
            }
            catch (ArithmeticException e) {
                range = 0L;
            }
            long rangeThreshold = Math.max(250000L, Math.min(Integer.MAX_VALUE, 15L * (long)this.index.size()));
            if (range > 0L && range < rangeThreshold) {
                int[] indexAsArray = new int[Ints.checkedCast((long)range)];
                Arrays.fill(indexAsArray, -1);
                ObjectIterator entries = ((Long2ObjectMap)this.index).long2ObjectEntrySet().iterator();
                while (entries.hasNext()) {
                    Long2ObjectMap.Entry entry = (Long2ObjectMap.Entry)entries.next();
                    IntSortedSet rowNums = (IntSortedSet)entry.getValue();
                    if (rowNums.size() != 1) {
                        throw new ISE("Expected single element", new Object[0]);
                    }
                    indexAsArray[Ints.checkedCast((long)(entry.getLongKey() - this.minLongKey))] = rowNums.firstInt();
                    entries.remove();
                }
                assert (this.index.isEmpty());
                return new UniqueLongArrayIndex(indexAsArray, this.minLongKey);
            }
        }
        return new MapIndex(this.keyType, this.index, keysUnique);
    }
}

