/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.loading;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.File;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.druid.collections.bitmap.BitmapFactory;
import org.apache.druid.segment.DimensionHandler;
import org.apache.druid.segment.Metadata;
import org.apache.druid.segment.QueryableIndex;
import org.apache.druid.segment.QueryableIndexStorageAdapter;
import org.apache.druid.segment.Segment;
import org.apache.druid.segment.SegmentLazyLoadFailCallback;
import org.apache.druid.segment.StorageAdapter;
import org.apache.druid.segment.column.ColumnHolder;
import org.apache.druid.segment.data.Indexed;
import org.apache.druid.segment.loading.SegmentizerFactory;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.SegmentId;
import org.joda.time.Interval;

public class TombstoneSegmentizerFactory
implements SegmentizerFactory {
    @Override
    public Segment factorize(DataSegment segment, File parentDir, boolean lazy, SegmentLazyLoadFailCallback loadFailed) {
        return TombstoneSegmentizerFactory.segmentForTombstone(segment);
    }

    @VisibleForTesting
    public static Segment segmentForTombstone(final DataSegment tombstone) {
        Preconditions.checkArgument((boolean)tombstone.isTombstone());
        final QueryableIndex queryableIndex = new QueryableIndex(){

            @Override
            public Interval getDataInterval() {
                return tombstone.getInterval();
            }

            @Override
            public int getNumRows() {
                throw new UnsupportedOperationException();
            }

            @Override
            public Indexed<String> getAvailableDimensions() {
                throw new UnsupportedOperationException();
            }

            @Override
            public BitmapFactory getBitmapFactoryForDimensions() {
                throw new UnsupportedOperationException();
            }

            @Override
            @Nullable
            public Metadata getMetadata() {
                throw new UnsupportedOperationException();
            }

            @Override
            public Map<String, DimensionHandler> getDimensionHandlers() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void close() {
            }

            @Override
            public List<String> getColumnNames() {
                throw new UnsupportedOperationException();
            }

            @Override
            @Nullable
            public ColumnHolder getColumnHolder(String columnName) {
                throw new UnsupportedOperationException();
            }
        };
        final QueryableIndexStorageAdapter storageAdapter = new QueryableIndexStorageAdapter(queryableIndex){

            @Override
            public boolean isFromTombstone() {
                return true;
            }
        };
        Segment segmentObject = new Segment(){

            @Override
            public SegmentId getId() {
                return tombstone.getId();
            }

            @Override
            public Interval getDataInterval() {
                return this.asQueryableIndex().getDataInterval();
            }

            @Override
            @Nullable
            public QueryableIndex asQueryableIndex() {
                return queryableIndex;
            }

            @Override
            public StorageAdapter asStorageAdapter() {
                return storageAdapter;
            }

            @Override
            public void close() {
            }
        };
        return segmentObject;
    }
}

