/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.nested;

import com.google.common.base.Preconditions;
import it.unimi.dsi.fastutil.doubles.Double2IntLinkedOpenHashMap;
import it.unimi.dsi.fastutil.doubles.Double2IntMap;
import it.unimi.dsi.fastutil.longs.Long2IntLinkedOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntAVLTreeMap;
import it.unimi.dsi.fastutil.objects.Object2IntLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import javax.annotation.Nullable;
import org.apache.druid.segment.data.FrontCodedIntArrayIndexedWriter;

public class DictionaryIdLookup {
    private final Object2IntMap<String> stringLookup = new Object2IntLinkedOpenHashMap();
    private final Long2IntMap longLookup;
    private final Double2IntMap doubleLookup;
    private final Object2IntMap<int[]> arrayLookup;
    private int dictionarySize;

    public DictionaryIdLookup() {
        this.stringLookup.defaultReturnValue(-1);
        this.longLookup = new Long2IntLinkedOpenHashMap();
        this.longLookup.defaultReturnValue(-1);
        this.doubleLookup = new Double2IntLinkedOpenHashMap();
        this.doubleLookup.defaultReturnValue(-1);
        this.arrayLookup = new Object2IntAVLTreeMap(FrontCodedIntArrayIndexedWriter.ARRAY_COMPARATOR);
        this.arrayLookup.defaultReturnValue(-1);
    }

    public void addString(@Nullable String value) {
        Preconditions.checkState((this.longLookup.size() == 0 && this.doubleLookup.size() == 0 ? 1 : 0) != 0, (Object)"All string values must be inserted to the lookup before long and double types");
        int id = this.dictionarySize++;
        this.stringLookup.put((Object)value, id);
    }

    public void addNumericNull() {
        Preconditions.checkState((this.stringLookup.size() == 0 && this.longLookup.size() == 0 && this.doubleLookup.size() == 0 ? 1 : 0) != 0, (Object)"Lookup must be empty to add implicit null");
        ++this.dictionarySize;
    }

    public int lookupString(@Nullable String value) {
        return this.stringLookup.getInt((Object)value);
    }

    public void addLong(long value) {
        Preconditions.checkState((this.doubleLookup.size() == 0 ? 1 : 0) != 0, (Object)"All long values must be inserted to the lookup before double types");
        int id = this.dictionarySize++;
        this.longLookup.put(value, id);
    }

    public int lookupLong(@Nullable Long value) {
        if (value == null) {
            return 0;
        }
        return this.longLookup.get(value.longValue());
    }

    public void addDouble(double value) {
        int id = this.dictionarySize++;
        this.doubleLookup.put(value, id);
    }

    public int lookupDouble(@Nullable Double value) {
        if (value == null) {
            return 0;
        }
        return this.doubleLookup.get(value.doubleValue());
    }

    public void addArray(int[] value) {
        int id = this.dictionarySize++;
        this.arrayLookup.put((Object)value, id);
    }

    public int lookupArray(@Nullable int[] value) {
        if (value == null) {
            return 0;
        }
        return this.arrayLookup.getInt((Object)value);
    }
}

