/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.nested;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import javax.annotation.Nullable;
import org.apache.druid.collections.bitmap.ImmutableBitmap;
import org.apache.druid.collections.bitmap.MutableBitmap;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.RE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.java.util.common.io.smoosh.FileSmoosher;
import org.apache.druid.java.util.common.io.smoosh.SmooshedWriter;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.GenericColumnSerializer;
import org.apache.druid.segment.IndexMerger;
import org.apache.druid.segment.IndexSpec;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.StringEncodingStrategies;
import org.apache.druid.segment.column.Types;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.data.ByteBufferWriter;
import org.apache.druid.segment.data.CompressedVariableSizedBlobColumnSerializer;
import org.apache.druid.segment.data.CompressionStrategy;
import org.apache.druid.segment.data.DictionaryWriter;
import org.apache.druid.segment.data.FixedIndexedWriter;
import org.apache.druid.segment.data.GenericIndexed;
import org.apache.druid.segment.data.GenericIndexedWriter;
import org.apache.druid.segment.nested.DictionaryIdLookup;
import org.apache.druid.segment.nested.FieldTypeInfo;
import org.apache.druid.segment.nested.GlobalDictionaryEncodedFieldColumnWriter;
import org.apache.druid.segment.nested.NestedDataColumnMetadata;
import org.apache.druid.segment.nested.NestedDataComplexTypeSerde;
import org.apache.druid.segment.nested.NestedPathFinder;
import org.apache.druid.segment.nested.NestedPathPart;
import org.apache.druid.segment.nested.ScalarDoubleFieldColumnWriter;
import org.apache.druid.segment.nested.ScalarLongFieldColumnWriter;
import org.apache.druid.segment.nested.ScalarStringFieldColumnWriter;
import org.apache.druid.segment.nested.StructuredData;
import org.apache.druid.segment.nested.StructuredDataProcessor;
import org.apache.druid.segment.nested.VariantFieldColumnWriter;
import org.apache.druid.segment.serde.Serializer;
import org.apache.druid.segment.writeout.SegmentWriteOutMedium;

public class NestedDataColumnSerializerV4
implements GenericColumnSerializer<StructuredData> {
    private static final Logger log = new Logger(NestedDataColumnSerializerV4.class);
    public static final String STRING_DICTIONARY_FILE_NAME = "__stringDictionary";
    public static final String LONG_DICTIONARY_FILE_NAME = "__longDictionary";
    public static final String DOUBLE_DICTIONARY_FILE_NAME = "__doubleDictionary";
    public static final String ARRAY_DICTIONARY_FILE_NAME = "__arrayDictionary";
    public static final String RAW_FILE_NAME = "__raw";
    public static final String NULL_BITMAP_FILE_NAME = "__nullIndex";
    public static final String NESTED_FIELD_PREFIX = "__field_";
    private final String name;
    private final SegmentWriteOutMedium segmentWriteOutMedium;
    private final IndexSpec indexSpec;
    private final Closer closer;
    private final StructuredDataProcessor fieldProcessor = new StructuredDataProcessor(){

        @Override
        public StructuredDataProcessor.ProcessedValue<?> processField(ArrayList<NestedPathPart> fieldPath, @Nullable Object fieldValue) {
            GlobalDictionaryEncodedFieldColumnWriter writer = (GlobalDictionaryEncodedFieldColumnWriter)NestedDataColumnSerializerV4.this.fieldWriters.get(NestedPathFinder.toNormalizedJsonPath(fieldPath));
            if (writer != null) {
                try {
                    ExprEval eval = ExprEval.bestEffortOf(fieldValue);
                    if (eval.type().isPrimitive() || eval.type().isPrimitiveArray()) {
                        writer.addValue(NestedDataColumnSerializerV4.this.rowCount, eval.value());
                    } else {
                        writer.addValue(NestedDataColumnSerializerV4.this.rowCount, eval.asString());
                    }
                    return StructuredDataProcessor.ProcessedValue.NULL_LITERAL;
                }
                catch (IOException e) {
                    throw new RE(e, "Failed to write field [%s], unhandled value", fieldPath);
                }
            }
            return StructuredDataProcessor.ProcessedValue.NULL_LITERAL;
        }

        @Override
        @Nullable
        public StructuredDataProcessor.ProcessedValue<?> processArrayField(ArrayList<NestedPathPart> fieldPath, @Nullable List<?> array) {
            return null;
        }
    };
    private byte[] metadataBytes;
    private DictionaryIdLookup globalDictionaryIdLookup;
    private SortedMap<String, FieldTypeInfo.MutableTypeSet> fields;
    private GenericIndexedWriter<String> fieldsWriter;
    private FieldTypeInfo.Writer fieldsInfoWriter;
    private DictionaryWriter<String> dictionaryWriter;
    private FixedIndexedWriter<Long> longDictionaryWriter;
    private FixedIndexedWriter<Double> doubleDictionaryWriter;
    private CompressedVariableSizedBlobColumnSerializer rawWriter;
    private ByteBufferWriter<ImmutableBitmap> nullBitmapWriter;
    private MutableBitmap nullRowsBitmap;
    private Map<String, GlobalDictionaryEncodedFieldColumnWriter<?>> fieldWriters;
    private int rowCount = 0;
    private boolean closedForWrite = false;
    private boolean dictionarySerialized = false;

    public NestedDataColumnSerializerV4(String name, IndexSpec indexSpec, SegmentWriteOutMedium segmentWriteOutMedium, Closer closer) {
        this.name = name;
        this.segmentWriteOutMedium = segmentWriteOutMedium;
        this.indexSpec = indexSpec;
        this.closer = closer;
        this.globalDictionaryIdLookup = new DictionaryIdLookup();
    }

    @Override
    public void open() throws IOException {
        this.fieldsWriter = new GenericIndexedWriter<String>(this.segmentWriteOutMedium, this.name, GenericIndexed.STRING_STRATEGY);
        this.fieldsWriter.open();
        this.fieldsInfoWriter = new FieldTypeInfo.Writer(this.segmentWriteOutMedium);
        this.fieldsInfoWriter.open();
        this.dictionaryWriter = StringEncodingStrategies.getStringDictionaryWriter(this.indexSpec.getStringDictionaryEncoding(), this.segmentWriteOutMedium, this.name);
        this.dictionaryWriter.open();
        this.longDictionaryWriter = new FixedIndexedWriter(this.segmentWriteOutMedium, ColumnType.LONG.getStrategy(), ByteOrder.nativeOrder(), 8, true);
        this.longDictionaryWriter.open();
        this.doubleDictionaryWriter = new FixedIndexedWriter(this.segmentWriteOutMedium, ColumnType.DOUBLE.getStrategy(), ByteOrder.nativeOrder(), 8, true);
        this.doubleDictionaryWriter.open();
        this.rawWriter = new CompressedVariableSizedBlobColumnSerializer(NestedDataColumnSerializerV4.getInternalFileName(this.name, RAW_FILE_NAME), this.segmentWriteOutMedium, this.indexSpec.getJsonCompression() != null ? this.indexSpec.getJsonCompression() : CompressionStrategy.LZ4);
        this.rawWriter.open();
        this.nullBitmapWriter = new ByteBufferWriter<ImmutableBitmap>(this.segmentWriteOutMedium, this.indexSpec.getBitmapSerdeFactory().getObjectStrategy());
        this.nullBitmapWriter.open();
        this.nullRowsBitmap = this.indexSpec.getBitmapSerdeFactory().getBitmapFactory().makeEmptyMutableBitmap();
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void serializeFields(SortedMap<String, FieldTypeInfo.MutableTypeSet> fields) throws IOException {
        this.fields = fields;
        this.fieldWriters = Maps.newHashMapWithExpectedSize((int)fields.size());
        int ctr = 0;
        for (Map.Entry<String, FieldTypeInfo.MutableTypeSet> field : fields.entrySet()) {
            void var7_7;
            String fieldName = field.getKey();
            String fieldFileName = NESTED_FIELD_PREFIX + ctr++;
            this.fieldsWriter.write(fieldName);
            this.fieldsInfoWriter.write(field.getValue());
            ColumnType type = field.getValue().getSingleType();
            if (type != null) {
                if (Types.is(type, ValueType.STRING)) {
                    ScalarStringFieldColumnWriter scalarStringFieldColumnWriter = new ScalarStringFieldColumnWriter(this.name, fieldFileName, this.segmentWriteOutMedium, this.indexSpec, this.globalDictionaryIdLookup);
                } else if (Types.is(type, ValueType.LONG)) {
                    ScalarLongFieldColumnWriter scalarLongFieldColumnWriter = new ScalarLongFieldColumnWriter(this.name, fieldFileName, this.segmentWriteOutMedium, this.indexSpec, this.globalDictionaryIdLookup);
                } else {
                    if (!Types.is(type, ValueType.DOUBLE)) throw new ISE("Invalid field type [%s], how did this happen?", type);
                    ScalarDoubleFieldColumnWriter scalarDoubleFieldColumnWriter = new ScalarDoubleFieldColumnWriter(this.name, fieldFileName, this.segmentWriteOutMedium, this.indexSpec, this.globalDictionaryIdLookup);
                }
            } else {
                VariantFieldColumnWriter variantFieldColumnWriter = new VariantFieldColumnWriter(this.name, fieldFileName, this.segmentWriteOutMedium, this.indexSpec, this.globalDictionaryIdLookup);
            }
            var7_7.open();
            this.fieldWriters.put(fieldName, (GlobalDictionaryEncodedFieldColumnWriter<?>)var7_7);
        }
    }

    public void serializeDictionaries(Iterable<String> strings, Iterable<Long> longs, Iterable<Double> doubles) throws IOException {
        if (this.dictionarySerialized) {
            throw new ISE("String dictionary already serialized for column [%s], cannot serialize again", this.name);
        }
        this.dictionaryWriter.write(null);
        this.globalDictionaryIdLookup.addString(null);
        for (String string : strings) {
            String string2 = NullHandling.emptyToNullIfNeeded(string);
            if (string2 == null) continue;
            this.dictionaryWriter.write(string2);
            this.globalDictionaryIdLookup.addString(string2);
        }
        this.dictionarySerialized = true;
        for (Long l : longs) {
            if (l == null) continue;
            this.longDictionaryWriter.write(l);
            this.globalDictionaryIdLookup.addLong(l);
        }
        for (Double d : doubles) {
            if (d == null) continue;
            this.doubleDictionaryWriter.write(d);
            this.globalDictionaryIdLookup.addDouble(d);
        }
        this.dictionarySerialized = true;
    }

    @Override
    public void serialize(ColumnValueSelector<? extends StructuredData> selector) throws IOException {
        StructuredData data = StructuredData.wrap(selector.getObject());
        if (data == null) {
            this.nullRowsBitmap.add(this.rowCount);
        }
        this.rawWriter.addValue(NestedDataComplexTypeSerde.INSTANCE.toBytes(data));
        if (data != null) {
            this.fieldProcessor.processFields(data.getValue());
        }
        ++this.rowCount;
    }

    @Override
    public long getSerializedSize() throws IOException {
        if (!this.closedForWrite) {
            this.closedForWrite = true;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            IndexMerger.SERIALIZER_UTILS.writeString(baos, NestedDataComplexTypeSerde.OBJECT_MAPPER.writeValueAsString((Object)new NestedDataColumnMetadata(ByteOrder.nativeOrder(), this.indexSpec.getBitmapSerdeFactory(), this.name, !this.nullRowsBitmap.isEmpty())));
            this.metadataBytes = baos.toByteArray();
            this.nullBitmapWriter.write(this.nullRowsBitmap);
        }
        long size = 1L;
        size += (long)this.metadataBytes.length;
        if (this.fieldsWriter != null) {
            size += this.fieldsWriter.getSerializedSize();
        }
        if (this.fieldsInfoWriter != null) {
            size += this.fieldsInfoWriter.getSerializedSize();
        }
        return size;
    }

    @Override
    public void writeTo(WritableByteChannel channel, FileSmoosher smoosher) throws IOException {
        Preconditions.checkState((boolean)this.closedForWrite, (Object)"Not closed yet!");
        Preconditions.checkArgument((boolean)this.dictionaryWriter.isSorted(), (Object)"Dictionary not sorted?!?");
        channel.write(ByteBuffer.wrap(new byte[]{4}));
        channel.write(ByteBuffer.wrap(this.metadataBytes));
        this.fieldsWriter.writeTo(channel, smoosher);
        this.fieldsInfoWriter.writeTo(channel, smoosher);
        this.writeInternal(smoosher, this.dictionaryWriter, STRING_DICTIONARY_FILE_NAME);
        this.writeInternal(smoosher, this.longDictionaryWriter, LONG_DICTIONARY_FILE_NAME);
        this.writeInternal(smoosher, this.doubleDictionaryWriter, DOUBLE_DICTIONARY_FILE_NAME);
        this.writeInternal(smoosher, this.rawWriter, RAW_FILE_NAME);
        if (!this.nullRowsBitmap.isEmpty()) {
            this.writeInternal(smoosher, this.nullBitmapWriter, NULL_BITMAP_FILE_NAME);
        }
        if (channel instanceof SmooshedWriter) {
            channel.close();
        }
        for (Map.Entry<String, FieldTypeInfo.MutableTypeSet> field : this.fields.entrySet()) {
            GlobalDictionaryEncodedFieldColumnWriter<?> writer = this.fieldWriters.remove(field.getKey());
            writer.writeTo(this.rowCount, smoosher);
        }
        log.info("Column [%s] serialized successfully with [%d] nested columns.", this.name, this.fields.size());
    }

    private void writeInternal(FileSmoosher smoosher, Serializer serializer, String fileName) throws IOException {
        String internalName = NestedDataColumnSerializerV4.getInternalFileName(this.name, fileName);
        try (SmooshedWriter smooshChannel = smoosher.addWithSmooshedWriter(internalName, serializer.getSerializedSize());){
            serializer.writeTo(smooshChannel, smoosher);
        }
    }

    public static String getInternalFileName(String fileNameBase, String field) {
        return StringUtils.format("%s.%s", fileNameBase, field);
    }
}

