/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.nested;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Supplier;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import javax.annotation.Nullable;
import org.apache.druid.collections.bitmap.ImmutableBitmap;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.RE;
import org.apache.druid.java.util.common.io.smoosh.SmooshedFileMapper;
import org.apache.druid.segment.IndexMerger;
import org.apache.druid.segment.column.ColumnBuilder;
import org.apache.druid.segment.column.ColumnConfig;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.ComplexColumn;
import org.apache.druid.segment.column.TypeStrategy;
import org.apache.druid.segment.data.BitmapSerdeFactory;
import org.apache.druid.segment.data.CompressedVariableSizedBlobColumnSupplier;
import org.apache.druid.segment.data.FixedIndexed;
import org.apache.druid.segment.data.FrontCodedIndexed;
import org.apache.druid.segment.data.FrontCodedIntArrayIndexed;
import org.apache.druid.segment.data.GenericIndexed;
import org.apache.druid.segment.nested.FieldTypeInfo;
import org.apache.druid.segment.nested.NestedDataColumnMetadata;
import org.apache.druid.segment.nested.NestedDataColumnSerializerV4;
import org.apache.druid.segment.nested.NestedDataColumnV3;
import org.apache.druid.segment.nested.NestedDataColumnV4;
import org.apache.druid.segment.nested.NestedDataColumnV5;

public class NestedDataColumnSupplierV4
implements Supplier<ComplexColumn> {
    private final byte version;
    private final String columnName;
    private final ColumnConfig columnConfig;
    private final GenericIndexed<String> fields;
    private final FieldTypeInfo fieldInfo;
    private final CompressedVariableSizedBlobColumnSupplier compressedRawColumnSupplier;
    private final ImmutableBitmap nullValues;
    private final GenericIndexed<ByteBuffer> stringDictionary;
    private final Supplier<FrontCodedIndexed> frontCodedStringDictionarySupplier;
    private final Supplier<FixedIndexed<Long>> longDictionarySupplier;
    private final Supplier<FixedIndexed<Double>> doubleDictionarySupplier;
    private final Supplier<FrontCodedIntArrayIndexed> arrayDictionarySupplier;
    private final SmooshedFileMapper fileMapper;
    @Nullable
    private final ColumnType simpleType;
    private final ColumnType logicalType;
    private final BitmapSerdeFactory bitmapSerdeFactory;
    private final ByteOrder byteOrder;

    public static NestedDataColumnSupplierV4 read(ByteBuffer bb, ColumnBuilder columnBuilder, ColumnConfig columnConfig, ObjectMapper jsonMapper) {
        return NestedDataColumnSupplierV4.read(bb, columnBuilder, columnConfig, jsonMapper, ColumnType.LONG.getStrategy(), ColumnType.DOUBLE.getStrategy());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static NestedDataColumnSupplierV4 read(ByteBuffer bb, ColumnBuilder columnBuilder, ColumnConfig columnConfig, ObjectMapper jsonMapper, TypeStrategy<Long> longTypeStrategy, TypeStrategy<Double> doubleTypeStrategy) {
        byte version = bb.get();
        if (version != 3 && version != 4 && version != 5) throw new RE("Unknown version " + version, new Object[0]);
        try {
            ImmutableBitmap nullValues;
            Supplier<FrontCodedIntArrayIndexed> arrayDictionarySupplier;
            GenericIndexed<ByteBuffer> stringDictionary;
            Supplier<FrontCodedIndexed> frontCodedStringDictionarySupplier;
            SmooshedFileMapper mapper = columnBuilder.getFileMapper();
            NestedDataColumnMetadata metadata = (NestedDataColumnMetadata)jsonMapper.readValue(IndexMerger.SERIALIZER_UTILS.readString(bb), NestedDataColumnMetadata.class);
            GenericIndexed<String> fields = GenericIndexed.read(bb, GenericIndexed.STRING_STRATEGY, mapper);
            FieldTypeInfo fieldInfo = FieldTypeInfo.read(bb, fields.size());
            ColumnType simpleType = fields.size() == 0 ? ColumnType.STRING : (fields.size() == 1 && (version == 3 && ".".equals(fields.get(0)) || (version == 4 || version == 5) && "$".equals(fields.get(0))) ? fieldInfo.getTypes(0).getSingleType() : null);
            ByteBuffer stringDictionaryBuffer = NestedDataColumnSupplierV4.loadInternalFile(mapper, metadata, "__stringDictionary");
            int dictionaryStartPosition = stringDictionaryBuffer.position();
            byte dictionaryVersion = stringDictionaryBuffer.get();
            if (dictionaryVersion == 127) {
                byte encodingId = stringDictionaryBuffer.get();
                if (encodingId == 1) {
                    frontCodedStringDictionarySupplier = FrontCodedIndexed.read(stringDictionaryBuffer, metadata.getByteOrder());
                    stringDictionary = null;
                } else {
                    if (encodingId != 0) throw new ISE("impossible, unknown encoding strategy id: %s", encodingId);
                    stringDictionary = GenericIndexed.read(stringDictionaryBuffer, GenericIndexed.UTF8_STRATEGY, mapper);
                    frontCodedStringDictionarySupplier = null;
                }
            } else {
                stringDictionaryBuffer.position(dictionaryStartPosition);
                stringDictionary = GenericIndexed.read(stringDictionaryBuffer, GenericIndexed.UTF8_STRATEGY, mapper);
                frontCodedStringDictionarySupplier = null;
            }
            ByteBuffer longDictionaryBuffer = NestedDataColumnSupplierV4.loadInternalFile(mapper, metadata, "__longDictionary");
            Supplier<FixedIndexed<Long>> longDictionarySupplier = FixedIndexed.read(longDictionaryBuffer, longTypeStrategy, metadata.getByteOrder(), 8);
            ByteBuffer doubleDictionaryBuffer = NestedDataColumnSupplierV4.loadInternalFile(mapper, metadata, "__doubleDictionary");
            Supplier<FixedIndexed<Double>> doubleDictionarySupplier = FixedIndexed.read(doubleDictionaryBuffer, doubleTypeStrategy, metadata.getByteOrder(), 8);
            if (version == 5) {
                ByteBuffer arrayDictionarybuffer = NestedDataColumnSupplierV4.loadInternalFile(mapper, metadata, "__arrayDictionary");
                arrayDictionarySupplier = FrontCodedIntArrayIndexed.read(arrayDictionarybuffer, metadata.getByteOrder());
            } else {
                arrayDictionarySupplier = null;
            }
            ByteBuffer rawBuffer = NestedDataColumnSupplierV4.loadInternalFile(mapper, metadata, "__raw");
            CompressedVariableSizedBlobColumnSupplier compressedRawColumnSupplier = CompressedVariableSizedBlobColumnSupplier.fromByteBuffer(NestedDataColumnSerializerV4.getInternalFileName(metadata.getFileNameBase(), "__raw"), rawBuffer, metadata.getByteOrder(), mapper);
            if (metadata.hasNulls().booleanValue()) {
                columnBuilder.setHasNulls(true);
                ByteBuffer nullIndexBuffer = NestedDataColumnSupplierV4.loadInternalFile(mapper, metadata, "__nullIndex");
                nullValues = metadata.getBitmapSerdeFactory().getObjectStrategy().fromByteBufferWithSize(nullIndexBuffer);
                return new NestedDataColumnSupplierV4(version, metadata.getFileNameBase(), columnConfig, fields, fieldInfo, compressedRawColumnSupplier, nullValues, stringDictionary, frontCodedStringDictionarySupplier, longDictionarySupplier, doubleDictionarySupplier, arrayDictionarySupplier, mapper, metadata.getBitmapSerdeFactory(), metadata.getByteOrder(), simpleType);
            } else {
                nullValues = metadata.getBitmapSerdeFactory().getBitmapFactory().makeEmptyImmutableBitmap();
            }
            return new NestedDataColumnSupplierV4(version, metadata.getFileNameBase(), columnConfig, fields, fieldInfo, compressedRawColumnSupplier, nullValues, stringDictionary, frontCodedStringDictionarySupplier, longDictionarySupplier, doubleDictionarySupplier, arrayDictionarySupplier, mapper, metadata.getBitmapSerdeFactory(), metadata.getByteOrder(), simpleType);
        }
        catch (IOException ex) {
            throw new RE(ex, "Failed to deserialize V%s column.", version);
        }
    }

    private NestedDataColumnSupplierV4(byte version, String columnName, ColumnConfig columnConfig, GenericIndexed<String> fields, FieldTypeInfo fieldInfo, CompressedVariableSizedBlobColumnSupplier compressedRawColumnSupplier, ImmutableBitmap nullValues, GenericIndexed<ByteBuffer> stringDictionary, Supplier<FrontCodedIndexed> frontCodedStringDictionarySupplier, Supplier<FixedIndexed<Long>> longDictionarySupplier, Supplier<FixedIndexed<Double>> doubleDictionarySupplier, Supplier<FrontCodedIntArrayIndexed> arrayDictionarySupplier, SmooshedFileMapper fileMapper, BitmapSerdeFactory bitmapSerdeFactory, ByteOrder byteOrder, @Nullable ColumnType simpleType) {
        this.version = version;
        this.columnName = columnName;
        this.columnConfig = columnConfig;
        this.fields = fields;
        this.fieldInfo = fieldInfo;
        this.compressedRawColumnSupplier = compressedRawColumnSupplier;
        this.nullValues = nullValues;
        this.stringDictionary = stringDictionary;
        this.frontCodedStringDictionarySupplier = frontCodedStringDictionarySupplier;
        this.longDictionarySupplier = longDictionarySupplier;
        this.doubleDictionarySupplier = doubleDictionarySupplier;
        this.arrayDictionarySupplier = arrayDictionarySupplier;
        this.fileMapper = fileMapper;
        this.bitmapSerdeFactory = bitmapSerdeFactory;
        this.byteOrder = byteOrder;
        this.simpleType = simpleType;
        this.logicalType = simpleType == null ? ColumnType.NESTED_DATA : simpleType;
    }

    public ComplexColumn get() {
        if (this.version == 3) {
            return this.makeV3();
        }
        if (this.version == 4) {
            return this.makeV4();
        }
        return this.makeV5();
    }

    @Nullable
    public ColumnType getSimpleType() {
        return this.simpleType;
    }

    private NestedDataColumnV3 makeV3() {
        if (this.frontCodedStringDictionarySupplier != null) {
            return new NestedDataColumnV3<FrontCodedIndexed>(this.columnName, this.logicalType, this.columnConfig, this.compressedRawColumnSupplier, this.nullValues, this.fields, this.fieldInfo, this.frontCodedStringDictionarySupplier, this.longDictionarySupplier, this.doubleDictionarySupplier, this.fileMapper, this.bitmapSerdeFactory, this.byteOrder);
        }
        return new NestedDataColumnV3(this.columnName, this.logicalType, this.columnConfig, this.compressedRawColumnSupplier, this.nullValues, this.fields, this.fieldInfo, this.stringDictionary::singleThreaded, this.longDictionarySupplier, this.doubleDictionarySupplier, this.fileMapper, this.bitmapSerdeFactory, this.byteOrder);
    }

    private NestedDataColumnV4 makeV4() {
        if (this.frontCodedStringDictionarySupplier != null) {
            return new NestedDataColumnV4<FrontCodedIndexed>(this.columnName, this.logicalType, this.columnConfig, this.compressedRawColumnSupplier, this.nullValues, this.fields, this.fieldInfo, this.frontCodedStringDictionarySupplier, this.longDictionarySupplier, this.doubleDictionarySupplier, this.fileMapper, this.bitmapSerdeFactory, this.byteOrder);
        }
        return new NestedDataColumnV4(this.columnName, this.logicalType, this.columnConfig, this.compressedRawColumnSupplier, this.nullValues, this.fields, this.fieldInfo, this.stringDictionary::singleThreaded, this.longDictionarySupplier, this.doubleDictionarySupplier, this.fileMapper, this.bitmapSerdeFactory, this.byteOrder);
    }

    private NestedDataColumnV5 makeV5() {
        if (this.frontCodedStringDictionarySupplier != null) {
            return new NestedDataColumnV5<FrontCodedIndexed>(this.columnName, this.logicalType, this.columnConfig, this.compressedRawColumnSupplier, this.nullValues, this.fields, this.fieldInfo, this.frontCodedStringDictionarySupplier, this.longDictionarySupplier, this.doubleDictionarySupplier, this.arrayDictionarySupplier, this.fileMapper, this.bitmapSerdeFactory, this.byteOrder);
        }
        return new NestedDataColumnV5(this.columnName, this.logicalType, this.columnConfig, this.compressedRawColumnSupplier, this.nullValues, this.fields, this.fieldInfo, this.stringDictionary::singleThreaded, this.longDictionarySupplier, this.doubleDictionarySupplier, this.arrayDictionarySupplier, this.fileMapper, this.bitmapSerdeFactory, this.byteOrder);
    }

    private static ByteBuffer loadInternalFile(SmooshedFileMapper fileMapper, NestedDataColumnMetadata metadata, String internalFileName) throws IOException {
        return fileMapper.mapFile(NestedDataColumnSerializerV4.getInternalFileName(metadata.getFileNameBase(), internalFileName));
    }
}

