/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.nested;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.smile.SmileFactory;
import com.fasterxml.jackson.dataformat.smile.SmileGenerator;
import java.io.IOException;
import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.apache.druid.data.input.impl.DimensionSchema;
import org.apache.druid.guice.NestedDataModule;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.guava.Comparators;
import org.apache.druid.segment.DimensionHandler;
import org.apache.druid.segment.NestedDataDimensionHandler;
import org.apache.druid.segment.NestedDataDimensionSchema;
import org.apache.druid.segment.column.ColumnBuilder;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnCapabilitiesImpl;
import org.apache.druid.segment.column.ColumnConfig;
import org.apache.druid.segment.column.ColumnFormat;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.data.ObjectStrategy;
import org.apache.druid.segment.nested.NestedDataColumnSupplierV4;
import org.apache.druid.segment.nested.StructuredData;
import org.apache.druid.segment.serde.ComplexMetricExtractor;
import org.apache.druid.segment.serde.ComplexMetricSerde;

public class NestedDataComplexTypeSerde
extends ComplexMetricSerde {
    public static final String TYPE_NAME = "json";
    public static final ObjectMapper OBJECT_MAPPER;
    public static final NestedDataComplexTypeSerde INSTANCE;

    @Override
    public String getTypeName() {
        return TYPE_NAME;
    }

    @Override
    public ComplexMetricExtractor getExtractor() {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public void deserializeColumn(ByteBuffer buffer, ColumnBuilder builder) {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public void deserializeColumn(ByteBuffer buffer, ColumnBuilder builder, ColumnConfig columnConfig) {
        NestedDataColumnSupplierV4 supplier = NestedDataColumnSupplierV4.read(buffer, builder, columnConfig, OBJECT_MAPPER);
        ColumnCapabilitiesImpl capabilitiesBuilder = builder.getCapabilitiesBuilder();
        capabilitiesBuilder.setDictionaryEncoded(true);
        capabilitiesBuilder.setDictionaryValuesSorted(true);
        capabilitiesBuilder.setDictionaryValuesUnique(true);
        ColumnType simpleType = supplier.getSimpleType();
        if (simpleType != null) {
            builder.setType(simpleType);
        } else {
            builder.setComplexTypeName(TYPE_NAME);
        }
        builder.setComplexColumnSupplier(supplier);
        builder.setColumnFormat(new NestedColumnFormatV4());
    }

    @Override
    public ObjectStrategy getObjectStrategy() {
        return new ObjectStrategy<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                return Comparators.naturalNullsFirst().compare((Object)StructuredData.wrap(o1), (Object)StructuredData.wrap(o2));
            }

            @Override
            public Class<? extends Object> getClazz() {
                return StructuredData.class;
            }

            @Override
            @Nullable
            public Object fromByteBuffer(ByteBuffer buffer, int numBytes) {
                byte[] bytes = new byte[numBytes];
                buffer.get(bytes, 0, numBytes);
                try {
                    return OBJECT_MAPPER.readValue(bytes, StructuredData.class);
                }
                catch (IOException e) {
                    throw new ISE(e, "Unable to deserialize value", new Object[0]);
                }
            }

            @Override
            @Nullable
            public byte[] toBytes(@Nullable Object val) {
                if (val == null) {
                    return new byte[0];
                }
                try {
                    return OBJECT_MAPPER.writeValueAsBytes(val);
                }
                catch (JsonProcessingException e) {
                    throw new ISE(e, "Unable to serialize value [%s]", val);
                }
            }
        };
    }

    static {
        INSTANCE = new NestedDataComplexTypeSerde();
        SmileFactory smileFactory = new SmileFactory();
        smileFactory.configure(SmileGenerator.Feature.ENCODE_BINARY_AS_7BIT, false);
        smileFactory.delegateToTextual(true);
        DefaultObjectMapper mapper = new DefaultObjectMapper((JsonFactory)smileFactory, null);
        mapper.getFactory().setCodec((ObjectCodec)mapper);
        mapper.registerModules(NestedDataModule.getJacksonModulesList());
        OBJECT_MAPPER = mapper;
    }

    public static class NestedColumnFormatV4
    implements ColumnFormat {
        @Override
        public ColumnType getLogicalType() {
            return ColumnType.NESTED_DATA;
        }

        @Override
        public DimensionHandler getColumnHandler(String columnName) {
            return new NestedDataDimensionHandler(columnName);
        }

        @Override
        public DimensionSchema getColumnSchema(String columnName) {
            return new NestedDataDimensionSchema(columnName);
        }

        @Override
        public ColumnFormat merge(@Nullable ColumnFormat otherFormat) {
            return this;
        }

        @Override
        public ColumnCapabilities toColumnCapabilities() {
            return ColumnCapabilitiesImpl.createDefault().setType(ColumnType.NESTED_DATA).setHasNulls(true);
        }
    }
}

