/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.nested;

import java.io.IOException;
import java.nio.ByteOrder;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.java.util.common.io.smoosh.FileSmoosher;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.segment.IndexSpec;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.data.ColumnarLongsSerializer;
import org.apache.druid.segment.data.CompressionFactory;
import org.apache.druid.segment.data.FixedIndexedWriter;
import org.apache.druid.segment.nested.ScalarNestedCommonFormatColumnSerializer;
import org.apache.druid.segment.writeout.SegmentWriteOutMedium;

public class ScalarLongColumnSerializer
extends ScalarNestedCommonFormatColumnSerializer<Long> {
    private ColumnarLongsSerializer longsSerializer;

    public ScalarLongColumnSerializer(String name, IndexSpec indexSpec, SegmentWriteOutMedium segmentWriteOutMedium, Closer closer) {
        super(name, "__longDictionary", indexSpec, segmentWriteOutMedium, closer);
    }

    @Override
    protected int processValue(@Nullable Object rawValue) throws IOException {
        ExprEval eval = ExprEval.bestEffortOf(rawValue);
        long val = eval.asLong();
        int dictId = eval.isNumericNull() ? 0 : this.dictionaryIdLookup.lookupLong(val);
        this.longsSerializer.add(dictId == 0 ? 0L : val);
        return dictId;
    }

    @Override
    public void openDictionaryWriter() throws IOException {
        this.dictionaryWriter = new FixedIndexedWriter(this.segmentWriteOutMedium, ColumnType.LONG.getStrategy(), ByteOrder.nativeOrder(), 8, true);
        this.dictionaryWriter.open();
    }

    @Override
    protected void openValueColumnSerializer() throws IOException {
        this.longsSerializer = CompressionFactory.getLongSerializer(this.name, this.segmentWriteOutMedium, StringUtils.format("%s.long_column", this.name), ByteOrder.nativeOrder(), this.indexSpec.getLongEncoding(), this.indexSpec.getDimensionCompression());
        this.longsSerializer.open();
    }

    @Override
    public void serializeDictionaries(Iterable<String> strings, Iterable<Long> longs, Iterable<Double> doubles, Iterable<int[]> arrays) throws IOException {
        if (this.dictionarySerialized) {
            throw new ISE("Long dictionary already serialized for column [%s], cannot serialize again", this.name);
        }
        this.dictionaryWriter.write(null);
        this.dictionaryIdLookup.addNumericNull();
        for (Long value : longs) {
            if (value == null) continue;
            this.dictionaryWriter.write(value);
            this.dictionaryIdLookup.addLong(value);
        }
        this.dictionarySerialized = true;
    }

    @Override
    protected void writeValueColumn(FileSmoosher smoosher) throws IOException {
        this.writeInternal(smoosher, this.longsSerializer, "__longColumn");
    }
}

