/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.nested;

import com.google.common.base.Supplier;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import javax.annotation.Nullable;
import org.apache.druid.collections.bitmap.ImmutableBitmap;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.RE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.io.smoosh.SmooshedFileMapper;
import org.apache.druid.segment.column.ColumnBuilder;
import org.apache.druid.segment.column.ColumnConfig;
import org.apache.druid.segment.column.ColumnIndexSupplier;
import org.apache.druid.segment.column.StringUtf8DictionaryEncodedColumn;
import org.apache.druid.segment.data.BitmapSerdeFactory;
import org.apache.druid.segment.data.ColumnarInts;
import org.apache.druid.segment.data.CompressedVSizeColumnarIntsSupplier;
import org.apache.druid.segment.data.FrontCodedIndexed;
import org.apache.druid.segment.data.GenericIndexed;
import org.apache.druid.segment.data.Indexed;
import org.apache.druid.segment.data.VByte;
import org.apache.druid.segment.nested.NestedCommonFormatColumn;
import org.apache.druid.segment.serde.NestedCommonFormatColumnPartSerde;
import org.apache.druid.segment.serde.StringUtf8ColumnIndexSupplier;

public class ScalarStringColumnAndIndexSupplier
implements Supplier<NestedCommonFormatColumn>,
ColumnIndexSupplier {
    private final Supplier<? extends Indexed<ByteBuffer>> dictionarySupplier;
    private final Supplier<ColumnarInts> encodedColumnSupplier;
    private final GenericIndexed<ImmutableBitmap> valueIndexes;
    private final ColumnIndexSupplier stringIndexSupplier;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ScalarStringColumnAndIndexSupplier read(ByteOrder byteOrder, BitmapSerdeFactory bitmapSerdeFactory, ByteBuffer bb, ColumnBuilder columnBuilder, ColumnConfig columnConfig) {
        byte version = bb.get();
        int columnNameLength = VByte.readInt(bb);
        String columnName = StringUtils.fromUtf8(bb, columnNameLength);
        if (version != 0) throw new RE("Unknown version " + version, new Object[0]);
        try {
            Supplier dictionarySupplier;
            SmooshedFileMapper mapper = columnBuilder.getFileMapper();
            ByteBuffer stringDictionaryBuffer = NestedCommonFormatColumnPartSerde.loadInternalFile(mapper, columnName, "__stringDictionary");
            int dictionaryStartPosition = stringDictionaryBuffer.position();
            byte dictionaryVersion = stringDictionaryBuffer.get();
            if (dictionaryVersion == 127) {
                byte encodingId = stringDictionaryBuffer.get();
                if (encodingId == 1) {
                    dictionarySupplier = FrontCodedIndexed.read(stringDictionaryBuffer, byteOrder);
                } else {
                    if (encodingId != 0) throw new ISE("impossible, unknown encoding strategy id: %s", encodingId);
                    dictionarySupplier = GenericIndexed.read(stringDictionaryBuffer, GenericIndexed.UTF8_STRATEGY, mapper)::singleThreaded;
                }
            } else {
                stringDictionaryBuffer.position(dictionaryStartPosition);
                dictionarySupplier = GenericIndexed.read(stringDictionaryBuffer, GenericIndexed.UTF8_STRATEGY, mapper)::singleThreaded;
            }
            ByteBuffer encodedValueColumn = NestedCommonFormatColumnPartSerde.loadInternalFile(mapper, columnName, "__encodedColumn");
            CompressedVSizeColumnarIntsSupplier ints = CompressedVSizeColumnarIntsSupplier.fromByteBuffer(encodedValueColumn, byteOrder);
            ByteBuffer valueIndexBuffer = NestedCommonFormatColumnPartSerde.loadInternalFile(mapper, columnName, "__valueIndexes");
            GenericIndexed<ImmutableBitmap> valueIndexes = GenericIndexed.read(valueIndexBuffer, bitmapSerdeFactory.getObjectStrategy(), columnBuilder.getFileMapper());
            try (ColumnarInts throwAway = ints.get();){
                int size = throwAway.size();
                return new ScalarStringColumnAndIndexSupplier((Supplier<? extends Indexed<ByteBuffer>>)dictionarySupplier, ints, valueIndexes, bitmapSerdeFactory, columnConfig, size);
            }
        }
        catch (IOException ex) {
            throw new RE(ex, "Failed to deserialize V%s column.", version);
        }
    }

    private ScalarStringColumnAndIndexSupplier(Supplier<? extends Indexed<ByteBuffer>> dictionarySupplier, Supplier<ColumnarInts> encodedColumnSupplier, GenericIndexed<ImmutableBitmap> valueIndexes, BitmapSerdeFactory serdeFactory, ColumnConfig columnConfig, int numRows) {
        this.dictionarySupplier = dictionarySupplier;
        this.encodedColumnSupplier = encodedColumnSupplier;
        this.valueIndexes = valueIndexes;
        this.stringIndexSupplier = new StringUtf8ColumnIndexSupplier<Indexed<ByteBuffer>>(serdeFactory.getBitmapFactory(), dictionarySupplier, valueIndexes, null, columnConfig, numRows);
    }

    public NestedCommonFormatColumn get() {
        return new StringUtf8DictionaryEncodedColumn((ColumnarInts)this.encodedColumnSupplier.get(), null, (Indexed)this.dictionarySupplier.get());
    }

    @Override
    @Nullable
    public <T> T as(Class<T> clazz) {
        if (this.valueIndexes != null) {
            return this.stringIndexSupplier.as(clazz);
        }
        return null;
    }
}

