/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.serde;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.primitives.Ints;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.WritableByteChannel;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;
import org.apache.druid.collections.bitmap.ImmutableBitmap;
import org.apache.druid.collections.spatial.ImmutableRTree;
import org.apache.druid.io.Channels;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.io.smoosh.FileSmoosher;
import org.apache.druid.segment.column.ColumnBuilder;
import org.apache.druid.segment.column.ColumnConfig;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.data.BitmapSerde;
import org.apache.druid.segment.data.BitmapSerdeFactory;
import org.apache.druid.segment.data.ByteBufferWriter;
import org.apache.druid.segment.data.ColumnarInts;
import org.apache.druid.segment.data.ColumnarIntsSerializer;
import org.apache.druid.segment.data.ColumnarMultiInts;
import org.apache.druid.segment.data.CompressedVSizeColumnarIntsSupplier;
import org.apache.druid.segment.data.CompressedVSizeColumnarMultiIntsSupplier;
import org.apache.druid.segment.data.DictionaryWriter;
import org.apache.druid.segment.data.FrontCodedIndexed;
import org.apache.druid.segment.data.GenericIndexed;
import org.apache.druid.segment.data.GenericIndexedWriter;
import org.apache.druid.segment.data.ImmutableRTreeObjectStrategy;
import org.apache.druid.segment.data.Indexed;
import org.apache.druid.segment.data.V3CompressedVSizeColumnarMultiIntsSupplier;
import org.apache.druid.segment.data.VSizeColumnarInts;
import org.apache.druid.segment.data.VSizeColumnarMultiInts;
import org.apache.druid.segment.data.WritableSupplier;
import org.apache.druid.segment.serde.ColumnPartSerde;
import org.apache.druid.segment.serde.Serializer;
import org.apache.druid.segment.serde.StringUtf8ColumnIndexSupplier;
import org.apache.druid.segment.serde.StringUtf8DictionaryEncodedColumnSupplier;

public class DictionaryEncodedColumnPartSerde
implements ColumnPartSerde {
    public static final int NO_FLAGS = 0;
    public static final int STARTING_FLAGS = Feature.NO_BITMAP_INDEX.getMask();
    private final ByteOrder byteOrder;
    private final BitmapSerdeFactory bitmapSerdeFactory;
    private final Serializer serializer;

    @JsonCreator
    public static DictionaryEncodedColumnPartSerde createDeserializer(@JsonProperty(value="bitmapSerdeFactory") @Nullable BitmapSerdeFactory bitmapSerdeFactory, @NotNull @JsonProperty(value="byteOrder") ByteOrder byteOrder) {
        return new DictionaryEncodedColumnPartSerde(byteOrder, bitmapSerdeFactory != null ? bitmapSerdeFactory : new BitmapSerde.LegacyBitmapSerdeFactory(), null);
    }

    private DictionaryEncodedColumnPartSerde(ByteOrder byteOrder, BitmapSerdeFactory bitmapSerdeFactory, @Nullable Serializer serializer) {
        this.byteOrder = byteOrder;
        this.bitmapSerdeFactory = bitmapSerdeFactory;
        this.serializer = serializer;
    }

    @JsonProperty
    public BitmapSerdeFactory getBitmapSerdeFactory() {
        return this.bitmapSerdeFactory;
    }

    @JsonProperty
    public ByteOrder getByteOrder() {
        return this.byteOrder;
    }

    public static SerializerBuilder serializerBuilder() {
        return new SerializerBuilder();
    }

    @Override
    public Serializer getSerializer() {
        return this.serializer;
    }

    @Override
    public ColumnPartSerde.Deserializer getDeserializer() {
        return new ColumnPartSerde.Deserializer(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void read(ByteBuffer buffer, ColumnBuilder builder, ColumnConfig columnConfig) {
                WritableSupplier<ColumnarInts> rSingleValuedColumn;
                WritableSupplier<ColumnarMultiInts> rMultiValuedColumn;
                Supplier dictionarySupplier;
                VERSION rVersion = VERSION.fromByte(buffer.get());
                int rFlags = rVersion.compareTo(VERSION.COMPRESSED) >= 0 ? buffer.getInt() : (rVersion.equals((Object)VERSION.UNCOMPRESSED_MULTI_VALUE) ? Feature.MULTI_VALUE.getMask() : 0);
                boolean hasMultipleValues = Feature.MULTI_VALUE.isSet(rFlags) || Feature.MULTI_VALUE_V3.isSet(rFlags);
                builder.setType(ValueType.STRING);
                int dictionaryStartPosition = buffer.position();
                byte dictionaryVersion = buffer.get();
                if (dictionaryVersion == 127) {
                    byte encodingId = buffer.get();
                    if (encodingId == 1) {
                        dictionarySupplier = FrontCodedIndexed.read(buffer, DictionaryEncodedColumnPartSerde.this.byteOrder);
                    } else {
                        if (encodingId != 0) throw new ISE("impossible, unknown encoding strategy id: %s", encodingId);
                        dictionarySupplier = GenericIndexed.read(buffer, GenericIndexed.UTF8_STRATEGY, builder.getFileMapper())::singleThreaded;
                    }
                } else {
                    buffer.position(dictionaryStartPosition);
                    dictionarySupplier = GenericIndexed.read(buffer, GenericIndexed.UTF8_STRATEGY, builder.getFileMapper())::singleThreaded;
                }
                if (hasMultipleValues) {
                    rMultiValuedColumn = this.readMultiValuedColumn(rVersion, buffer, rFlags);
                    rSingleValuedColumn = null;
                } else {
                    rSingleValuedColumn = this.readSingleValuedColumn(rVersion, buffer);
                    rMultiValuedColumn = null;
                }
                boolean hasNulls = ((Indexed)dictionarySupplier.get()).get(0) == null;
                StringUtf8DictionaryEncodedColumnSupplier supplier = new StringUtf8DictionaryEncodedColumnSupplier(dictionarySupplier, rSingleValuedColumn, rMultiValuedColumn);
                builder.setHasMultipleValues(hasMultipleValues).setHasNulls(hasNulls).setDictionaryEncodedColumnSupplier(supplier);
                GenericIndexed<ImmutableBitmap> rBitmaps = null;
                ImmutableRTree rSpatialIndex = null;
                if (!Feature.NO_BITMAP_INDEX.isSet(rFlags)) {
                    rBitmaps = GenericIndexed.read(buffer, DictionaryEncodedColumnPartSerde.this.bitmapSerdeFactory.getObjectStrategy(), builder.getFileMapper());
                }
                if (buffer.hasRemaining()) {
                    rSpatialIndex = (ImmutableRTree)new ImmutableRTreeObjectStrategy(DictionaryEncodedColumnPartSerde.this.bitmapSerdeFactory.getBitmapFactory()).fromByteBufferWithSize(buffer);
                }
                if (rBitmaps == null && rSpatialIndex == null) return;
                builder.setIndexSupplier(new StringUtf8ColumnIndexSupplier(DictionaryEncodedColumnPartSerde.this.bitmapSerdeFactory.getBitmapFactory(), dictionarySupplier, rBitmaps, rSpatialIndex), rBitmaps != null, rSpatialIndex != null);
            }

            private WritableSupplier<ColumnarInts> readSingleValuedColumn(VERSION version, ByteBuffer buffer) {
                switch (version) {
                    case UNCOMPRESSED_SINGLE_VALUE: 
                    case UNCOMPRESSED_WITH_FLAGS: {
                        return VSizeColumnarInts.readFromByteBuffer(buffer);
                    }
                    case COMPRESSED: {
                        return CompressedVSizeColumnarIntsSupplier.fromByteBuffer(buffer, DictionaryEncodedColumnPartSerde.this.byteOrder);
                    }
                }
                throw new IAE("Unsupported single-value version[%s]", new Object[]{version});
            }

            private WritableSupplier<ColumnarMultiInts> readMultiValuedColumn(VERSION version, ByteBuffer buffer, int flags) {
                switch (version) {
                    case UNCOMPRESSED_MULTI_VALUE: {
                        return VSizeColumnarMultiInts.readFromByteBuffer(buffer);
                    }
                    case UNCOMPRESSED_WITH_FLAGS: {
                        if (Feature.MULTI_VALUE.isSet(flags)) {
                            return VSizeColumnarMultiInts.readFromByteBuffer(buffer);
                        }
                        throw new IAE("Unrecognized multi-value flag[%d] for version[%s]", new Object[]{flags, version});
                    }
                    case COMPRESSED: {
                        if (Feature.MULTI_VALUE.isSet(flags)) {
                            return CompressedVSizeColumnarMultiIntsSupplier.fromByteBuffer(buffer, DictionaryEncodedColumnPartSerde.this.byteOrder);
                        }
                        if (Feature.MULTI_VALUE_V3.isSet(flags)) {
                            return V3CompressedVSizeColumnarMultiIntsSupplier.fromByteBuffer(buffer, DictionaryEncodedColumnPartSerde.this.byteOrder);
                        }
                        throw new IAE("Unrecognized multi-value flag[%d] for version[%s]", new Object[]{flags, version});
                    }
                }
                throw new IAE("Unsupported multi-value version[%s]", new Object[]{version});
            }
        };
    }

    private static boolean mustWriteFlags(int flags) {
        return flags != 0 && flags != Feature.MULTI_VALUE.getMask();
    }

    public static class SerializerBuilder {
        private int flags = STARTING_FLAGS;
        @Nullable
        private VERSION version = null;
        @Nullable
        private DictionaryWriter<String> dictionaryWriter = null;
        @Nullable
        private ColumnarIntsSerializer valueWriter = null;
        @Nullable
        private BitmapSerdeFactory bitmapSerdeFactory = null;
        @Nullable
        private GenericIndexedWriter<ImmutableBitmap> bitmapIndexWriter = null;
        @Nullable
        private ByteBufferWriter<ImmutableRTree> spatialIndexWriter = null;
        @Nullable
        private ByteOrder byteOrder = null;

        public SerializerBuilder withDictionary(DictionaryWriter<String> dictionaryWriter) {
            this.dictionaryWriter = dictionaryWriter;
            return this;
        }

        public SerializerBuilder withBitmapSerdeFactory(BitmapSerdeFactory bitmapSerdeFactory) {
            this.bitmapSerdeFactory = bitmapSerdeFactory;
            return this;
        }

        public SerializerBuilder withBitmapIndex(@Nullable GenericIndexedWriter<ImmutableBitmap> bitmapIndexWriter) {
            this.flags = bitmapIndexWriter == null ? (this.flags |= Feature.NO_BITMAP_INDEX.getMask()) : (this.flags &= ~Feature.NO_BITMAP_INDEX.getMask());
            this.bitmapIndexWriter = bitmapIndexWriter;
            return this;
        }

        public SerializerBuilder withSpatialIndex(ByteBufferWriter<ImmutableRTree> spatialIndexWriter) {
            this.spatialIndexWriter = spatialIndexWriter;
            return this;
        }

        public SerializerBuilder withByteOrder(ByteOrder byteOrder) {
            this.byteOrder = byteOrder;
            return this;
        }

        public SerializerBuilder withValue(ColumnarIntsSerializer valueWriter, boolean hasMultiValue, boolean compressed) {
            this.valueWriter = valueWriter;
            if (hasMultiValue) {
                if (compressed) {
                    this.version = VERSION.COMPRESSED;
                    this.flags |= Feature.MULTI_VALUE_V3.getMask();
                } else {
                    this.version = VERSION.UNCOMPRESSED_MULTI_VALUE;
                    this.flags |= Feature.MULTI_VALUE.getMask();
                }
            } else {
                this.version = compressed ? VERSION.COMPRESSED : VERSION.UNCOMPRESSED_SINGLE_VALUE;
            }
            return this;
        }

        public DictionaryEncodedColumnPartSerde build() {
            if (DictionaryEncodedColumnPartSerde.mustWriteFlags(this.flags) && this.version.compareTo(VERSION.COMPRESSED) < 0) {
                this.version = VERSION.UNCOMPRESSED_WITH_FLAGS;
            }
            return new DictionaryEncodedColumnPartSerde(this.byteOrder, this.bitmapSerdeFactory, new Serializer(){

                @Override
                public long getSerializedSize() throws IOException {
                    long size = 1 + (version.compareTo(VERSION.COMPRESSED) >= 0 ? 4 : 0);
                    if (dictionaryWriter != null) {
                        size += dictionaryWriter.getSerializedSize();
                    }
                    if (valueWriter != null) {
                        size += valueWriter.getSerializedSize();
                    }
                    if (bitmapIndexWriter != null) {
                        size += bitmapIndexWriter.getSerializedSize();
                    }
                    if (spatialIndexWriter != null) {
                        size += spatialIndexWriter.getSerializedSize();
                    }
                    return size;
                }

                @Override
                public void writeTo(WritableByteChannel channel, FileSmoosher smoosher) throws IOException {
                    Channels.writeFully(channel, ByteBuffer.wrap(new byte[]{version.asByte()}));
                    if (version.compareTo(VERSION.COMPRESSED) >= 0) {
                        channel.write(ByteBuffer.wrap(Ints.toByteArray((int)flags)));
                    }
                    if (dictionaryWriter != null) {
                        dictionaryWriter.writeTo(channel, smoosher);
                    }
                    if (valueWriter != null) {
                        valueWriter.writeTo(channel, smoosher);
                    }
                    if (bitmapIndexWriter != null) {
                        bitmapIndexWriter.writeTo(channel, smoosher);
                    }
                    if (spatialIndexWriter != null) {
                        spatialIndexWriter.writeTo(channel, smoosher);
                    }
                }
            });
        }
    }

    public static enum VERSION {
        UNCOMPRESSED_SINGLE_VALUE,
        UNCOMPRESSED_MULTI_VALUE,
        COMPRESSED,
        UNCOMPRESSED_WITH_FLAGS;


        public static VERSION fromByte(byte b) {
            VERSION[] values = VERSION.values();
            Preconditions.checkArgument((b < values.length ? 1 : 0) != 0, (String)"Unsupported dictionary column version[%s]", (Object[])new Object[]{b});
            return values[b];
        }

        public byte asByte() {
            return (byte)this.ordinal();
        }
    }

    public static enum Feature {
        MULTI_VALUE,
        MULTI_VALUE_V3,
        NO_BITMAP_INDEX;


        public boolean isSet(int flags) {
            return (this.getMask() & flags) != 0;
        }

        public int getMask() {
            return 1 << this.ordinal();
        }
    }
}

