/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.virtual;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.java.util.common.NonnullPair;
import org.apache.druid.math.expr.Evals;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.ExpressionProcessing;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.math.expr.InputBindings;
import org.apache.druid.query.dimension.DefaultDimensionSpec;
import org.apache.druid.query.extraction.ExtractionFn;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.BaseObjectColumnValueSelector;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.ConstantExprEvalSelector;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.NilColumnValueSelector;
import org.apache.druid.segment.RowIdSupplier;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.data.IndexedInts;
import org.apache.druid.segment.virtual.ExpressionColumnValueSelector;
import org.apache.druid.segment.virtual.ExpressionMultiValueDimensionSelector;
import org.apache.druid.segment.virtual.ExpressionPlan;
import org.apache.druid.segment.virtual.ExpressionPlanner;
import org.apache.druid.segment.virtual.ExpressionSingleValueDimensionSelector;
import org.apache.druid.segment.virtual.RowBasedExpressionColumnValueSelector;
import org.apache.druid.segment.virtual.SingleLongInputCachingExpressionColumnValueSelector;
import org.apache.druid.segment.virtual.SingleStringInputCachingExpressionColumnValueSelector;
import org.apache.druid.segment.virtual.SingleStringInputDeferredEvaluationExpressionDimensionSelector;

public class ExpressionSelectors {
    private ExpressionSelectors() {
    }

    public static ColumnValueSelector makeColumnValueSelector(ColumnSelectorFactory columnSelectorFactory, Expr expression) {
        final ColumnValueSelector<ExprEval> baseSelector = ExpressionSelectors.makeExprEvalSelector(columnSelectorFactory, expression);
        return new ColumnValueSelector(){

            @Override
            public double getDouble() {
                return baseSelector.getDouble();
            }

            @Override
            public float getFloat() {
                return baseSelector.getFloat();
            }

            @Override
            public long getLong() {
                return baseSelector.getLong();
            }

            @Override
            public boolean isNull() {
                return baseSelector.isNull();
            }

            @Override
            @Nullable
            public Object getObject() {
                ExprEval eval = (ExprEval)baseSelector.getObject();
                return eval.valueOrDefault();
            }

            @Override
            public Class classOfObject() {
                return Object.class;
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                inspector.visit("baseSelector", baseSelector);
            }
        };
    }

    public static ColumnValueSelector makeStringColumnValueSelector(ColumnSelectorFactory columnSelectorFactory, Expr expression) {
        final ColumnValueSelector<ExprEval> baseSelector = ExpressionSelectors.makeExprEvalSelector(columnSelectorFactory, expression);
        return new ColumnValueSelector(){

            @Override
            public double getDouble() {
                return baseSelector.getDouble();
            }

            @Override
            public float getFloat() {
                return baseSelector.getFloat();
            }

            @Override
            public long getLong() {
                return baseSelector.getLong();
            }

            @Override
            public boolean isNull() {
                return baseSelector.isNull();
            }

            @Override
            @Nullable
            public Object getObject() {
                ExprEval eval = (ExprEval)baseSelector.getObject();
                return ExpressionSelectors.coerceEvalToObjectOrList(eval);
            }

            @Override
            public Class classOfObject() {
                return Object.class;
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                inspector.visit("baseSelector", baseSelector);
            }
        };
    }

    public static ColumnValueSelector<ExprEval> makeExprEvalSelector(ColumnSelectorFactory columnSelectorFactory, Expr expression) {
        Expr.ObjectBinding bindings;
        ExpressionPlan plan = ExpressionPlanner.plan(columnSelectorFactory, expression);
        RowIdSupplier rowIdSupplier = columnSelectorFactory.getRowIdSupplier();
        if (plan.is(ExpressionPlan.Trait.SINGLE_INPUT_SCALAR)) {
            String column = plan.getSingleInputName();
            ColumnType inputType = plan.getSingleInputType();
            if (inputType.is(ValueType.LONG)) {
                return new SingleLongInputCachingExpressionColumnValueSelector(columnSelectorFactory.makeColumnValueSelector(column), plan.getExpression(), !"__time".equals(column), rowIdSupplier);
            }
            if (inputType.is(ValueType.STRING)) {
                return new SingleStringInputCachingExpressionColumnValueSelector(columnSelectorFactory.makeDimensionSelector(new DefaultDimensionSpec(column, column, ColumnType.STRING)), plan.getExpression(), rowIdSupplier);
            }
        }
        if ((bindings = ExpressionSelectors.createBindings(columnSelectorFactory, plan)).equals(InputBindings.nilBindings())) {
            return new ConstantExprEvalSelector(plan.getExpression().eval(bindings));
        }
        if (plan.any(ExpressionPlan.Trait.UNKNOWN_INPUTS, ExpressionPlan.Trait.INCOMPLETE_INPUTS)) {
            return new RowBasedExpressionColumnValueSelector(plan, bindings, rowIdSupplier);
        }
        return new ExpressionColumnValueSelector(plan.getAppliedExpression(), bindings, rowIdSupplier);
    }

    public static DimensionSelector makeDimensionSelector(ColumnSelectorFactory columnSelectorFactory, Expr expression, @Nullable ExtractionFn extractionFn) {
        ColumnValueSelector<ExprEval> baseSelector;
        ExpressionPlan plan = ExpressionPlanner.plan(columnSelectorFactory, expression);
        if (plan.any(ExpressionPlan.Trait.SINGLE_INPUT_SCALAR, ExpressionPlan.Trait.SINGLE_INPUT_MAPPABLE)) {
            String column = plan.getSingleInputName();
            if (plan.getSingleInputType().is(ValueType.STRING)) {
                return new SingleStringInputDeferredEvaluationExpressionDimensionSelector(columnSelectorFactory.makeDimensionSelector(DefaultDimensionSpec.of(column)), expression);
            }
        }
        if ((baseSelector = ExpressionSelectors.makeExprEvalSelector(columnSelectorFactory, expression)) instanceof ConstantExprEvalSelector) {
            if (plan.is(ExpressionPlan.Trait.NON_SCALAR_OUTPUT)) {
                Object[] value = ((ExprEval)baseSelector.getObject()).asArray();
                List stringList = value != null ? Arrays.stream(value).map(Evals::asString).collect(Collectors.toList()) : null;
                return DimensionSelector.multiConstant(stringList, extractionFn);
            }
            return DimensionSelector.constant(((ExprEval)baseSelector.getObject()).asString(), extractionFn);
        }
        if (baseSelector instanceof NilColumnValueSelector) {
            return DimensionSelector.constant(null);
        }
        if (plan.any(ExpressionPlan.Trait.NON_SCALAR_OUTPUT, ExpressionPlan.Trait.NEEDS_APPLIED, ExpressionPlan.Trait.UNKNOWN_INPUTS, ExpressionPlan.Trait.INCOMPLETE_INPUTS)) {
            return ExpressionMultiValueDimensionSelector.fromValueSelector(baseSelector, extractionFn);
        }
        return ExpressionSingleValueDimensionSelector.fromValueSelector(baseSelector, extractionFn);
    }

    public static boolean canMapOverDictionary(Expr.BindingAnalysis bindingAnalysis, @Nullable ColumnCapabilities columnCapabilities) {
        Preconditions.checkState((bindingAnalysis.getRequiredBindings().size() == 1 ? 1 : 0) != 0, (Object)"requiredBindings.size == 1");
        return columnCapabilities != null && !columnCapabilities.hasMultipleValues().isUnknown() && !bindingAnalysis.hasInputArrays() && !bindingAnalysis.isOutputArray();
    }

    public static Expr.ObjectBinding createBindings(ColumnSelectorFactory columnSelectorFactory, ExpressionPlan plan) {
        List<String> columns = plan.getAnalysis().getRequiredBindingsList();
        HashMap suppliers = new HashMap();
        for (String columnName : columns) {
            ColumnValueSelector selector;
            Object supplier;
            boolean homogenizeNullMultiValueStringArrays;
            ColumnCapabilities capabilities = columnSelectorFactory.getColumnCapabilities(columnName);
            boolean multiVal = capabilities != null && capabilities.hasMultipleValues().isTrue();
            ExpressionType expressionType = ExpressionType.fromColumnType(capabilities);
            boolean useObjectSupplierForMultiValueStringArray = capabilities != null && (!capabilities.is(ValueType.STRING) || capabilities.is(ValueType.STRING) && !ExpressionProcessing.isHomogenizeNullMultiValueStringArrays() && !plan.is(ExpressionPlan.Trait.NEEDS_APPLIED)) && plan.is(ExpressionPlan.Trait.NON_SCALAR_OUTPUT);
            boolean bl = homogenizeNullMultiValueStringArrays = plan.is(ExpressionPlan.Trait.NEEDS_APPLIED) || ExpressionProcessing.isHomogenizeNullMultiValueStringArrays();
            if (capabilities == null || useObjectSupplierForMultiValueStringArray) {
                supplier = ExpressionSelectors.supplierFromObjectSelector(columnSelectorFactory.makeColumnValueSelector(columnName), homogenizeNullMultiValueStringArrays);
            } else if (capabilities.isArray()) {
                supplier = ExpressionSelectors.supplierFromObjectSelector(columnSelectorFactory.makeColumnValueSelector(columnName), false);
            } else if (capabilities.is(ValueType.FLOAT)) {
                selector = columnSelectorFactory.makeColumnValueSelector(columnName);
                supplier = ExpressionSelectors.makeNullableNumericSupplier(selector, selector::getFloat);
            } else if (capabilities.is(ValueType.LONG)) {
                selector = columnSelectorFactory.makeColumnValueSelector(columnName);
                supplier = ExpressionSelectors.makeNullableNumericSupplier(selector, selector::getLong);
            } else if (capabilities.is(ValueType.DOUBLE)) {
                selector = columnSelectorFactory.makeColumnValueSelector(columnName);
                supplier = ExpressionSelectors.makeNullableNumericSupplier(selector, selector::getDouble);
            } else {
                supplier = capabilities.is(ValueType.STRING) ? ExpressionSelectors.supplierFromDimensionSelector(columnSelectorFactory.makeDimensionSelector(new DefaultDimensionSpec(columnName, columnName)), multiVal, homogenizeNullMultiValueStringArrays) : (!((selector = columnSelectorFactory.makeColumnValueSelector(columnName)) instanceof NilColumnValueSelector) ? selector::getObject : null);
            }
            if (supplier == null) continue;
            suppliers.put(columnName, InputBindings.inputSupplier(expressionType, supplier));
        }
        if (suppliers.isEmpty()) {
            return InputBindings.nilBindings();
        }
        if (suppliers.size() == 1 && columns.size() == 1) {
            InputBindings.InputSupplier supplier = (InputBindings.InputSupplier)Iterables.getOnlyElement(suppliers.values());
            return InputBindings.forInputSupplier(supplier.getType(), supplier);
        }
        return InputBindings.forInputSuppliers(suppliers);
    }

    @VisibleForTesting
    public static <T> Supplier<T> makeNullableNumericSupplier(ColumnValueSelector selector, Supplier<T> supplier) {
        if (NullHandling.replaceWithDefault()) {
            return supplier;
        }
        return () -> {
            if (selector.isNull()) {
                return null;
            }
            return supplier.get();
        };
    }

    @VisibleForTesting
    static Supplier<Object> supplierFromDimensionSelector(DimensionSelector selector, boolean coerceArray, boolean homogenize) {
        Preconditions.checkNotNull((Object)selector, (Object)"selector");
        return () -> {
            IndexedInts row = selector.getRow();
            if (row.size() == 1 && !coerceArray) {
                return selector.lookupName(row.get(0));
            }
            if (row.size() == 0 || row.size() == 1 && selector.getObject() == null) {
                if (homogenize) {
                    return new Object[]{null};
                }
                return null;
            }
            Object[] strings = new Object[row.size()];
            for (int i = 0; i < row.size(); ++i) {
                strings[i] = selector.lookupName(row.get(i));
            }
            return strings;
        };
    }

    @Nullable
    static Supplier<Object> supplierFromObjectSelector(BaseObjectColumnValueSelector<?> selector, boolean homogenizeMultiValue) {
        Class<Object> clazz;
        block7: {
            block6: {
                if (selector instanceof NilColumnValueSelector) {
                    return null;
                }
                clazz = selector.classOfObject();
                if (Number.class.isAssignableFrom(clazz)) break block6;
                if (!String.class.isAssignableFrom(clazz)) break block7;
            }
            return selector::getObject;
        }
        if (clazz.isAssignableFrom(Number.class) || clazz.isAssignableFrom(String.class)) {
            return () -> {
                Object val = selector.getObject();
                if (val instanceof List) {
                    NonnullPair<ExpressionType, Object[]> coerced = ExprEval.coerceListToArray((List)val, homogenizeMultiValue);
                    if (coerced == null) {
                        return null;
                    }
                    return coerced.rhs;
                }
                return val;
            };
        }
        if (clazz.isAssignableFrom(List.class)) {
            return () -> {
                Object val = selector.getObject();
                if (val != null) {
                    NonnullPair<ExpressionType, Object[]> coerced = ExprEval.coerceListToArray((List)val, homogenizeMultiValue);
                    if (coerced == null) {
                        return null;
                    }
                    return coerced.rhs;
                }
                return null;
            };
        }
        return selector::getObject;
    }

    @Nullable
    public static Object coerceEvalToObjectOrList(ExprEval eval) {
        if (eval.type().isArray()) {
            Object[] asArray = eval.asArray();
            if (asArray == null) {
                return null;
            }
            if (asArray.length == 1) {
                return asArray[0];
            }
            return Arrays.stream(asArray).collect(Collectors.toList());
        }
        return eval.valueOrDefault();
    }
}

